/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.webserver;

import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.Props$;
import akka.util.Timeout;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import org.mashupbots.socko.events.SockoEvent;
import org.mashupbots.socko.infrastructure.Logger$class;
import org.mashupbots.socko.infrastructure.WebLogWriter;
import org.mashupbots.socko.webserver.PipelineFactory;
import org.mashupbots.socko.webserver.SslManager;
import org.mashupbots.socko.webserver.WebLogConfig;
import org.mashupbots.socko.webserver.WebServer$;
import org.mashupbots.socko.webserver.WebServerConfig;
import org.mashupbots.socko.webserver.WebSocketConnections;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u0017\tIq+\u001a2TKJ4XM\u001d\u0006\u0003\u0007\u0011\t\u0011b^3cg\u0016\u0014h/\u001a:\u000b\u0005\u00151\u0011!B:pG.|'BA\u0004\t\u0003)i\u0017m\u001d5va\n|Go\u001d\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\bj]\u001a\u0014\u0018m\u001d;sk\u000e$XO]3\n\u0005]!\"A\u0002'pO\u001e,'\u000f\u0003\u0005\u001a\u0001\t\u0015\r\u0011\"\u0001\u001b\u0003\u0019\u0019wN\u001c4jOV\t1\u0004\u0005\u0002\u001d;5\t!!\u0003\u0002\u001f\u0005\tyq+\u001a2TKJ4XM]\"p]\u001aLw\r\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\u001c\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001B\t\u0001\u0003\u0006\u0004%\taI\u0001\u0007e>,H/Z:\u0016\u0003\u0011\u0002B!D\u0013([%\u0011aE\u0004\u0002\u0010!\u0006\u0014H/[1m\rVt7\r^5p]B\u0011\u0001fK\u0007\u0002S)\u0011!\u0006B\u0001\u0007KZ,g\u000e^:\n\u00051J#AC*pG.|WI^3oiB\u0011QBL\u0005\u0003_9\u0011A!\u00168ji\"A\u0011\u0007\u0001B\u0001B\u0003%A%A\u0004s_V$Xm\u001d\u0011\t\u0011M\u0002!Q1A\u0005\u0002Q\nA\"Y2u_J4\u0015m\u0019;pef,\u0012!\u000e\t\u0003mmj\u0011a\u000e\u0006\u0003qe\nQ!Y2u_JT\u0011AO\u0001\u0005C.\\\u0017-\u0003\u0002=o\ty\u0011i\u0019;peJ+gMR1di>\u0014\u0018\u0010\u0003\u0005?\u0001\t\u0005\t\u0015!\u00036\u00035\t7\r^8s\r\u0006\u001cGo\u001c:zA!)\u0001\t\u0001C\u0001\u0003\u00061A(\u001b8jiz\"BAQ\"E\u000bB\u0011A\u0004\u0001\u0005\u00063}\u0002\ra\u0007\u0005\u0006E}\u0002\r\u0001\n\u0005\u0006g}\u0002\r!\u000e\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0003-\tG\u000e\\\"iC:tW\r\\:\u0016\u0003%\u0003\"AS*\u000e\u0003-S!\u0001T'\u0002\u000b\u001d\u0014x.\u001e9\u000b\u00059{\u0015aB2iC:tW\r\u001c\u0006\u0003!F\u000bQA\\3uifT\u0011AU\u0001\u0003S>L!\u0001V&\u0003'\u0011+g-Y;mi\u000eC\u0017M\u001c8fY\u001e\u0013x.\u001e9\t\rY\u0003\u0001\u0015!\u0003J\u00031\tG\u000e\\\"iC:tW\r\\:!\u0011\u001dA\u0006A1A\u0005\u0002e\u000bAc^3c'>\u001c7.\u001a;D_:tWm\u0019;j_:\u001cX#\u0001.\u0011\u0005qY\u0016B\u0001/\u0003\u0005Q9VMY*pG.,GoQ8o]\u0016\u001cG/[8og\"1a\f\u0001Q\u0001\ni\u000bQc^3c'>\u001c7.\u001a;D_:tWm\u0019;j_:\u001c\b\u0005C\u0004a\u0001\t\u0007I\u0011A1\u0002\u0015M\u001cH.T1oC\u001e,'/F\u0001c!\ri1-Z\u0005\u0003I:\u0011aa\u00149uS>t\u0007C\u0001\u000fg\u0013\t9'A\u0001\u0006Tg2l\u0015M\\1hKJDa!\u001b\u0001!\u0002\u0013\u0011\u0017aC:tY6\u000bg.Y4fe\u0002Bqa\u001b\u0001C\u0002\u0013\u0005A.\u0001\u0007xK\ndunZ,sSR,'/F\u0001n!\ri1M\u001c\t\u0003m=L!\u0001]\u001c\u0003\u0011\u0005\u001bGo\u001c:SK\u001aDaA\u001d\u0001!\u0002\u0013i\u0017!D<fE2{wm\u0016:ji\u0016\u0014\b\u0005C\u0003u\u0001\u0011\u0005Q/A\u0003ti\u0006\u0014H\u000fF\u0001.\u0011\u00159\b\u0001\"\u0001v\u0003\u0011\u0019Ho\u001c9")
public class WebServer
implements org.mashupbots.socko.infrastructure.Logger {
    private final WebServerConfig config;
    private final PartialFunction<SockoEvent, BoxedUnit> routes;
    private final ActorRefFactory actorFactory;
    private final DefaultChannelGroup allChannels;
    private final WebSocketConnections webSocketConnections;
    private final Option<SslManager> sslManager;
    private final Option<ActorRef> webLogWriter;
    private final Logger log;
    private volatile boolean bitmap$0;

    private Logger log$lzycompute() {
        WebServer webServer = this;
        synchronized (webServer) {
            if (!this.bitmap$0) {
                this.log = Logger$class.log(this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$0 ? this.log : this.log$lzycompute();
    }

    public WebServerConfig config() {
        return this.config;
    }

    public PartialFunction<SockoEvent, BoxedUnit> routes() {
        return this.routes;
    }

    public ActorRefFactory actorFactory() {
        return this.actorFactory;
    }

    public DefaultChannelGroup allChannels() {
        return this.allChannels;
    }

    public WebSocketConnections webSocketConnections() {
        return this.webSocketConnections;
    }

    public Option<SslManager> sslManager() {
        return this.sslManager;
    }

    public Option<ActorRef> webLogWriter() {
        return this.webLogWriter;
    }

    public void start() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        this.allChannels().clear();
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        Option<Object> option = this.config().tcp().noDelay();
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.TCP_NODELAY, (Object)((Boolean)(!option.isEmpty() ? option.get() : BoxesRunTime.boxToBoolean((boolean)true))));
        if (this.config().tcp().sendBufferSize().isDefined()) {
            int n = BoxesRunTime.unboxToInt((Object)this.config().tcp().sendBufferSize().get());
            Predef$ predef$ = Predef$.MODULE$;
            boxedUnit5 = bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)n);
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        if (this.config().tcp().receiveBufferSize().isDefined()) {
            int n = BoxesRunTime.unboxToInt((Object)this.config().tcp().receiveBufferSize().get());
            Predef$ predef$ = Predef$.MODULE$;
            boxedUnit4 = bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)n);
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        if (this.config().tcp().keepAlive().isDefined()) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)this.config().tcp().keepAlive().get());
            Predef$ predef$ = Predef$.MODULE$;
            boxedUnit3 = bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)bl);
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (this.config().tcp().soLinger().isDefined()) {
            int n = BoxesRunTime.unboxToInt((Object)this.config().tcp().soLinger().get());
            Predef$ predef$ = Predef$.MODULE$;
            boxedUnit2 = bootstrap.childOption(ChannelOption.SO_LINGER, (Object)n);
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Object object = this.config().tcp().trafficClass().isDefined() ? bootstrap.childOption(ChannelOption.IP_TOS, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)this.config().tcp().trafficClass().get()))) : BoxedUnit.UNIT;
        if (this.config().tcp().reuseAddress().isDefined()) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)this.config().tcp().reuseAddress().get());
            Predef$ predef$ = Predef$.MODULE$;
            boxedUnit = bootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)bl);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object2 = this.config().tcp().acceptBackLog().isDefined() ? bootstrap.childOption(ChannelOption.SO_BACKLOG, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)this.config().tcp().acceptBackLog().get()))) : BoxedUnit.UNIT;
        bootstrap.childHandler((ChannelHandler)new PipelineFactory(this));
        Object[] objectArray = this.config().hostname().split(",");
        Predef$ predef$ = Predef$.MODULE$;
        ChannelFuture[] bindFutures = (ChannelFuture[])new ArrayOps.ofRef(objectArray).collect((PartialFunction)new Serializable(this, bootstrap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebServer $outer;
            private final ServerBootstrap bootstrap$1;

            public final <A1 extends String, B1> B1 applyOrElse(A1 address, Function1<A1, B1> function1) {
                String string = address.trim();
                Object object = !("0.0.0.0" != null ? !"0.0.0.0".equals(string) : string != null) ? this.bootstrap$1.bind(this.$outer.config().port()) : (address.isEmpty() ? function1.apply(address) : this.bootstrap$1.bind(address, this.$outer.config().port()));
                return (B1)object;
            }

            public final boolean isDefinedAt(String address) {
                String string = address.trim();
                boolean bl = !("0.0.0.0" != null ? !"0.0.0.0".equals(string) : string != null) ? true : !address.isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bootstrap$1 = bootstrap$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ChannelFuture.class)));
        Object[] objectArray2 = bindFutures;
        Predef$ predef$2 = Predef$.MODULE$;
        Object[] objectArray3 = (Object[])new ArrayOps.ofRef(objectArray2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Channel apply(ChannelFuture x$1) {
                return x$1.channel();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Channel.class)));
        Predef$ predef$3 = Predef$.MODULE$;
        this.allChannels().addAll((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)new ArrayOps.ofRef(objectArray3).toList()));
        CountDownLatch latch = new CountDownLatch(bindFutures.length);
        ChannelFutureListener bindFutureListener = new ChannelFutureListener(this, latch){
            private final CountDownLatch latch$1;

            public void operationComplete(ChannelFuture future) {
                this.latch$1.countDown();
            }
            {
                this.latch$1 = latch$1;
            }
        };
        Predef$.MODULE$.refArrayOps((Object[])bindFutures).foreach((Function1)new Serializable(this, bindFutureListener){
            public static final long serialVersionUID = 0L;
            private final ChannelFutureListener bindFutureListener$1;

            public final ChannelFuture apply(ChannelFuture x$2) {
                return x$2.addListener((GenericFutureListener)this.bindFutureListener$1);
            }
            {
                this.bindFutureListener$1 = bindFutureListener$1;
            }
        });
        latch.await();
        this.log().info("Socko server '{}' started on {}:{}", new Object[]{this.config().serverName(), this.config().hostname(), ((Object)BoxesRunTime.boxToInteger((int)this.config().port())).toString()});
    }

    public void stop() {
        ChannelGroupFuture future = this.allChannels().close();
        future.awaitUninterruptibly();
        this.allChannels().clear();
        this.log().info("Socko server '{}' stopped", new Object[]{this.config().serverName()});
    }

    public WebServer(WebServerConfig config, PartialFunction<SockoEvent, BoxedUnit> routes, ActorRefFactory actorFactory) {
        None$ none$;
        this.config = config;
        this.routes = routes;
        this.actorFactory = actorFactory;
        Logger$class.$init$(this);
        Predef$.MODULE$.require(config != null);
        config.validate();
        this.allChannels = new DefaultChannelGroup(config.serverName(), (EventExecutor)GlobalEventExecutor.INSTANCE);
        this.webSocketConnections = new WebSocketConnections(new StringBuilder().append((Object)config.serverName()).append((Object)"-websockets").toString());
        Object object = this.sslManager = config.ssl().isEmpty() ? None$.MODULE$ : new Some((Object)new SslManager(this));
        if (config.webLog().isEmpty()) {
            none$ = None$.MODULE$;
        } else if (((WebLogConfig)config.webLog().get()).customActorPath().isEmpty()) {
            none$ = new Some((Object)actorFactory.actorOf(Props$.MODULE$.apply((Function0)new $anonfun$3(this), ClassTag$.MODULE$.apply(WebLogWriter.class))));
        } else {
            Timeout timeout = new Timeout(new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
            ActorRef actorRef = (ActorRef)Await$.MODULE$.result((Awaitable)actorFactory.actorSelection((String)((WebLogConfig)config.webLog().get()).customActorPath().get()).resolveOne(timeout), (Duration)timeout.duration());
            none$ = new Some((Object)actorRef);
        }
        this.webLogWriter = none$;
    }
}

