/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.webserver;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.npn.NextProtoNego;
import org.mashupbots.socko.infrastructure.Logger$class;
import org.mashupbots.socko.netty.SpdyServerProvider;
import org.mashupbots.socko.webserver.HttpConfig;
import org.mashupbots.socko.webserver.ProtocolNegoitationHandler;
import org.mashupbots.socko.webserver.SslManager;
import org.mashupbots.socko.webserver.WebServer;
import org.slf4j.Logger;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001a2A!\u0001\u0002\u0001\u0017\ty\u0001+\u001b9fY&tWMR1di>\u0014\u0018P\u0003\u0002\u0004\t\u0005Iq/\u001a2tKJ4XM\u001d\u0006\u0003\u000b\u0019\tQa]8dW>T!a\u0002\u0005\u0002\u00155\f7\u000f[;qE>$8OC\u0001\n\u0003\ry'oZ\u0002\u0001'\r\u0001A\u0002\b\t\u0004\u001bQ1R\"\u0001\b\u000b\u0005=\u0001\u0012aB2iC:tW\r\u001c\u0006\u0003#I\tQA\\3uifT\u0011aE\u0001\u0003S>L!!\u0006\b\u0003%\rC\u0017M\u001c8fY&s\u0017\u000e^5bY&TXM\u001d\t\u0003/ii\u0011\u0001\u0007\u0006\u000339\taa]8dW\u0016$\u0018BA\u000e\u0019\u00055\u0019vnY6fi\u000eC\u0017M\u001c8fYB\u0011Q\u0004I\u0007\u0002=)\u0011q\u0004B\u0001\u000fS:4'/Y:ueV\u001cG/\u001e:f\u0013\t\tcD\u0001\u0004M_\u001e<WM\u001d\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u000511/\u001a:wKJ\u0004\"!\n\u0014\u000e\u0003\tI!a\n\u0002\u0003\u0013]+'mU3sm\u0016\u0014\b\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\b\u0006\u0002,YA\u0011Q\u0005\u0001\u0005\u0006G!\u0002\r\u0001\n\u0005\u0006]\u0001!\teL\u0001\fS:LGo\u00115b]:,G\u000e\u0006\u00021mA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t!QK\\5u\u0011\u00159T\u00061\u0001\u0017\u0003\t\u0019\u0007\u000e")
public class PipelineFactory
extends ChannelInitializer<SocketChannel>
implements org.mashupbots.socko.infrastructure.Logger {
    private final WebServer server;
    private final Logger log;
    private volatile boolean bitmap$0;

    private Logger log$lzycompute() {
        PipelineFactory pipelineFactory = this;
        synchronized (pipelineFactory) {
            if (!this.bitmap$0) {
                this.log = Logger$class.log(this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$0 ? this.log : this.log$lzycompute();
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.server.config().http().spdyEnabled()) {
            SSLEngine sslEngine = ((SslManager)this.server.sslManager().get()).createSSLEngine();
            SslHandler ssl = new SslHandler(sslEngine);
            pipeline.addLast("ssl", (ChannelHandler)ssl);
            NextProtoNego.put((SSLEngine)sslEngine, (NextProtoNego.Provider)new SpdyServerProvider());
            NextProtoNego.debug = this.log().isDebugEnabled();
            pipeline.addLast("pipeLineSelector", (ChannelHandler)new ProtocolNegoitationHandler(this.server));
        } else {
            BoxedUnit boxedUnit;
            HttpConfig httpConfig = this.server.config().http();
            if (this.server.sslManager().isDefined()) {
                SSLEngine sslEngine = ((SslManager)this.server.sslManager().get()).createSSLEngine();
                SslHandler ssl = new SslHandler(sslEngine);
                boxedUnit = pipeline.addLast("ssl", (ChannelHandler)ssl);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            HttpRequestDecoder httpRequestDecoder = new HttpRequestDecoder(httpConfig.maxInitialLineLength(), httpConfig.maxHeaderSizeInBytes(), httpConfig.maxChunkSizeInBytes());
            pipeline.addLast("decoder", (ChannelHandler)httpRequestDecoder);
            Object object = httpConfig.aggreateChunks() ? pipeline.addLast("chunkAggregator", (ChannelHandler)new HttpObjectAggregator(httpConfig.maxLengthInBytes())) : BoxedUnit.UNIT;
            pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            pipeline.addLast("chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
            Object object2 = this.server.config().idleConnectionTimeout().toSeconds() > 0L ? pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, (int)this.server.config().idleConnectionTimeout().toSeconds())) : BoxedUnit.UNIT;
            pipeline.addLast("handler", (ChannelHandler)this.server.handler());
        }
    }

    public PipelineFactory(WebServer server) {
        this.server = server;
        Logger$class.$init$(this);
    }
}

