/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.stream.ChunkedInput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class HttpChunkedFile
implements ChunkedInput<HttpContent> {
    static final int DEFAULT_CHUNK_SIZE = 8192;
    private final RandomAccessFile file;
    private final long startOffset;
    private final long endOffset;
    private final int chunkSize;
    private long offset;
    private volatile boolean sentLastChunk = false;

    public HttpChunkedFile(File file) throws IOException {
        this(file, 8192);
    }

    public HttpChunkedFile(File file, int n) throws IOException {
        this(new RandomAccessFile(file, "r"), n);
    }

    public HttpChunkedFile(RandomAccessFile randomAccessFile) throws IOException {
        this(randomAccessFile, 8192);
    }

    public HttpChunkedFile(RandomAccessFile randomAccessFile, int n) throws IOException {
        this(randomAccessFile, 0L, randomAccessFile.length(), n);
    }

    public HttpChunkedFile(RandomAccessFile randomAccessFile, long l, long l2, int n) throws IOException {
        if (randomAccessFile == null) {
            throw new NullPointerException("file");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("offset: " + l + " (expected: 0 or greater)");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("length: " + l2 + " (expected: 0 or greater)");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("chunkSize: " + n + " (expected: a positive integer)");
        }
        this.file = randomAccessFile;
        this.offset = this.startOffset = l;
        this.endOffset = l + l2;
        this.chunkSize = n;
        randomAccessFile.seek(l);
    }

    public long startOffset() {
        return this.startOffset;
    }

    public long endOffset() {
        return this.endOffset;
    }

    public long currentOffset() {
        return this.offset;
    }

    public boolean isEndOfInput() throws Exception {
        if (this.offset < this.endOffset && this.file.getChannel().isOpen()) {
            return false;
        }
        return this.sentLastChunk;
    }

    public void close() throws Exception {
        this.file.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpContent readChunk(ChannelHandlerContext channelHandlerContext) throws Exception {
        long l = this.offset;
        if (l >= this.endOffset) {
            if (this.sentLastChunk) {
                return null;
            }
            this.sentLastChunk = true;
            return new DefaultLastHttpContent();
        }
        int n = (int)Math.min((long)this.chunkSize, this.endOffset - l);
        ByteBuf byteBuf = channelHandlerContext.alloc().heapBuffer(n);
        boolean bl = true;
        try {
            this.file.readFully(byteBuf.array(), byteBuf.arrayOffset(), n);
            byteBuf.writerIndex(n);
            this.offset = l + (long)n;
            bl = false;
            DefaultHttpContent defaultHttpContent = new DefaultHttpContent(byteBuf);
            return defaultHttpContent;
        }
        finally {
            if (bl) {
                byteBuf.release();
            }
        }
    }
}

