/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.webserver;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.mashupbots.socko.events.HttpChunkEvent;
import org.mashupbots.socko.events.HttpEventConfig;
import org.mashupbots.socko.events.HttpLastChunkEvent;
import org.mashupbots.socko.events.HttpRequestEvent;
import org.mashupbots.socko.events.InitialHttpRequestMessage;
import org.mashupbots.socko.events.SockoEvent;
import org.mashupbots.socko.events.WebSocketEventConfig;
import org.mashupbots.socko.events.WebSocketFrameEvent;
import org.mashupbots.socko.events.WebSocketHandshakeEvent;
import org.mashupbots.socko.infrastructure.CharsetUtil$;
import org.mashupbots.socko.infrastructure.Logger$class;
import org.mashupbots.socko.webserver.RequestHandler;
import org.mashupbots.socko.webserver.WebServer;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\u0001\u0003\u0001-\u0011aBU3rk\u0016\u001cH\u000fS1oI2,'O\u0003\u0002\u0004\t\u0005Iq/\u001a2tKJ4XM\u001d\u0006\u0003\u000b\u0019\tQa]8dW>T!a\u0002\u0005\u0002\u00155\f7\u000f[;qE>$8OC\u0001\n\u0003\ry'oZ\u0002\u0001'\r\u0001AB\u0006\t\u0003\u001bQi\u0011A\u0004\u0006\u0003\u001fA\tqa\u00195b]:,GN\u0003\u0002\u0012%\u0005)a.\u001a;us*\t1#\u0001\u0002j_&\u0011QC\u0004\u0002\u001d\u0007\"\fgN\\3m\u0013:\u0014w.\u001e8e\u0011\u0006tG\r\\3s\u0003\u0012\f\u0007\u000f^3s!\t9\"$D\u0001\u0019\u0015\tIB!\u0001\bj]\u001a\u0014\u0018m\u001d;sk\u000e$XO]3\n\u0005mA\"A\u0002'pO\u001e,'\u000f\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003\u0019\u0019XM\u001d<feB\u0011q\u0004I\u0007\u0002\u0005%\u0011\u0011E\u0001\u0002\n/\u0016\u00147+\u001a:wKJD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0007e>,H/Z:\u0011\t\u0015B#\u0006M\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\ty\u0001+\u0019:uS\u0006dg)\u001e8di&|g\u000e\u0005\u0002,]5\tAF\u0003\u0002.\t\u00051QM^3oiNL!a\f\u0017\u0003\u0015M{7m[8Fm\u0016tG\u000f\u0005\u0002&c%\u0011!G\n\u0002\u0005+:LG\u000fC\u00035\u0001\u0011\u0005Q'\u0001\u0004=S:LGO\u0010\u000b\u0004m]B\u0004CA\u0010\u0001\u0011\u0015i2\u00071\u0001\u001f\u0011\u0015\u00193\u00071\u0001%\u0011\u001dQ\u0004\u00011A\u0005\nm\nAb^:IC:$7\u000f[1lKJ,\u0012\u0001\u0010\t\u0003{\u0019k\u0011A\u0010\u0006\u0003\u007f\u0001\u000b!b^3cg>\u001c7.\u001a;y\u0015\t\t%)\u0001\u0003iiR\u0004(BA\"E\u0003\u0015\u0019w\u000eZ3d\u0015\t)\u0005#A\u0004iC:$G.\u001a:\n\u0005\u001ds$!G,fEN{7m[3u'\u0016\u0014h/\u001a:IC:$7\u000f[1lKJDq!\u0013\u0001A\u0002\u0013%!*\u0001\txg\"\u000bg\u000eZ:iC.,'o\u0018\u0013fcR\u0011\u0001g\u0013\u0005\b\u0019\"\u000b\t\u00111\u0001=\u0003\rAH%\r\u0005\u0007\u001d\u0002\u0001\u000b\u0015\u0002\u001f\u0002\u001b]\u001c\b*\u00198eg\"\f7.\u001a:!\u0011\u001d\u0001\u0006\u00011A\u0005\nE\u000b!#\u001b8ji&\fG\u000e\u0013;uaJ+\u0017/^3tiV\t!\u000bE\u0002&'VK!\u0001\u0016\u0014\u0003\r=\u0003H/[8o!\tYc+\u0003\u0002XY\tI\u0012J\\5uS\u0006d\u0007\n\u001e;q%\u0016\fX/Z:u\u001b\u0016\u001c8/Y4f\u0011\u001dI\u0006\u00011A\u0005\ni\u000ba#\u001b8ji&\fG\u000e\u0013;uaJ+\u0017/^3ti~#S-\u001d\u000b\u0003amCq\u0001\u0014-\u0002\u0002\u0003\u0007!\u000b\u0003\u0004^\u0001\u0001\u0006KAU\u0001\u0014S:LG/[1m\u0011R$\bOU3rk\u0016\u001cH\u000f\t\u0005\b?\u0002\u0011\r\u0011\"\u0003a\u0003)AG\u000f\u001e9D_:4\u0017nZ\u000b\u0002CB\u00111FY\u0005\u0003G2\u0012q\u0002\u0013;ua\u00163XM\u001c;D_:4\u0017n\u001a\u0005\u0007K\u0002\u0001\u000b\u0011B1\u0002\u0017!$H\u000f]\"p]\u001aLw\r\t\u0005\tO\u0002A)\u0019!C\u0005Q\u0006Aqo]\"p]\u001aLw-F\u0001j!\tY#.\u0003\u0002lY\t!r+\u001a2T_\u000e\\W\r^#wK:$8i\u001c8gS\u001eD\u0001\"\u001c\u0001\t\u0002\u0003\u0006K![\u0001\noN\u001cuN\u001c4jO\u0002BQa\u001c\u0001\u0005BA\f!#^:fe\u00163XM\u001c;Ue&<w-\u001a:fIR\u0019\u0001'\u001d<\t\u000bIt\u0007\u0019A:\u0002\u0007\r$\b\u0010\u0005\u0002\u000ei&\u0011QO\u0004\u0002\u0016\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s\u0007>tG/\u001a=u\u0011\u00159h\u000e1\u0001y\u0003\r)g\u000f\u001e\t\u0003szl\u0011A\u001f\u0006\u0003wr\fA\u0001\\1oO*\tQ0\u0001\u0003kCZ\f\u0017BA@{\u0005\u0019y%M[3di\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0011aC2iC:tW\r\u001c*fC\u0012$R\u0001MA\u0004\u0003\u0013AaA]A\u0001\u0001\u0004\u0019\b\u0002CA\u0006\u0003\u0003\u0001\r!!\u0004\u0002\u0003\u0015\u00042!JA\b\u0013\r\t\tB\n\u0002\u0007\u0003:L(+\u001a4\t\u000f\u0005U\u0001\u0001\"\u0003\u0002\u0018\u0005\u0011b/\u00197jI\u0006$XMR5sgR\u001c\u0005.\u001e8l)\r\u0001\u0014\u0011\u0004\u0005\t\u00037\t\u0019\u00021\u0001\u0002\u001e\u0005)QM^3oiB\u00191&a\b\n\u0007\u0005\u0005BF\u0001\tIiR\u0004(+Z9vKN$XI^3oi\"9\u0011Q\u0005\u0001\u0005\n\u0005\u001d\u0012!\u0005<bY&$\u0017\r^3MCN$8\t[;oWR\u0019\u0001'!\u000b\t\u0011\u0005m\u00111\u0005a\u0001\u0003W\u00012aKA\u0017\u0013\r\ty\u0003\f\u0002\u0013\u0011R$\b\u000fT1ti\u000eCWO\\6Fm\u0016tG\u000fC\u0004\u00024\u0001!\t%!\u000e\u0002\u001f\u0015D8-\u001a9uS>t7)Y;hQR$R\u0001MA\u001c\u0003sAaA]A\u0019\u0001\u0004\u0019\b\u0002CA\u0006\u0003c\u0001\r!a\u000f\u0011\t\u0005u\u0012Q\n\b\u0005\u0003\u007f\tIE\u0004\u0003\u0002B\u0005\u001dSBAA\"\u0015\r\t)EC\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dJ1!a\u0013'\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0014\u0002R\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003\u00172\u0003bBA+\u0001\u0011%\u0011qK\u0001\u0013oJLG/Z#se>\u0014(+Z:q_:\u001cX\rF\u00041\u00033\nY&a\u001a\t\rI\f\u0019\u00061\u0001t\u0011!\ti&a\u0015A\u0002\u0005}\u0013AB:uCR,8\u000f\u0005\u0003\u0002b\u0005\rT\"\u0001!\n\u0007\u0005\u0015\u0004I\u0001\nIiR\u0004(+Z:q_:\u001cXm\u0015;biV\u001c\b\u0002CA5\u0003'\u0002\r!a\u000f\u0002\u0005\u0015D\bbBA7\u0001\u0011\u0005\u0013qN\u0001\u000eG\"\fgN\\3m\u0003\u000e$\u0018N^3\u0015\u0007A\n\t\b\u0003\u0004s\u0003W\u0002\ra\u001d\u0005\b\u0003k\u0002A\u0011BA<\u0003]\u0019'/Z1uK^+'mU8dW\u0016$Hj\\2bi&|g\u000e\u0006\u0003\u0002z\u0005\u001d\u0005\u0003BA>\u0003\u0003s1!JA?\u0013\r\tyHJ\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0015Q\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}d\u0005\u0003\u0005\u0002\f\u0005M\u0004\u0019AAE!\rY\u00131R\u0005\u0004\u0003\u001bc#aF,fEN{7m[3u\u0011\u0006tGm\u001d5bW\u0016,e/\u001a8u\u0011\u001d\t\t\n\u0001C\u0005\u0003'\u000bA\u0003Z8XK\n\u001cvnY6fi\"\u000bg\u000eZ:iC.,Gc\u0001\u0019\u0002\u0016\"A\u00111DAH\u0001\u0004\tI\tC\u0004\u0002\u001a\u0002!I!a'\u0002\u001f%\u001c8k\u0015'D_:tWm\u0019;j_:$B!!(\u0002$B\u0019Q%a(\n\u0007\u0005\u0005fEA\u0004C_>dW-\u00198\t\u000f=\t9\n1\u0001\u0002&B\u0019Q\"a*\n\u0007\u0005%fBA\u0004DQ\u0006tg.\u001a7\t\u000f\u00055\u0006\u0001\"\u0003\u00020\u0006\u0011\u0012n]!hOJ,\u0017\r^5oO\u000eCWO\\6t)\u0011\ti*!-\t\u000f=\tY\u000b1\u0001\u0002&\u0002")
public class RequestHandler
extends ChannelInboundHandlerAdapter
implements org.mashupbots.socko.infrastructure.Logger {
    private final WebServer server;
    private final PartialFunction<SockoEvent, BoxedUnit> routes;
    private WebSocketServerHandshaker wsHandshaker;
    private Option<InitialHttpRequestMessage> initialHttpRequest;
    private final HttpEventConfig httpConfig;
    private WebSocketEventConfig wsConfig;
    private final Logger log;
    private volatile byte bitmap$0;

    private WebSocketEventConfig wsConfig$lzycompute() {
        RequestHandler requestHandler = this;
        synchronized (requestHandler) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.wsConfig = new WebSocketEventConfig(this.server.config().serverName(), this.server.webLogWriter());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.wsConfig;
        }
    }

    private Logger log$lzycompute() {
        RequestHandler requestHandler = this;
        synchronized (requestHandler) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.log = Logger$class.log(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.log$lzycompute() : this.log;
    }

    private WebSocketServerHandshaker wsHandshaker() {
        return this.wsHandshaker;
    }

    private void wsHandshaker_$eq(WebSocketServerHandshaker x$1) {
        this.wsHandshaker = x$1;
    }

    private Option<InitialHttpRequestMessage> initialHttpRequest() {
        return this.initialHttpRequest;
    }

    private void initialHttpRequest_$eq(Option<InitialHttpRequestMessage> x$1) {
        this.initialHttpRequest = x$1;
    }

    private HttpEventConfig httpConfig() {
        return this.httpConfig;
    }

    private WebSocketEventConfig wsConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.wsConfig$lzycompute() : this.wsConfig;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent idleStateEvent = (IdleStateEvent)evt;
            IdleState idleState = idleStateEvent.state();
            if (idleState != null && idleState.equals(IdleState.ALL_IDLE)) {
                ctx.close();
            }
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object e) {
        block10: {
            WebSocketFrame webSocketFrame;
            block16: {
                block6: {
                    block15: {
                        block14: {
                            block13: {
                                WebSocketFrameEvent event;
                                block12: {
                                    block11: {
                                        block9: {
                                            block8: {
                                                block7: {
                                                    block5: {
                                                        if (!(e instanceof FullHttpRequest)) break block5;
                                                        FullHttpRequest fullHttpRequest = (FullHttpRequest)e;
                                                        HttpRequestEvent event2 = new HttpRequestEvent(ctx, (HttpRequest)fullHttpRequest, this.httpConfig());
                                                        this.log().debug("HTTP FULL REQUEST {} CHANNEL={} {}", new Object[]{event2.endPoint(), ctx.name(), ""});
                                                        if (event2.request().isWebSocketUpgrade()) {
                                                            WebSocketHandshakeEvent wsctx = new WebSocketHandshakeEvent(ctx, fullHttpRequest, this.httpConfig());
                                                            this.routes.apply((Object)wsctx);
                                                            this.doWebSocketHandshake(wsctx);
                                                            this.initialHttpRequest_$eq((Option<InitialHttpRequestMessage>)new Some((Object)new InitialHttpRequestMessage(event2.request(), event2.createdOn())));
                                                        } else {
                                                            BoxedUnit cfr_ignored_0 = (BoxedUnit)this.routes.apply((Object)event2);
                                                        }
                                                        break block6;
                                                    }
                                                    if (!(e instanceof HttpRequest)) break block7;
                                                    HttpRequest httpRequest = (HttpRequest)e;
                                                    HttpRequestEvent event3 = new HttpRequestEvent(ctx, httpRequest, this.httpConfig());
                                                    this.log().debug("HTTP REQUEST {} CHANNEL={} {}", new Object[]{event3.endPoint(), ctx.name(), ""});
                                                    this.validateFirstChunk(event3);
                                                    this.routes.apply((Object)event3);
                                                    this.initialHttpRequest_$eq((Option<InitialHttpRequestMessage>)new Some((Object)new InitialHttpRequestMessage(event3.request(), event3.createdOn())));
                                                    break block6;
                                                }
                                                if (!(e instanceof LastHttpContent)) break block8;
                                                LastHttpContent lastHttpContent = (LastHttpContent)e;
                                                HttpLastChunkEvent event4 = new HttpLastChunkEvent(ctx, (InitialHttpRequestMessage)this.initialHttpRequest().get(), lastHttpContent, this.httpConfig());
                                                this.log().debug("HTTP LAST CHUNK {} CHANNEL={} {}", new Object[]{event4.endPoint(), ctx.name(), ""});
                                                this.routes.apply((Object)event4);
                                                this.validateLastChunk(event4);
                                                break block6;
                                            }
                                            if (!(e instanceof HttpContent)) break block9;
                                            HttpContent httpContent = (HttpContent)e;
                                            HttpChunkEvent event5 = new HttpChunkEvent(ctx, (InitialHttpRequestMessage)this.initialHttpRequest().get(), httpContent, this.httpConfig());
                                            InitialHttpRequestMessage initialHttpRequestMessage = (InitialHttpRequestMessage)this.initialHttpRequest().get();
                                            initialHttpRequestMessage.totalChunkContentLength_$eq(initialHttpRequestMessage.totalChunkContentLength() + (long)httpContent.content().readableBytes());
                                            this.log().debug("HTTP CHUNK {} CHANNEL={} {}", new Object[]{event5.endPoint(), ctx.name(), ""});
                                            BoxedUnit cfr_ignored_1 = (BoxedUnit)this.routes.apply((Object)event5);
                                            break block6;
                                        }
                                        if (!(e instanceof WebSocketFrame)) break block10;
                                        webSocketFrame = (WebSocketFrame)e;
                                        event = new WebSocketFrameEvent(ctx, (InitialHttpRequestMessage)this.initialHttpRequest().get(), webSocketFrame, this.wsConfig());
                                        this.log().debug("WS {} CHANNEL={} {}", new Object[]{event.endPoint(), ctx.name(), ""});
                                        if (!(webSocketFrame instanceof TextWebSocketFrame)) break block11;
                                        BoxedUnit cfr_ignored_2 = (BoxedUnit)this.routes.apply((Object)event);
                                        break block6;
                                    }
                                    if (!(webSocketFrame instanceof BinaryWebSocketFrame)) break block12;
                                    BoxedUnit cfr_ignored_3 = (BoxedUnit)this.routes.apply((Object)event);
                                    break block6;
                                }
                                if (!(webSocketFrame instanceof ContinuationWebSocketFrame)) break block13;
                                BoxedUnit cfr_ignored_4 = (BoxedUnit)this.routes.apply((Object)event);
                                break block6;
                            }
                            if (!(webSocketFrame instanceof CloseWebSocketFrame)) break block14;
                            CloseWebSocketFrame closeWebSocketFrame = (CloseWebSocketFrame)webSocketFrame;
                            this.wsHandshaker().close(ctx.channel(), closeWebSocketFrame);
                            break block6;
                        }
                        if (!(webSocketFrame instanceof PingWebSocketFrame)) break block15;
                        PingWebSocketFrame pingWebSocketFrame = (PingWebSocketFrame)webSocketFrame;
                        ctx.writeAndFlush((Object)new PongWebSocketFrame(pingWebSocketFrame.isFinalFragment(), pingWebSocketFrame.rsv(), pingWebSocketFrame.content()));
                        break block6;
                    }
                    if (!(webSocketFrame instanceof PongWebSocketFrame)) break block16;
                    webSocketFrame.release();
                }
                return;
            }
            throw new UnsupportedOperationException(new StringBuilder().append((Object)"Web socket frame not supported: ").append((Object)webSocketFrame.getClass().getName()).toString());
        }
        throw new UnsupportedOperationException(new StringBuilder().append((Object)e.getClass().toString()).append((Object)" not supported").toString());
    }

    private void validateFirstChunk(HttpRequestEvent event) {
        if (this.isAggreatingChunks(event.context().channel())) {
            if (event.request().isChunked() && this.initialHttpRequest().isDefined()) {
                throw new IllegalStateException("New chunk started before the previous chunk ended");
            }
            if (!event.request().isChunked() && this.initialHttpRequest().isDefined()) {
                throw new IllegalStateException("New request received before the previous chunk ended");
            }
        } else if (event.request().isChunked()) {
            throw new IllegalStateException("Received a chunk when chunks should have been aggreated");
        }
    }

    private void validateLastChunk(HttpLastChunkEvent event) {
        if (this.isAggreatingChunks(event.context().channel())) {
            this.initialHttpRequest_$eq((Option<InitialHttpRequestMessage>)None$.MODULE$);
            return;
        }
        throw new IllegalStateException("Received a chunk when chunks should have been aggreated");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        this.log().error("Exception caught in HttpRequestHandler", e);
        if (e instanceof MatchError) {
            MatchError matchError = (MatchError)e;
            this.writeErrorResponse(ctx, HttpResponseStatus.NOT_FOUND, (Throwable)matchError);
        } else if (e instanceof TooLongFrameException) {
            TooLongFrameException tooLongFrameException = (TooLongFrameException)e;
            this.writeErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST, (Throwable)tooLongFrameException);
        } else if (e instanceof UnsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)e;
            this.writeErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST, unsupportedOperationException);
        } else if (e instanceof WebSocketHandshakeException) {
            WebSocketHandshakeException webSocketHandshakeException = (WebSocketHandshakeException)e;
            this.writeErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST, (Throwable)webSocketHandshakeException);
        } else {
            try {
                this.log().debug("Error handling request", e);
                ctx.channel().close();
            }
            catch (Throwable throwable) {
                this.log().debug("Error closing channel", throwable);
            }
        }
    }

    private void writeErrorResponse(ChannelHandlerContext ctx, HttpResponseStatus status, Throwable ex) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S Z");
        Predef$ predef$ = Predef$.MODULE$;
        new StringOps("Failure: %s\n\n%s\n\n%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{status.toString(), ex == null ? "" : ex.getMessage(), sf.format(Calendar.getInstance().getTime())}));
        byte[] bytes = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failure: ", "\\r\\n\\r\\n", "\\r\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{status, ex.getMessage()})).getBytes(CharsetUtil$.MODULE$.UTF_8());
        ByteBuf content = Unpooled.wrappedBuffer((byte[])bytes);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        response.headers().set("Content-Type", (Object)"text/plain; charset=UTF-8");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.server.allChannels().add(ctx.channel());
    }

    private String createWebSocketLocation(WebSocketHandshakeEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isSSLConnection(e.context().channel()) ? "wss" : "ws");
        sb.append("://");
        sb.append(e.request().headers().get("Host"));
        sb.append(e.endPoint().uri());
        return sb.toString();
    }

    private void doWebSocketHandshake(WebSocketHandshakeEvent event) {
        if (event.isAuthorized()) {
            String string = event.authorizedSubprotocols();
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.createWebSocketLocation(event), (String)(string != null && string.equals("") ? null : event.authorizedSubprotocols()), false, event.maxFrameSize());
            this.wsHandshaker_$eq(wsFactory.newHandshaker((HttpRequest)event.nettyHttpRequest()));
            if (this.wsHandshaker() == null) {
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)event.context().channel());
                event.writeWebLog(HttpResponseStatus.UPGRADE_REQUIRED.code(), 0L);
            } else {
                String id = event.webSocketId();
                ChannelFuture future = this.wsHandshaker().handshake(event.context().channel(), event.nettyHttpRequest());
                event.writeWebLog(HttpResponseStatus.SWITCHING_PROTOCOLS.code(), 0L);
                this.server.webSocketConnections().add(event.context().channel());
                public class Org_mashupbots_socko_webserver_RequestHandler$OnCompleteListender$1
                implements ChannelFutureListener {
                    public final /* synthetic */ RequestHandler $outer;
                    private final WebSocketHandshakeEvent event$1;
                    private final String id$1;

                    public void operationComplete(ChannelFuture future) {
                        ((Function1)this.event$1.onComplete().get()).apply((Object)this.id$1);
                    }

                    public /* synthetic */ RequestHandler org$mashupbots$socko$webserver$RequestHandler$OnCompleteListender$$$outer() {
                        return this.$outer;
                    }

                    public Org_mashupbots_socko_webserver_RequestHandler$OnCompleteListender$1(RequestHandler $outer, WebSocketHandshakeEvent event$1, String id$1) {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.event$1 = event$1;
                        this.id$1 = id$1;
                    }
                }
                Object object = event.onComplete().isDefined() ? future.addListener((GenericFutureListener)new Org_mashupbots_socko_webserver_RequestHandler$OnCompleteListender$1(this, event, id)) : BoxedUnit.UNIT;
                if (event.onClose().isDefined()) {
                    public class Org_mashupbots_socko_webserver_RequestHandler$OnCloseListender$1
                    implements ChannelFutureListener {
                        public final /* synthetic */ RequestHandler $outer;
                        private final WebSocketHandshakeEvent event$1;
                        private final String id$1;

                        public void operationComplete(ChannelFuture future) {
                            ((Function1)this.event$1.onClose().get()).apply((Object)this.id$1);
                        }

                        public /* synthetic */ RequestHandler org$mashupbots$socko$webserver$RequestHandler$OnCloseListender$$$outer() {
                            return this.$outer;
                        }

                        public Org_mashupbots_socko_webserver_RequestHandler$OnCloseListender$1(RequestHandler $outer, WebSocketHandshakeEvent event$1, String id$1) {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.event$1 = event$1;
                            this.id$1 = id$1;
                        }
                    }
                    event.context().channel().closeFuture().addListener((GenericFutureListener)new Org_mashupbots_socko_webserver_RequestHandler$OnCloseListender$1(this, event, id));
                }
            }
            return;
        }
        throw new UnsupportedOperationException("Websocket not supported at this end point");
    }

    private boolean isSSLConnection(Channel channel) {
        return channel.pipeline().get(SslHandler.class) != null;
    }

    private boolean isAggreatingChunks(Channel channel) {
        return channel.pipeline().get(HttpObjectAggregator.class) != null;
    }

    public RequestHandler(WebServer server, PartialFunction<SockoEvent, BoxedUnit> routes) {
        this.server = server;
        this.routes = routes;
        Logger$class.$init$(this);
        this.wsHandshaker = null;
        this.initialHttpRequest = None$.MODULE$;
        this.httpConfig = new HttpEventConfig(server.config().serverName(), server.config().http().minCompressibleContentSizeInBytes(), server.config().http().maxCompressibleContentSizeInBytes(), server.config().http().compressibleContentTypes(), server.webLogWriter());
    }
}

