/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.webserver;

import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.Props$;
import akka.util.Timeout;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import org.mashupbots.socko.events.SockoEvent;
import org.mashupbots.socko.infrastructure.Logger$class;
import org.mashupbots.socko.infrastructure.WebLogWriter;
import org.mashupbots.socko.webserver.PipelineFactory;
import org.mashupbots.socko.webserver.RequestHandler;
import org.mashupbots.socko.webserver.SslManager;
import org.mashupbots.socko.webserver.WebLogConfig;
import org.mashupbots.socko.webserver.WebServer$;
import org.mashupbots.socko.webserver.WebServerConfig;
import org.mashupbots.socko.webserver.WebSocketConnections;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001-\u0011\u0011bV3c'\u0016\u0014h/\u001a:\u000b\u0005\r!\u0011!C<fEN,'O^3s\u0015\t)a!A\u0003t_\u000e\\wN\u0003\u0002\b\u0011\u0005QQ.Y:ikB\u0014w\u000e^:\u000b\u0003%\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u000fS:4'/Y:ueV\u001cG/\u001e:f\u0013\t9BC\u0001\u0004M_\u001e<WM\u001d\u0005\t3\u0001\u0011)\u0019!C\u00015\u000511m\u001c8gS\u001e,\u0012a\u0007\t\u00039ui\u0011AA\u0005\u0003=\t\u0011qbV3c'\u0016\u0014h/\u001a:D_:4\u0017n\u001a\u0005\tA\u0001\u0011\t\u0011)A\u00057\u000591m\u001c8gS\u001e\u0004\u0003\u0002\u0003\u0012\u0001\u0005\u000b\u0007I\u0011A\u0012\u0002\u0019\u0005\u001cGo\u001c:GC\u000e$xN]=\u0016\u0003\u0011\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003%\nA!Y6lC&\u00111F\n\u0002\u0010\u0003\u000e$xN\u001d*fM\u001a\u000b7\r^8ss\"AQ\u0006\u0001B\u0001B\u0003%A%A\u0007bGR|'OR1di>\u0014\u0018\u0010\t\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005q\u0001.\u00198eY\u0016\u0014h)Y2u_JL\b\u0003B\u00072gQJ!A\r\b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\u000f\u0001!\t)D(D\u00017\u0015\t9\u0004(A\u0004dQ\u0006tg.\u001a7\u000b\u0005eR\u0014!\u00028fiRL(\"A\u001e\u0002\u0005%|\u0017BA\u001f7\u0005U\u0019\u0005.\u00198oK2LeNY8v]\u0012D\u0015M\u001c3mKJDQa\u0010\u0001\u0005\u0002\u0001\u000ba\u0001P5oSRtD\u0003B\u001aB\u0005\u000eCQ!\u0007 A\u0002mAQA\t A\u0002\u0011BQa\f A\u0002ABQa\u0010\u0001\u0005\u0002\u0015#Ba\r$H+\")\u0011\u0004\u0012a\u00017!)\u0001\n\u0012a\u0001\u0013\u00061!o\\;uKN\u0004B!\u0004&M%&\u00111J\u0004\u0002\u0010!\u0006\u0014H/[1m\rVt7\r^5p]B\u0011Q\nU\u0007\u0002\u001d*\u0011q\nB\u0001\u0007KZ,g\u000e^:\n\u0005Es%AC*pG.|WI^3oiB\u0011QbU\u0005\u0003):\u0011A!\u00168ji\")!\u0005\u0012a\u0001I!1q\u000b\u0001C\u0001\u0005a\u000bq\u0001[1oI2,'\u000fF\u00015\u0011\u001dQ\u0006A1A\u0005\u0002m\u000b1\"\u00197m\u0007\"\fgN\\3mgV\tA\f\u0005\u0002^A6\taL\u0003\u0002`m\u0005)qM]8va&\u0011\u0011M\u0018\u0002\u0014\t\u00164\u0017-\u001e7u\u0007\"\fgN\\3m\u000fJ|W\u000f\u001d\u0005\u0007G\u0002\u0001\u000b\u0011\u0002/\u0002\u0019\u0005dGn\u00115b]:,Gn\u001d\u0011\t\u000f\u0015\u0004!\u0019!C\u0001M\u0006!r/\u001a2T_\u000e\\W\r^\"p]:,7\r^5p]N,\u0012a\u001a\t\u00039!L!!\u001b\u0002\u0003)]+'mU8dW\u0016$8i\u001c8oK\u000e$\u0018n\u001c8t\u0011\u0019Y\u0007\u0001)A\u0005O\u0006)r/\u001a2T_\u000e\\W\r^\"p]:,7\r^5p]N\u0004\u0003bB7\u0001\u0005\u0004%\tA\\\u0001\u000bgNdW*\u00198bO\u0016\u0014X#A8\u0011\u00075\u0001(/\u0003\u0002r\u001d\t1q\n\u001d;j_:\u0004\"\u0001H:\n\u0005Q\u0014!AC*tY6\u000bg.Y4fe\"1a\u000f\u0001Q\u0001\n=\f1b]:m\u001b\u0006t\u0017mZ3sA!9\u0001\u0010\u0001b\u0001\n\u0003I\u0018\u0001D<fE2{wm\u0016:ji\u0016\u0014X#\u0001>\u0011\u00075\u00018\u0010\u0005\u0002&y&\u0011QP\n\u0002\t\u0003\u000e$xN\u001d*fM\"1q\u0010\u0001Q\u0001\ni\fQb^3c\u0019><wK]5uKJ\u0004\u0003bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u0006gR\f'\u000f\u001e\u000b\u0002%\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005\u0015\u0011\u0001B:u_B\u0004")
public class WebServer
implements org.mashupbots.socko.infrastructure.Logger {
    private final WebServerConfig config;
    private final ActorRefFactory actorFactory;
    private final Function1<WebServer, ChannelInboundHandler> handlerFactory;
    private final DefaultChannelGroup allChannels;
    private final WebSocketConnections webSocketConnections;
    private final Option<SslManager> sslManager;
    private final Option<ActorRef> webLogWriter;
    private final Logger log;
    private volatile boolean bitmap$0;

    private Logger log$lzycompute() {
        WebServer webServer = this;
        synchronized (webServer) {
            if (!this.bitmap$0) {
                this.log = Logger$class.log(this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$0 ? this.log : this.log$lzycompute();
    }

    public WebServerConfig config() {
        return this.config;
    }

    public ActorRefFactory actorFactory() {
        return this.actorFactory;
    }

    public ChannelInboundHandler handler() {
        return (ChannelInboundHandler)this.handlerFactory.apply((Object)this);
    }

    public DefaultChannelGroup allChannels() {
        return this.allChannels;
    }

    public WebSocketConnections webSocketConnections() {
        return this.webSocketConnections;
    }

    public Option<SslManager> sslManager() {
        return this.sslManager;
    }

    public Option<ActorRef> webLogWriter() {
        return this.webLogWriter;
    }

    public void start() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        this.allChannels().clear();
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        Option<Object> option = this.config().tcp().noDelay();
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.TCP_NODELAY, (Object)((Boolean)(!option.isEmpty() ? option.get() : BoxesRunTime.boxToBoolean((boolean)true))));
        if (this.config().tcp().sendBufferSize().isDefined()) {
            int n = BoxesRunTime.unboxToInt((Object)this.config().tcp().sendBufferSize().get());
            Predef$ predef$ = Predef$.MODULE$;
            boxedUnit5 = bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)n);
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        if (this.config().tcp().receiveBufferSize().isDefined()) {
            int n = BoxesRunTime.unboxToInt((Object)this.config().tcp().receiveBufferSize().get());
            Predef$ predef$ = Predef$.MODULE$;
            boxedUnit4 = bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)n);
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        if (this.config().tcp().keepAlive().isDefined()) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)this.config().tcp().keepAlive().get());
            Predef$ predef$ = Predef$.MODULE$;
            boxedUnit3 = bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)bl);
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (this.config().tcp().soLinger().isDefined()) {
            int n = BoxesRunTime.unboxToInt((Object)this.config().tcp().soLinger().get());
            Predef$ predef$ = Predef$.MODULE$;
            boxedUnit2 = bootstrap.childOption(ChannelOption.SO_LINGER, (Object)n);
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Object object = this.config().tcp().trafficClass().isDefined() ? bootstrap.childOption(ChannelOption.IP_TOS, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)this.config().tcp().trafficClass().get()))) : BoxedUnit.UNIT;
        if (this.config().tcp().reuseAddress().isDefined()) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)this.config().tcp().reuseAddress().get());
            Predef$ predef$ = Predef$.MODULE$;
            boxedUnit = bootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)bl);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object2 = this.config().tcp().acceptBackLog().isDefined() ? bootstrap.childOption(ChannelOption.SO_BACKLOG, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)this.config().tcp().acceptBackLog().get()))) : BoxedUnit.UNIT;
        bootstrap.childHandler((ChannelHandler)new PipelineFactory(this));
        Object[] objectArray = this.config().hostname().split(",");
        Predef$ predef$ = Predef$.MODULE$;
        ChannelFuture[] bindFutures = (ChannelFuture[])new ArrayOps.ofRef(objectArray).collect((PartialFunction)new Serializable(this, bootstrap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebServer $outer;
            private final ServerBootstrap bootstrap$1;

            public final <A1 extends String, B1> B1 applyOrElse(A1 address, Function1<A1, B1> function1) {
                String string = address.trim();
                Object object = "0.0.0.0".equals(string) ? this.bootstrap$1.bind(this.$outer.config().port()) : (address.isEmpty() ? function1.apply(address) : this.bootstrap$1.bind(address, this.$outer.config().port()));
                return (B1)object;
            }

            public final boolean isDefinedAt(String address) {
                String string = address.trim();
                boolean bl = "0.0.0.0".equals(string) ? true : !address.isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bootstrap$1 = bootstrap$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ChannelFuture.class)));
        Object[] objectArray2 = bindFutures;
        Predef$ predef$2 = Predef$.MODULE$;
        Object[] objectArray3 = (Object[])new ArrayOps.ofRef(objectArray2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Channel apply(ChannelFuture x$1) {
                return x$1.channel();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Channel.class)));
        Predef$ predef$3 = Predef$.MODULE$;
        this.allChannels().addAll((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)new ArrayOps.ofRef(objectArray3).toList()));
        CountDownLatch latch = new CountDownLatch(bindFutures.length);
        ChannelFutureListener bindFutureListener = new ChannelFutureListener(this, latch){
            private final CountDownLatch latch$1;

            public void operationComplete(ChannelFuture future) {
                this.latch$1.countDown();
            }
            {
                this.latch$1 = latch$1;
            }
        };
        Predef$.MODULE$.refArrayOps((Object[])bindFutures).foreach((Function1)new Serializable(this, bindFutureListener){
            public static final long serialVersionUID = 0L;
            private final ChannelFutureListener bindFutureListener$1;

            public final ChannelFuture apply(ChannelFuture x$2) {
                return x$2.addListener((GenericFutureListener)this.bindFutureListener$1);
            }
            {
                this.bindFutureListener$1 = bindFutureListener$1;
            }
        });
        latch.await();
        this.log().info("Socko server '{}' started on {}:{}", new Object[]{this.config().serverName(), this.config().hostname(), ((Object)BoxesRunTime.boxToInteger((int)this.config().port())).toString()});
    }

    public void stop() {
        ChannelGroupFuture future = this.allChannels().close();
        future.awaitUninterruptibly();
        this.allChannels().clear();
        this.log().info("Socko server '{}' stopped", new Object[]{this.config().serverName()});
    }

    public WebServer(WebServerConfig config, ActorRefFactory actorFactory, Function1<WebServer, ChannelInboundHandler> handlerFactory) {
        None$ none$;
        this.config = config;
        this.actorFactory = actorFactory;
        this.handlerFactory = handlerFactory;
        Logger$class.$init$(this);
        Predef$.MODULE$.require(config != null);
        config.validate();
        this.allChannels = new DefaultChannelGroup(config.serverName(), (EventExecutor)GlobalEventExecutor.INSTANCE);
        this.webSocketConnections = new WebSocketConnections(new StringBuilder().append((Object)config.serverName()).append((Object)"-websockets").toString());
        Object object = this.sslManager = config.ssl().isEmpty() ? None$.MODULE$ : new Some((Object)new SslManager(this));
        if (config.webLog().isEmpty()) {
            none$ = None$.MODULE$;
        } else if (((WebLogConfig)config.webLog().get()).customActorPath().isEmpty()) {
            none$ = new Some((Object)actorFactory.actorOf(Props$.MODULE$.apply((Function0)new $anonfun$3(this), ClassTag$.MODULE$.apply(WebLogWriter.class))));
        } else {
            Timeout timeout = new Timeout(new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
            ActorRef actorRef = (ActorRef)Await$.MODULE$.result((Awaitable)actorFactory.actorSelection((String)((WebLogConfig)config.webLog().get()).customActorPath().get()).resolveOne(timeout), (Duration)timeout.duration());
            none$ = new Some((Object)actorRef);
        }
        this.webLogWriter = none$;
    }

    public WebServer(WebServerConfig config, PartialFunction<SockoEvent, BoxedUnit> routes, ActorRefFactory actorFactory) {
        this(config, actorFactory, (Function1<WebServer, ChannelInboundHandler>)new Serializable(routes){
            public static final long serialVersionUID = 0L;
            private final PartialFunction routes$1;

            public final RequestHandler apply(WebServer server) {
                return new RequestHandler(server, (PartialFunction<SockoEvent, BoxedUnit>)this.routes$1);
            }
            {
                this.routes$1 = routes$1;
            }
        });
    }
}

