/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.netty;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;
import org.jboss.netty.handler.stream.ChunkedInput;

public class HttpChunkedFile
implements ChunkedInput {
    private final RandomAccessFile file;
    private final long startOffset;
    private final long endOffset;
    private final int chunkSize;
    private volatile long offset;
    private volatile boolean sentLastChunk = false;
    static final int DEFAULT_CHUNK_SIZE = 8192;

    public HttpChunkedFile(File file) throws IOException {
        this(file, 8192);
    }

    public HttpChunkedFile(File file, int n) throws IOException {
        this(new RandomAccessFile(file, "r"), n);
    }

    public HttpChunkedFile(RandomAccessFile randomAccessFile) throws IOException {
        this(randomAccessFile, 8192);
    }

    public HttpChunkedFile(RandomAccessFile randomAccessFile, int n) throws IOException {
        this(randomAccessFile, 0L, randomAccessFile.length(), n);
    }

    public HttpChunkedFile(RandomAccessFile randomAccessFile, long l, long l2, int n) throws IOException {
        if (randomAccessFile == null) {
            throw new NullPointerException("file");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("offset: " + l + " (expected: 0 or greater)");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("length: " + l2 + " (expected: 0 or greater)");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("chunkSize: " + n + " (expected: a positive integer)");
        }
        this.file = randomAccessFile;
        this.offset = this.startOffset = l;
        this.endOffset = l + l2;
        this.chunkSize = n;
        randomAccessFile.seek(l);
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    public long getCurrentOffset() {
        return this.offset;
    }

    public boolean hasNextChunk() throws Exception {
        if (this.offset < this.endOffset && this.file.getChannel().isOpen()) {
            return true;
        }
        return !this.sentLastChunk;
    }

    public boolean isEndOfInput() throws Exception {
        return !this.hasNextChunk();
    }

    public void close() throws Exception {
        this.file.close();
    }

    public Object nextChunk() throws Exception {
        long l = this.offset;
        if (l >= this.endOffset) {
            if (this.sentLastChunk) {
                return null;
            }
            this.sentLastChunk = true;
            return new DefaultHttpChunkTrailer();
        }
        int n = (int)Math.min((long)this.chunkSize, this.endOffset - l);
        byte[] byArray = new byte[n];
        this.file.readFully(byArray);
        this.offset = l + (long)n;
        return new DefaultHttpChunk(ChannelBuffers.wrappedBuffer((byte[])byArray));
    }
}

