/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.webserver;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props$;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictor;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.mashupbots.socko.events.SockoEvent;
import org.mashupbots.socko.infrastructure.Logger$class;
import org.mashupbots.socko.webserver.PipelineFactory;
import org.mashupbots.socko.webserver.SslManager;
import org.mashupbots.socko.webserver.WebLogConfig;
import org.mashupbots.socko.webserver.WebServer$;
import org.mashupbots.socko.webserver.WebServerConfig;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u0001-\u0011\u0011bV3c'\u0016\u0014h/\u001a:\u000b\u0005\r!\u0011!C<fEN,'O^3s\u0015\t)a!A\u0003t_\u000e\\wN\u0003\u0002\b\u0011\u0005QQ.Y:ikB\u0014w\u000e^:\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0007\u00155A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!AB(cU\u0016\u001cG\u000f\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u0005q\u0011N\u001c4sCN$(/^2ukJ,\u0017BA\r\u0017\u0005\u0019aunZ4feB\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\tY1kY1mC>\u0013'.Z2u\u0011!\t\u0003A!b\u0001\n\u0003\u0011\u0013AB2p]\u001aLw-F\u0001$!\t!S%D\u0001\u0003\u0013\t1#AA\bXK\n\u001cVM\u001d<fe\u000e{gNZ5h\u0011!A\u0003A!A!\u0002\u0013\u0019\u0013aB2p]\u001aLw\r\t\u0005\tU\u0001\u0011)\u0019!C\u0001W\u00051!o\\;uKN,\u0012\u0001\f\t\u000575zS'\u0003\u0002/9\ty\u0001+\u0019:uS\u0006dg)\u001e8di&|g\u000e\u0005\u00021g5\t\u0011G\u0003\u00023\t\u00051QM^3oiNL!\u0001N\u0019\u0003\u0015M{7m[8Fm\u0016tG\u000f\u0005\u0002\u001cm%\u0011q\u0007\b\u0002\u0005+:LG\u000f\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003-\u0003\u001d\u0011x.\u001e;fg\u0002B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001P\u0001\fC\u000e$xN]*zgR,W.F\u0001>!\tq4)D\u0001@\u0015\t\u0001\u0015)A\u0003bGR|'OC\u0001C\u0003\u0011\t7n[1\n\u0005\u0011{$aC!di>\u00148+_:uK6D\u0001B\u0012\u0001\u0003\u0002\u0003\u0006I!P\u0001\rC\u000e$xN]*zgR,W\u000e\t\u0005\u0006\u0011\u0002!\t!S\u0001\u0007y%t\u0017\u000e\u001e \u0015\t)[E*\u0014\t\u0003I\u0001AQ!I$A\u0002\rBQAK$A\u00021BQaO$A\u0002uBqa\u0014\u0001C\u0002\u0013\u0005\u0001+A\u0006bY2\u001c\u0005.\u00198oK2\u001cX#A)\u0011\u0005I[V\"A*\u000b\u0005Q+\u0016!B4s_V\u0004(B\u0001,X\u0003\u001d\u0019\u0007.\u00198oK2T!\u0001W-\u0002\u000b9,G\u000f^=\u000b\u0005iC\u0011!\u00026c_N\u001c\u0018B\u0001/T\u0005M!UMZ1vYR\u001c\u0005.\u00198oK2<%o\\;q\u0011\u0019q\u0006\u0001)A\u0005#\u0006a\u0011\r\u001c7DQ\u0006tg.\u001a7tA!9\u0001\r\u0001a\u0001\n\u0013\t\u0017AD2iC:tW\r\u001c$bGR|'/_\u000b\u0002EB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\u0004]&|'BA4V\u0003\u0019\u0019xnY6fi&\u0011\u0011\u000e\u001a\u0002\u001e\u001d&|7+\u001a:wKJ\u001cvnY6fi\u000eC\u0017M\u001c8fY\u001a\u000b7\r^8ss\"91\u000e\u0001a\u0001\n\u0013a\u0017AE2iC:tW\r\u001c$bGR|'/_0%KF$\"!N7\t\u000f9T\u0017\u0011!a\u0001E\u0006\u0019\u0001\u0010J\u0019\t\rA\u0004\u0001\u0015)\u0003c\u0003=\u0019\u0007.\u00198oK24\u0015m\u0019;pef\u0004\u0003b\u0002:\u0001\u0005\u0004%\ta]\u0001\u000bgNdW*\u00198bO\u0016\u0014X#\u0001;\u0011\u0007m)x/\u0003\u0002w9\t1q\n\u001d;j_:\u0004\"\u0001\n=\n\u0005e\u0014!AC*tY6\u000bg.Y4fe\"11\u0010\u0001Q\u0001\nQ\f1b]:m\u001b\u0006t\u0017mZ3sA!9Q\u0010\u0001b\u0001\n\u0003q\u0018\u0001D<fE2{wm\u0016:ji\u0016\u0014X#A@\u0011\tm)\u0018\u0011\u0001\t\u0004}\u0005\r\u0011bAA\u0003\u007f\tA\u0011i\u0019;peJ+g\rC\u0004\u0002\n\u0001\u0001\u000b\u0011B@\u0002\u001b],'\rT8h/JLG/\u001a:!\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001f\tQa\u001d;beR$\u0012!\u000e\u0005\b\u0003'\u0001A\u0011AA\b\u0003\u0011\u0019Ho\u001c9")
public class WebServer
implements org.mashupbots.socko.infrastructure.Logger,
ScalaObject {
    private final WebServerConfig config;
    private final PartialFunction<SockoEvent, BoxedUnit> routes;
    private final ActorSystem actorSystem;
    private final DefaultChannelGroup allChannels;
    private NioServerSocketChannelFactory channelFactory;
    private final Option<SslManager> sslManager;
    private final Option<ActorRef> webLogWriter;
    private final Logger log;
    public volatile int bitmap$0;

    public WebServerConfig config() {
        return this.config;
    }

    public PartialFunction<SockoEvent, BoxedUnit> routes() {
        return this.routes;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public DefaultChannelGroup allChannels() {
        return this.allChannels;
    }

    private NioServerSocketChannelFactory channelFactory() {
        return this.channelFactory;
    }

    private void channelFactory_$eq(NioServerSocketChannelFactory nioServerSocketChannelFactory) {
        this.channelFactory = nioServerSocketChannelFactory;
    }

    public Option<SslManager> sslManager() {
        return this.sslManager;
    }

    public Option<ActorRef> webLogWriter() {
        return this.webLogWriter;
    }

    /*
     * WARNING - void declaration
     */
    public void start() {
        if (this.channelFactory() == null) {
            void $inlThis1;
            this.allChannels().clear();
            this.channelFactory_$eq(new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
            ServerBootstrap bootstrap$1 = new ServerBootstrap((ChannelFactory)this.channelFactory());
            Option<Object> option = this.config().tcp().noDelay();
            bootstrap$1.setOption("child.tcpNoDelay", !option.isEmpty() ? $inlThis1.get() : BoxesRunTime.boxToBoolean((boolean)true));
            if (this.config().tcp().sendBufferSize().isDefined()) {
                bootstrap$1.setOption("child.sendBufferSize", this.config().tcp().sendBufferSize().get());
            }
            if (this.config().tcp().receiveBufferSize().isDefined()) {
                bootstrap$1.setOption("child.receiveBufferSize", this.config().tcp().receiveBufferSize().get());
                bootstrap$1.setOption("child.receiveBufferSizePredictor", (Object)new FixedReceiveBufferSizePredictor(1024));
            }
            if (this.config().tcp().keepAlive().isDefined()) {
                bootstrap$1.setOption("child.keepAlive", this.config().tcp().keepAlive().get());
            }
            if (this.config().tcp().soLinger().isDefined()) {
                bootstrap$1.setOption("child.soLinger", this.config().tcp().soLinger().get());
            }
            if (this.config().tcp().trafficClass().isDefined()) {
                bootstrap$1.setOption("child.trafficClass", this.config().tcp().trafficClass().get());
            }
            if (this.config().tcp().reuseAddress().isDefined()) {
                bootstrap$1.setOption("child.reuseAddress", this.config().tcp().reuseAddress().get());
            }
            if (this.config().tcp().acceptBackLog().isDefined()) {
                bootstrap$1.setOption("child.backlog", this.config().tcp().acceptBackLog().get());
            }
            bootstrap$1.setPipelineFactory((ChannelPipelineFactory)new PipelineFactory(this));
            Object[] objectArray = this.config().hostname().split(",");
            new ArrayOps.ofRef(objectArray).foreach((Function1)new Serializable(this, bootstrap$1){
                public static final long serialVersionUID;
                public final WebServer $outer;
                public final ServerBootstrap bootstrap$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Object apply(String address) {
                    String string;
                    String string2 = string = address.trim();
                    return !(string2 != null ? !string2.equals("0.0.0.0") : "0.0.0.0" != null) ? BoxesRunTime.boxToBoolean((boolean)this.$outer.allChannels().add(this.bootstrap$1.bind((SocketAddress)new InetSocketAddress(this.$outer.config().port())))) : (address.isEmpty() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)this.$outer.allChannels().add(this.bootstrap$1.bind((SocketAddress)new InetSocketAddress(address, this.$outer.config().port())))));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.bootstrap$1 = serverBootstrap;
                }
            });
            Object[] objectArray2 = new Object[]{this.config().serverName(), this.config().hostname(), ((Object)BoxesRunTime.boxToInteger((int)this.config().port())).toString()};
            this.log().info("Socko server '{}' started on {}:{}", (Object[])new ArrayOps.ofRef(objectArray2).toArray((ClassManifest)Manifest$.MODULE$.Object()));
            return;
        }
        this.log().info("Socko server '{}' already started", (Object)new String[]{this.config().serverName()});
    }

    public void stop() {
        ChannelGroupFuture future = this.allChannels().close();
        future.awaitUninterruptibly();
        this.allChannels().clear();
        this.channelFactory().releaseExternalResources();
        this.channelFactory_$eq(null);
        this.log().info("Socko server '{}' stopped", (Object)this.config().serverName());
    }

    public WebServer(WebServerConfig config, PartialFunction<SockoEvent, BoxedUnit> routes, ActorSystem actorSystem) {
        this.config = config;
        this.routes = routes;
        this.actorSystem = actorSystem;
        Logger$class.$init$(this);
        Predef$.MODULE$.require(config != null);
        config.validate();
        this.allChannels = new DefaultChannelGroup(config.serverName());
        this.channelFactory = null;
        Object object = this.sslManager = config.ssl().isEmpty() ? None$.MODULE$ : new Some((Object)new SslManager(this));
        this.webLogWriter = config.webLog().isEmpty() ? None$.MODULE$ : (((WebLogConfig)config.webLog().get()).customActorPath().isEmpty() ? new Some((Object)actorSystem.actorOf(Props$.MODULE$.apply((Function0)new $anonfun$1(this)))) : new Some((Object)actorSystem.actorFor((String)((WebLogConfig)config.webLog().get()).customActorPath().get())));
    }
}

