/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.netty;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;
import org.jboss.netty.handler.stream.ChunkedInput;

public class HttpChunkedFile
implements ChunkedInput {
    private final RandomAccessFile file;
    private final long startOffset;
    private final long endOffset;
    private final int chunkSize;
    private volatile long offset;
    private volatile boolean sentLastChunk = false;
    static final int DEFAULT_CHUNK_SIZE = 8192;

    public HttpChunkedFile(File file) throws IOException {
        this(file, 8192);
    }

    public HttpChunkedFile(File file, int chunkSize) throws IOException {
        this(new RandomAccessFile(file, "r"), chunkSize);
    }

    public HttpChunkedFile(RandomAccessFile file) throws IOException {
        this(file, 8192);
    }

    public HttpChunkedFile(RandomAccessFile file, int chunkSize) throws IOException {
        this(file, 0L, file.length(), chunkSize);
    }

    public HttpChunkedFile(RandomAccessFile file, long offset, long length, int chunkSize) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("offset: " + offset + " (expected: 0 or greater)");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length: " + length + " (expected: 0 or greater)");
        }
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize: " + chunkSize + " (expected: a positive integer)");
        }
        this.file = file;
        this.offset = this.startOffset = offset;
        this.endOffset = offset + length;
        this.chunkSize = chunkSize;
        file.seek(offset);
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    public long getCurrentOffset() {
        return this.offset;
    }

    public boolean hasNextChunk() throws Exception {
        if (this.offset < this.endOffset && this.file.getChannel().isOpen()) {
            return true;
        }
        return !this.sentLastChunk;
    }

    public boolean isEndOfInput() throws Exception {
        return !this.hasNextChunk();
    }

    public void close() throws Exception {
        this.file.close();
    }

    public Object nextChunk() throws Exception {
        long offset = this.offset;
        if (offset >= this.endOffset) {
            if (this.sentLastChunk) {
                return null;
            }
            this.sentLastChunk = true;
            return new DefaultHttpChunkTrailer();
        }
        int chunkSize = (int)Math.min((long)this.chunkSize, this.endOffset - offset);
        byte[] chunk = new byte[chunkSize];
        this.file.readFully(chunk);
        this.offset = offset + (long)chunkSize;
        return new DefaultHttpChunk(ChannelBuffers.wrappedBuffer((byte[])chunk));
    }
}

