/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.webserver;

import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.CharsetUtil;
import org.mashupbots.socko.events.HttpChunkEvent;
import org.mashupbots.socko.events.HttpEventConfig;
import org.mashupbots.socko.events.HttpRequestEvent;
import org.mashupbots.socko.events.InitialHttpRequestMessage;
import org.mashupbots.socko.events.WebSocketEventConfig;
import org.mashupbots.socko.events.WebSocketFrameEvent;
import org.mashupbots.socko.events.WebSocketHandshakeEvent;
import org.mashupbots.socko.infrastructure.Logger$class;
import org.mashupbots.socko.webserver.WebServer;
import org.slf4j.Logger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\u0001\u0003\u0001-\u0011aBU3rk\u0016\u001cH\u000fS1oI2,'O\u0003\u0002\u0004\t\u0005Iq/\u001a2tKJ4XM\u001d\u0006\u0003\u000b\u0019\tQa]8dW>T!a\u0002\u0005\u0002\u00155\f7\u000f[;qE>$8OC\u0001\n\u0003\ry'oZ\u0002\u0001'\u0011\u0001AB\u0006\u000f\u0011\u00055!R\"\u0001\b\u000b\u0005=\u0001\u0012aB2iC:tW\r\u001c\u0006\u0003#I\tQA\\3uifT!a\u0005\u0005\u0002\u000b)\u0014wn]:\n\u0005Uq!\u0001H*j[BdWm\u00115b]:,G.\u00169tiJ,\u0017-\u001c%b]\u0012dWM\u001d\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0011\ta\"\u001b8ge\u0006\u001cHO];diV\u0014X-\u0003\u0002\u001c1\t1Aj\\4hKJ\u0004\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u00111bU2bY\u0006|%M[3di\"A1\u0005\u0001B\u0001B\u0003%A%\u0001\u0004tKJ4XM\u001d\t\u0003K\u0019j\u0011AA\u0005\u0003O\t\u0011\u0011bV3c'\u0016\u0014h/\u001a:\t\u000b%\u0002A\u0011\u0001\u0016\u0002\rqJg.\u001b;?)\tYC\u0006\u0005\u0002&\u0001!)1\u0005\u000ba\u0001I!9a\u0006\u0001a\u0001\n\u0013y\u0013\u0001D<t\u0011\u0006tGm\u001d5bW\u0016\u0014X#\u0001\u0019\u0011\u0005ERT\"\u0001\u001a\u000b\u0005M\"\u0014AC<fEN|7m[3uq*\u0011QGN\u0001\u0005QR$\bO\u0003\u00028q\u0005)1m\u001c3fG*\u0011\u0011\bE\u0001\bQ\u0006tG\r\\3s\u0013\tY$GA\rXK\n\u001cvnY6fiN+'O^3s\u0011\u0006tGm\u001d5bW\u0016\u0014\bbB\u001f\u0001\u0001\u0004%IAP\u0001\u0011oND\u0015M\u001c3tQ\u0006\\WM]0%KF$\"a\u0010\"\u0011\u0005u\u0001\u0015BA!\u001f\u0005\u0011)f.\u001b;\t\u000f\rc\u0014\u0011!a\u0001a\u0005\u0019\u0001\u0010J\u0019\t\r\u0015\u0003\u0001\u0015)\u00031\u0003598\u000fS1oIND\u0017m[3sA!9q\t\u0001a\u0001\n\u0013A\u0015AE5oSRL\u0017\r\u001c%uiB\u0014V-];fgR,\u0012!\u0013\t\u0004;)c\u0015BA&\u001f\u0005\u0019y\u0005\u000f^5p]B\u0011Q\nU\u0007\u0002\u001d*\u0011q\nB\u0001\u0007KZ,g\u000e^:\n\u0005Es%!G%oSRL\u0017\r\u001c%uiB\u0014V-];fgRlUm]:bO\u0016Dqa\u0015\u0001A\u0002\u0013%A+\u0001\fj]&$\u0018.\u00197IiR\u0004(+Z9vKN$x\fJ3r)\tyT\u000bC\u0004D%\u0006\u0005\t\u0019A%\t\r]\u0003\u0001\u0015)\u0003J\u0003MIg.\u001b;jC2DE\u000f\u001e9SKF,Xm\u001d;!\u0011\u001dI\u0006A1A\u0005\ni\u000b!\u0002\u001b;ua\u000e{gNZ5h+\u0005Y\u0006CA']\u0013\tifJA\bIiR\u0004XI^3oi\u000e{gNZ5h\u0011\u0019y\u0006\u0001)A\u00057\u0006Y\u0001\u000e\u001e;q\u0007>tg-[4!\u0011!\t\u0007\u0001#b\u0001\n\u0013\u0011\u0017\u0001C<t\u0007>tg-[4\u0016\u0003\r\u0004\"!\u00143\n\u0005\u0015t%\u0001F,fEN{7m[3u\u000bZ,g\u000e^\"p]\u001aLw\r\u0003\u0005h\u0001!\u0005\t\u0015)\u0003d\u0003%98oQ8oM&<\u0007\u0005C\u0003j\u0001\u0011\u0005#.A\bnKN\u001c\u0018mZ3SK\u000e,\u0017N^3e)\ry4\u000e\u001d\u0005\u0006Y\"\u0004\r!\\\u0001\u0004GRD\bCA\u0007o\u0013\tygBA\u000bDQ\u0006tg.\u001a7IC:$G.\u001a:D_:$X\r\u001f;\t\u000bED\u0007\u0019\u0001:\u0002\u0003\u0015\u0004\"!D:\n\u0005Qt!\u0001D'fgN\fw-Z#wK:$\b\"\u0002<\u0001\t\u00139\u0018A\u0005<bY&$\u0017\r^3GSJ\u001cHo\u00115v].$\"a\u0010=\t\u000be,\b\u0019\u0001>\u0002\u000b\u00154XM\u001c;\u0011\u00055[\u0018B\u0001?O\u0005AAE\u000f\u001e9SKF,Xm\u001d;Fm\u0016tG\u000fC\u0003\u007f\u0001\u0011%q0A\twC2LG-\u0019;f\u0019\u0006\u001cHo\u00115v].$2aPA\u0001\u0011\u0019IX\u00101\u0001\u0002\u0004A\u0019Q*!\u0002\n\u0007\u0005\u001daJ\u0001\bIiR\u00048\t[;oW\u00163XM\u001c;\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e\u0005yQ\r_2faRLwN\\\"bk\u001eDG\u000fF\u0003@\u0003\u001f\t\t\u0002\u0003\u0004m\u0003\u0013\u0001\r!\u001c\u0005\bc\u0006%\u0001\u0019AA\n!\ri\u0011QC\u0005\u0004\u0003/q!AD#yG\u0016\u0004H/[8o\u000bZ,g\u000e\u001e\u0005\b\u00037\u0001A\u0011BA\u000f\u0003I9(/\u001b;f\u000bJ\u0014xN\u001d*fgB|gn]3\u0015\u000f}\ny\"!\t\u0002.!1A.!\u0007A\u00025D\u0001\"a\t\u0002\u001a\u0001\u0007\u0011QE\u0001\u0007gR\fG/^:\u0011\t\u0005\u001d\u0012\u0011F\u0007\u0002i%\u0019\u00111\u0006\u001b\u0003%!#H\u000f\u001d*fgB|gn]3Ti\u0006$Xo\u001d\u0005\t\u0003_\tI\u00021\u0001\u00022\u0005\u0011Q\r\u001f\t\u0005\u0003g\t\u0019E\u0004\u0003\u00026\u0005}b\u0002BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005m\"\"\u0001\u0004=e>|GOP\u0005\u0002?%\u0019\u0011\u0011\t\u0010\u0002\u000fA\f7m[1hK&!\u0011QIA$\u0005%!\u0006N]8xC\ndWMC\u0002\u0002ByAq!a\u0013\u0001\t\u0003\ni%A\u0006dQ\u0006tg.\u001a7Pa\u0016tG#B \u0002P\u0005E\u0003B\u00027\u0002J\u0001\u0007Q\u000eC\u0004r\u0003\u0013\u0002\r!a\u0015\u0011\u00075\t)&C\u0002\u0002X9\u0011\u0011c\u00115b]:,Gn\u0015;bi\u0016,e/\u001a8u\u0011\u001d\tY\u0006\u0001C\u0005\u0003;\nqc\u0019:fCR,w+\u001a2T_\u000e\\W\r\u001e'pG\u0006$\u0018n\u001c8\u0015\t\u0005}\u0013Q\u000e\t\u0005\u0003C\n9GD\u0002\u001e\u0003GJ1!!\u001a\u001f\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011NA6\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\r\u0010\t\u000f1\fI\u00061\u0001\u0002pA\u0019Q*!\u001d\n\u0007\u0005MdJA\fXK\n\u001cvnY6fi\"\u000bg\u000eZ:iC.,WI^3oi\"9\u0011q\u000f\u0001\u0005\n\u0005e\u0014\u0001\u00063p/\u0016\u00147k\\2lKRD\u0015M\u001c3tQ\u0006\\W\rF\u0002@\u0003wBq!_A;\u0001\u0004\ty\u0007C\u0004\u0002\u0000\u0001!I!!!\u0002\u001f%\u001c8k\u0015'D_:tWm\u0019;j_:$B!a!\u0002\nB\u0019Q$!\"\n\u0007\u0005\u001deDA\u0004C_>dW-\u00198\t\u000f=\ti\b1\u0001\u0002\fB\u0019Q\"!$\n\u0007\u0005=eBA\u0004DQ\u0006tg.\u001a7\t\u000f\u0005M\u0005\u0001\"\u0003\u0002\u0016\u0006\u0011\u0012n]!hOJ,\u0017\r^5oO\u000eCWO\\6t)\u0011\t\u0019)a&\t\u000f=\t\t\n1\u0001\u0002\f\u0002")
public class RequestHandler
extends SimpleChannelUpstreamHandler
implements org.mashupbots.socko.infrastructure.Logger {
    private final WebServer server;
    private WebSocketServerHandshaker wsHandshaker;
    private Option<InitialHttpRequestMessage> initialHttpRequest;
    private final HttpEventConfig httpConfig;
    private WebSocketEventConfig wsConfig;
    private final Logger log;
    private volatile int bitmap$priv$0;
    public volatile int bitmap$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger log() {
        if ((this.bitmap$0 & 1) != 0) return this.log;
        RequestHandler requestHandler = this;
        synchronized (requestHandler) {
            if ((this.bitmap$0 & 1) == 0) {
                this.log = Logger$class.log(this);
                this.bitmap$0 |= 1;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.log;
        }
    }

    private WebSocketServerHandshaker wsHandshaker() {
        return this.wsHandshaker;
    }

    private void wsHandshaker_$eq(WebSocketServerHandshaker webSocketServerHandshaker) {
        this.wsHandshaker = webSocketServerHandshaker;
    }

    private Option<InitialHttpRequestMessage> initialHttpRequest() {
        return this.initialHttpRequest;
    }

    private void initialHttpRequest_$eq(Option<InitialHttpRequestMessage> option) {
        this.initialHttpRequest = option;
    }

    private HttpEventConfig httpConfig() {
        return this.httpConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WebSocketEventConfig wsConfig() {
        if ((this.bitmap$priv$0 & 1) != 0) return this.wsConfig;
        RequestHandler requestHandler = this;
        synchronized (requestHandler) {
            if ((this.bitmap$priv$0 & 1) == 0) {
                this.wsConfig = new WebSocketEventConfig(this.server.config().serverName(), this.server.webLogWriter());
                this.bitmap$priv$0 |= 1;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.wsConfig;
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        block16: {
            block14: {
                WebSocketFrame webSocketFrame;
                Object object;
                block15: {
                    HttpChunk httpChunk;
                    block13: {
                        HttpRequest httpRequest;
                        object = e.getMessage();
                        if (!(object instanceof HttpRequest)) break block13;
                        HttpRequest httpRequest2 = httpRequest = (HttpRequest)object;
                        HttpRequestEvent event = new HttpRequestEvent(e.getChannel(), httpRequest2, this.httpConfig());
                        this.log().debug("HTTP {} CHANNEL={}", (Object)event.endPoint(), (Object)e.getChannel().getId());
                        if (event.request().isChunked()) {
                            this.validateFirstChunk(event);
                            this.server.routes().apply((Object)event);
                            this.initialHttpRequest_$eq((Option<InitialHttpRequestMessage>)new Some((Object)new InitialHttpRequestMessage(event.request(), event.createdOn())));
                        } else if (event.request().isWebSocketUpgrade()) {
                            WebSocketHandshakeEvent wsctx = new WebSocketHandshakeEvent(e.getChannel(), httpRequest2, this.httpConfig());
                            this.server.routes().apply((Object)wsctx);
                            this.doWebSocketHandshake(wsctx);
                            this.initialHttpRequest_$eq((Option<InitialHttpRequestMessage>)new Some((Object)new InitialHttpRequestMessage(event.request(), event.createdOn())));
                        } else {
                            this.server.routes().apply((Object)event);
                        }
                        break block14;
                    }
                    if (!(object instanceof HttpChunk)) break block15;
                    HttpChunk httpChunk2 = httpChunk = (HttpChunk)object;
                    HttpChunkEvent event = new HttpChunkEvent(e.getChannel(), (InitialHttpRequestMessage)this.initialHttpRequest().get(), httpChunk2, this.httpConfig());
                    InitialHttpRequestMessage initialHttpRequestMessage = (InitialHttpRequestMessage)this.initialHttpRequest().get();
                    initialHttpRequestMessage.totalChunkContentLength_$eq(initialHttpRequestMessage.totalChunkContentLength() + (long)httpChunk2.getContent().readableBytes());
                    this.log().debug("CHUNK {} CHANNEL={}", (Object)event.endPoint(), (Object)e.getChannel().getId());
                    this.server.routes().apply((Object)event);
                    if (event.chunk().isLastChunk()) {
                        this.validateLastChunk(event);
                    }
                    break block14;
                }
                if (!(object instanceof WebSocketFrame)) break block16;
                WebSocketFrame wsFrame = webSocketFrame = (WebSocketFrame)object;
                WebSocketFrameEvent event = new WebSocketFrameEvent(e.getChannel(), (InitialHttpRequestMessage)this.initialHttpRequest().get(), wsFrame, this.wsConfig());
                this.log().debug("WS {} CHANNEL={}", (Object)event.endPoint(), (Object)e.getChannel().getId());
                if (wsFrame instanceof CloseWebSocketFrame) {
                    this.wsHandshaker().close(e.getChannel(), (CloseWebSocketFrame)wsFrame);
                } else if (wsFrame instanceof PingWebSocketFrame) {
                    e.getChannel().write((Object)new PongWebSocketFrame(wsFrame.getBinaryData()));
                } else {
                    this.server.routes().apply((Object)event);
                }
            }
            return;
        }
        throw new UnsupportedOperationException(new StringBuilder().append((Object)e.getMessage().getClass().toString()).append((Object)" not supported").toString());
    }

    private void validateFirstChunk(HttpRequestEvent event) {
        if (this.isAggreatingChunks(event.channel())) {
            if (event.request().isChunked() && this.initialHttpRequest().isDefined()) {
                throw new IllegalStateException("New chunk started before the previous chunk ended");
            }
            if (!event.request().isChunked() && this.initialHttpRequest().isDefined()) {
                throw new IllegalStateException("New request received before the previous chunk ended");
            }
        } else if (event.request().isChunked()) {
            throw new IllegalStateException("Received a chunk when chunks should have been aggreated");
        }
    }

    private void validateLastChunk(HttpChunkEvent event) {
        if (this.isAggreatingChunks(event.channel())) {
            if (event.chunk().isLastChunk()) {
                this.initialHttpRequest_$eq((Option<InitialHttpRequestMessage>)None$.MODULE$);
            }
            return;
        }
        throw new IllegalStateException("Received a chunk when chunks should have been aggreated");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        this.log().error("Exception caught in HttpRequestHandler", e.getCause());
        Throwable throwable = e.getCause();
        if (throwable instanceof MatchError) {
            this.writeErrorResponse(ctx, HttpResponseStatus.NOT_FOUND, (Throwable)((MatchError)throwable));
        } else if (throwable instanceof TooLongFrameException) {
            this.writeErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST, (Throwable)((TooLongFrameException)throwable));
        } else if (throwable instanceof UnsupportedOperationException) {
            this.writeErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST, (UnsupportedOperationException)throwable);
        } else {
            try {
                this.log().debug("Error handling request", throwable);
                e.getChannel().close();
            }
            catch (Throwable throwable2) {
                this.log().debug("Error closing channel", throwable2);
            }
        }
    }

    private void writeErrorResponse(ChannelHandlerContext ctx, HttpResponseStatus status, Throwable ex) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S Z");
        Predef$.MODULE$.augmentString("Failure: %s\n\n%s\n\n%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{status.toString(), ex == null ? "" : ex.getMessage(), sf.format(Calendar.getInstance().getTime())}));
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)new StringBuilder().append((Object)"Failure: ").append((Object)status.toString()).append((Object)"\r\n\r\n").append((Object)ex.getMessage()).append((Object)"\r\n").toString(), (Charset)CharsetUtil.UTF_8));
        Channel ch = ctx.getChannel();
        if (ch.isConnected()) {
            ch.write((Object)response).addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.server.allChannels().add(e.getChannel());
    }

    private String createWebSocketLocation(WebSocketHandshakeEvent ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isSSLConnection(ctx.channel()) ? "wss" : "ws");
        sb.append("://");
        sb.append((Object)ctx.request().headers().get((Object)"Host"));
        sb.append(ctx.endPoint().uri());
        return sb.toString();
    }

    private void doWebSocketHandshake(WebSocketHandshakeEvent event) {
        if (event.isAuthorized()) {
            String string = event.authorizedSubprotocols();
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.createWebSocketLocation(event), !(string != null ? !string.equals("") : "" != null) ? null : event.authorizedSubprotocols(), false, (long)event.maxFrameSize());
            this.wsHandshaker_$eq(wsFactory.newHandshaker(event.nettyHttpRequest()));
            if (this.wsHandshaker() == null) {
                wsFactory.sendUnsupportedWebSocketVersionResponse(event.channel());
                event.writeWebLog(HttpResponseStatus.UPGRADE_REQUIRED.getCode(), 0L);
            } else {
                this.wsHandshaker().handshake(event.channel(), event.nettyHttpRequest());
                event.writeWebLog(HttpResponseStatus.SWITCHING_PROTOCOLS.getCode(), 0L);
            }
            return;
        }
        throw new UnsupportedOperationException("Websocket not supported at this end point");
    }

    private boolean isSSLConnection(Channel channel) {
        return channel.getPipeline().get(SslHandler.class) != null;
    }

    private boolean isAggreatingChunks(Channel channel) {
        return channel.getPipeline().get(HttpChunkAggregator.class) != null;
    }

    public RequestHandler(WebServer server) {
        this.server = server;
        Logger$class.$init$(this);
        this.wsHandshaker = null;
        this.initialHttpRequest = None$.MODULE$;
        this.httpConfig = new HttpEventConfig(server.config().serverName(), server.config().http().minCompressibleContentSizeInBytes(), server.config().http().maxCompressibleContentSizeInBytes(), server.config().http().compressibleContentTypes(), server.webLogWriter());
    }
}

