/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.webserver;

import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.npn.NextProtoNego;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.mashupbots.socko.infrastructure.Logger$class;
import org.mashupbots.socko.netty.SpdyServerProvider;
import org.mashupbots.socko.webserver.HttpConfig;
import org.mashupbots.socko.webserver.ProtocolNegoitationHandler;
import org.mashupbots.socko.webserver.RequestHandler;
import org.mashupbots.socko.webserver.SslManager;
import org.mashupbots.socko.webserver.WebServer;
import org.slf4j.Logger;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}2A!\u0001\u0002\u0001\u0017\ty\u0001+\u001b9fY&tWMR1di>\u0014\u0018P\u0003\u0002\u0004\t\u0005Iq/\u001a2tKJ4XM\u001d\u0006\u0003\u000b\u0019\tQa]8dW>T!a\u0002\u0005\u0002\u00155\f7\u000f[;qE>$8OC\u0001\n\u0003\ry'oZ\u0002\u0001'\u0015\u0001A\u0002\u0006\u0010%!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\bCA\u000b\u001d\u001b\u00051\"BA\f\u0019\u0003\u001d\u0019\u0007.\u00198oK2T!!\u0007\u000e\u0002\u000b9,G\u000f^=\u000b\u0005mA\u0011!\u00026c_N\u001c\u0018BA\u000f\u0017\u0005Y\u0019\u0005.\u00198oK2\u0004\u0016\u000e]3mS:,g)Y2u_JL\bCA\u0010#\u001b\u0005\u0001#BA\u0011\u0005\u00039IgN\u001a:bgR\u0014Xo\u0019;ve\u0016L!a\t\u0011\u0003\r1{wmZ3s!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011-\u0002!\u0011!Q\u0001\n1\naa]3sm\u0016\u0014\bCA\u0017/\u001b\u0005\u0011\u0011BA\u0018\u0003\u0005%9VMY*feZ,'\u000fC\u00032\u0001\u0011\u0005!'\u0001\u0004=S:LGO\u0010\u000b\u0003gQ\u0002\"!\f\u0001\t\u000b-\u0002\u0004\u0019\u0001\u0017\t\u000bY\u0002A\u0011A\u001c\u0002\u0017\u001d,G\u000fU5qK2Lg.\u001a\u000b\u0002qA\u0011Q#O\u0005\u0003uY\u0011qb\u00115b]:,G\u000eU5qK2Lg.\u001a\u0005\u0006y\u0001!IaN\u0001\u0010O\u0016$\b\n\u001e;q!&\u0004X\r\\5oK\")a\b\u0001C\u0005o\u0005yq-\u001a;Ta\u0012L\b+\u001b9fY&tW\r")
public class PipelineFactory
implements ChannelPipelineFactory,
org.mashupbots.socko.infrastructure.Logger {
    private final WebServer server;
    private final Logger log;
    public volatile int bitmap$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger log() {
        if ((this.bitmap$0 & 1) != 0) return this.log;
        PipelineFactory pipelineFactory = this;
        synchronized (pipelineFactory) {
            if ((this.bitmap$0 & 1) == 0) {
                this.log = Logger$class.log(this);
                this.bitmap$0 |= 1;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.log;
        }
    }

    public ChannelPipeline getPipeline() {
        return this.server.config().http().spdyEnabled() ? this.getSpdyPipeline() : this.getHttpPipeline();
    }

    private ChannelPipeline getHttpPipeline() {
        ChannelPipeline newPipeline = Channels.pipeline();
        HttpConfig httpConfig = this.server.config().http();
        if (this.server.sslManager().isDefined()) {
            SSLEngine sslEngine = ((SslManager)this.server.sslManager().get()).createSSLEngine();
            SslHandler ssl = new SslHandler(sslEngine);
            ssl.setCloseOnSSLException(true);
            newPipeline.addLast("ssl", (ChannelHandler)ssl);
        }
        newPipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(httpConfig.maxInitialLineLength(), httpConfig.maxHeaderSizeInBytes(), httpConfig.maxChunkSizeInBytes()));
        if (httpConfig.aggreateChunks()) {
            newPipeline.addLast("chunkAggregator", (ChannelHandler)new HttpChunkAggregator(httpConfig.maxLengthInBytes()));
        }
        newPipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        newPipeline.addLast("chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
        newPipeline.addLast("handler", (ChannelHandler)new RequestHandler(this.server));
        return newPipeline;
    }

    private ChannelPipeline getSpdyPipeline() {
        ChannelPipeline newPipeline = Channels.pipeline();
        SSLEngine sslEngine = ((SslManager)this.server.sslManager().get()).createSSLEngine();
        SslHandler ssl = new SslHandler(sslEngine);
        ssl.setCloseOnSSLException(true);
        newPipeline.addLast("ssl", (ChannelHandler)ssl);
        NextProtoNego.put(sslEngine, (NextProtoNego.Provider)new SpdyServerProvider());
        NextProtoNego.debug = this.log().isDebugEnabled();
        newPipeline.addLast("pipeLineSelector", (ChannelHandler)new ProtocolNegoitationHandler(this.server));
        return newPipeline;
    }

    public PipelineFactory(WebServer server) {
        this.server = server;
        Logger$class.$init$(this);
    }
}

