/*
 * Decompiled with CFR 0.152.
 */
package org.matthicks.media4s.image;

import com.outr.scribe.Logger;
import com.outr.scribe.Logging;
import java.io.File;
import org.im4java.core.CompositeCmd;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.IMOps;
import org.im4java.core.Info;
import org.im4java.core.Operation;
import org.matthicks.media4s.Size;
import org.matthicks.media4s.Size$;
import org.matthicks.media4s.image.GIFSicleTranscoder;
import org.matthicks.media4s.image.GIFSicleTranscoder$;
import org.matthicks.media4s.image.ImageInfo;
import org.matthicks.media4s.image.ImageType;
import org.matthicks.media4s.image.ImageType$;
import org.matthicks.media4s.image.ImageType$JPEG$;
import org.matthicks.media4s.image.ImageType$PNG$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ImageUtil$
implements Logging {
    public static final ImageUtil$ MODULE$;
    private String iccProfiles;

    static {
        new ImageUtil$();
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String iccProfiles() {
        return this.iccProfiles;
    }

    public void iccProfiles_$eq(String x$1) {
        this.iccProfiles = x$1;
    }

    public ImageInfo info(File file) {
        String filename = file.getAbsolutePath();
        Info info2 = new Info(filename);
        String extension = filename.substring(filename.lastIndexOf(46) + 1);
        Option<Product> imageType = ImageType$.MODULE$.fromExtension(extension);
        return new ImageInfo(info2.getImageWidth(0), info2.getImageHeight(0), info2.getImageDepth(0), info2.getImageFormat(0), imageType, (Option<String>)Option$.MODULE$.apply((Object)info2.getProperty("Colorspace")));
    }

    public ImageInfo scaleUp(ImageInfo imageInfo, int minWidth, int minHeight) {
        ImageInfo imageInfo2;
        if (imageInfo.width() < minWidth || imageInfo.height() <= minHeight) {
            ImageInfo widthScaled = imageInfo.copy(minWidth, (int)package$.MODULE$.round((double)minWidth * imageInfo.aspectRatio()), imageInfo.copy$default$3(), imageInfo.copy$default$4(), imageInfo.copy$default$5(), imageInfo.copy$default$6());
            ImageInfo heightScaled = imageInfo.copy((int)package$.MODULE$.round((double)minHeight / imageInfo.aspectRatio()), minHeight, imageInfo.copy$default$3(), imageInfo.copy$default$4(), imageInfo.copy$default$5(), imageInfo.copy$default$6());
            imageInfo2 = widthScaled.pixels() > heightScaled.pixels() ? widthScaled : heightScaled;
        } else {
            imageInfo2 = imageInfo;
        }
        return imageInfo2;
    }

    public void generateResized(File input, File output, Option<Object> width, Option<Object> height, boolean strip, double gaussianBlur, double quality, boolean isCMYK2) {
        String original = input.getAbsolutePath();
        String altered = output.getAbsolutePath();
        IMOperation op = new IMOperation();
        Object object = altered.endsWith(".jpg") ? op.flatten() : BoxedUnit.UNIT;
        Object object2 = strip ? op.strip() : BoxedUnit.UNIT;
        Object object3 = gaussianBlur != 0.0 ? op.gaussianBlur(Predef$.MODULE$.double2Double(gaussianBlur)) : BoxedUnit.UNIT;
        Object object4 = quality != 0.0 ? op.quality(Predef$.MODULE$.double2Double(quality)) : BoxedUnit.UNIT;
        op.density(Predef$.MODULE$.int2Integer(288));
        op.addImage(new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[0]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{original}))});
        op.adaptiveResize((Integer)width.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int x) {
                return BoxesRunTime.boxToInteger((int)x);
            }
        }).orNull(Predef$.MODULE$.$conforms()), (Integer)height.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int x) {
                return BoxesRunTime.boxToInteger((int)x);
            }
        }).orNull(Predef$.MODULE$.$conforms()), Predef$.MODULE$.char2Character('>'));
        Object object5 = isCMYK2 ? this.applyCMYKConversion(op) : BoxedUnit.UNIT;
        op.addImage(new String[]{altered});
        ConvertCmd cmd = new ConvertCmd();
        cmd.run((Operation)op, new Object[0]);
    }

    public Option<Object> generateResized$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> generateResized$default$4() {
        return None$.MODULE$;
    }

    public boolean generateResized$default$5() {
        return true;
    }

    public double generateResized$default$6() {
        return 0.0;
    }

    public double generateResized$default$7() {
        return 0.0;
    }

    public boolean generateResized$default$8() {
        return false;
    }

    public IMOps applyCMYKConversion(IMOperation op) {
        if (new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/CMYK/USWebCoatedSWOP.icc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.iccProfiles()}))).exists()) {
            op.profile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/CMYK/USWebCoatedSWOP.icc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.iccProfiles()})));
            return op.profile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/RGB/AdobeRGB1998.icc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.iccProfiles()})));
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ICC Profiles not installed properly in ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.iccProfiles()})));
    }

    public void generateThumbnail(File input, File output, int width, int height, boolean isCMYK2) {
        String original = input.getAbsolutePath();
        String altered = output.getAbsolutePath();
        IMOperation op = new IMOperation();
        op.density(Predef$.MODULE$.int2Integer(288));
        op.addImage(new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[0]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{original}))});
        op.thumbnail(Predef$.MODULE$.int2Integer(width), Predef$.MODULE$.int2Integer(height));
        op.background("transparent");
        op.flatten();
        op.gravity("center");
        op.extent(Predef$.MODULE$.int2Integer(width), Predef$.MODULE$.int2Integer(height));
        Object object = isCMYK2 ? this.applyCMYKConversion(op) : BoxedUnit.UNIT;
        op.addImage(new String[]{altered});
        ConvertCmd cmd = new ConvertCmd();
        cmd.run((Operation)op, new Object[0]);
    }

    public boolean generateThumbnail$default$5() {
        return false;
    }

    public void pngToJpg(File input, File output) {
        IMOperation op = new IMOperation();
        op.flatten();
        op.addImage(new String[]{input.getAbsolutePath()});
        op.addImage(new String[]{output.getAbsolutePath()});
        ConvertCmd cmd = new ConvertCmd();
        cmd.run((Operation)op, new Object[0]);
    }

    public void addWatermark(File input, File output, String overlayPath, String gravity) {
        String original = input.getAbsolutePath();
        String outputPath = output.getAbsolutePath();
        String altered = outputPath.endsWith(".jpg") ? new StringBuilder().append((Object)outputPath).append((Object)".png").toString() : outputPath;
        IMOperation op = new IMOperation();
        op.compose("over");
        op.gravity(gravity);
        op.addImage(new String[]{overlayPath});
        op.addImage(new String[]{original});
        op.addImage(new String[]{altered});
        CompositeCmd cmd = new CompositeCmd();
        cmd.run((Operation)op, new Object[0]);
        if (outputPath.endsWith(".jpg")) {
            File temp = new File(altered);
            this.pngToJpg(temp, new File(outputPath));
            if (!temp.delete()) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete the temporary PNG: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{temp.getAbsolutePath()})));
            }
        }
    }

    public String addWatermark$default$4() {
        return "center";
    }

    public ImageType destinationType(double gaussianBlur, double quality) {
        return gaussianBlur == 0.0 && quality == 0.0 ? ImageType$PNG$.MODULE$ : ImageType$JPEG$.MODULE$;
    }

    public void generateGIFCropped(File input, File output, int width, int height) {
        ImageInfo info2 = this.info(input);
        GIFSicleTranscoder transcoder = new GIFSicleTranscoder(input, output, GIFSicleTranscoder$.MODULE$.apply$default$3()).resize((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)width)), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)height))).optimize(3);
        Size destination = Size$.MODULE$.apply(width, height);
        if (info2.aspectRatio() != destination.aspectRatio()) {
            Size cropped = info2.cropToAspectRatio(destination);
            int x1 = (int)package$.MODULE$.round((double)(info2.width() - cropped.width()) / 2.0);
            int y1 = (int)package$.MODULE$.round((double)(info2.height() - cropped.height()) / 2.0);
            int x2 = x1 + cropped.width();
            int y2 = y1 + cropped.height();
            transcoder = transcoder.crop(x1, y1, x2, y2);
        }
        transcoder.execute();
    }

    public void generateCropped(File input, File output, ImageType outputType, int width, int height, boolean strip, double gaussianBlur, double quality, boolean flatten, boolean isCMYK2) {
        Object object;
        String original = input.getAbsolutePath();
        String altered = output.getAbsolutePath();
        IMOperation op = new IMOperation();
        ImageType imageType = outputType;
        ImageType$JPEG$ imageType$JPEG$ = ImageType$JPEG$.MODULE$;
        if (!(imageType != null ? !imageType.equals(imageType$JPEG$) : imageType$JPEG$ != null)) {
            Object object2 = strip ? op.strip() : BoxedUnit.UNIT;
            Object object3 = gaussianBlur != 0.0 ? op.gaussianBlur(Predef$.MODULE$.double2Double(gaussianBlur)) : BoxedUnit.UNIT;
            object = quality != 0.0 ? op.quality(Predef$.MODULE$.double2Double(quality)) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        op.density(Predef$.MODULE$.int2Integer(288));
        op.addImage(new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[0]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{original}))});
        Object object4 = flatten ? op.flatten() : BoxedUnit.UNIT;
        op.resize(Predef$.MODULE$.int2Integer(width), Predef$.MODULE$.int2Integer(height), Predef$.MODULE$.char2Character('^'));
        op.gravity("center");
        op.crop(Predef$.MODULE$.int2Integer(width), Predef$.MODULE$.int2Integer(height), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(0));
        op.p_repage();
        Object object5 = isCMYK2 ? this.applyCMYKConversion(op) : BoxedUnit.UNIT;
        op.addImage(new String[]{altered});
        ConvertCmd cmd = new ConvertCmd();
        cmd.run((Operation)op, new Object[0]);
    }

    public boolean generateCropped$default$6() {
        return true;
    }

    public double generateCropped$default$7() {
        return 0.0;
    }

    public double generateCropped$default$8() {
        return 0.0;
    }

    public boolean generateCropped$default$9() {
        return true;
    }

    public boolean generateCropped$default$10() {
        return false;
    }

    private ImageUtil$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.iccProfiles = "/opt/icc";
    }
}

