/*
 * Decompiled with CFR 0.152.
 */
package org.matthicks.media4s.file;

import java.io.File;
import java.io.Serializable;
import org.matthicks.media4s.file.DetectedFile;
import org.matthicks.media4s.file.TVEpisodeFile;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

public final class FileDetector$ {
    public static FileDetector$ MODULE$;
    private final Regex EpisodeRegex1;
    private final Regex EpisodeRegex2;
    private final Regex ExtensionRegex;
    private final Set<String> DetectedExtensions;

    static {
        new FileDetector$();
    }

    private Regex EpisodeRegex1() {
        return this.EpisodeRegex1;
    }

    private Regex EpisodeRegex2() {
        return this.EpisodeRegex2;
    }

    private Regex ExtensionRegex() {
        return this.ExtensionRegex;
    }

    private Set<String> DetectedExtensions() {
        return this.DetectedExtensions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<DetectedFile> detectFile(File file) {
        Option option;
        Option option2;
        String string = file.getName();
        Option option3 = this.EpisodeRegex1().unapplySeq((CharSequence)string);
        if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(5) == 0) {
            String name = (String)((LinearSeqOptimized)option3.get()).apply(0);
            String season = (String)((LinearSeqOptimized)option3.get()).apply(1);
            String episode = (String)((LinearSeqOptimized)option3.get()).apply(2);
            String extension = (String)((LinearSeqOptimized)option3.get()).apply(4);
            if (this.DetectedExtensions().contains((Object)extension.toLowerCase())) {
                return new Some((Object)new TVEpisodeFile(file, this.cleanName(name), new StringOps(Predef$.MODULE$.augmentString(season)).toInt(), new StringOps(Predef$.MODULE$.augmentString(episode)).toInt(), extension.toLowerCase()));
            }
        }
        if (!(option2 = this.EpisodeRegex2().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(5) == 0) {
            String name = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String season = (String)((LinearSeqOptimized)option2.get()).apply(1);
            String episode = (String)((LinearSeqOptimized)option2.get()).apply(2);
            String extension = (String)((LinearSeqOptimized)option2.get()).apply(4);
            if (this.DetectedExtensions().contains((Object)extension.toLowerCase())) {
                return new Some((Object)new TVEpisodeFile(file, this.cleanName(name), new StringOps(Predef$.MODULE$.augmentString(season)).toInt(), new StringOps(Predef$.MODULE$.augmentString(episode)).toInt(), extension.toLowerCase()));
            }
        }
        if (!(option = this.ExtensionRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String extension = (String)((LinearSeqOptimized)option.get()).apply(0);
            if (this.DetectedExtensions().contains((Object)extension.toLowerCase())) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to detect file: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
            }
        }
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
        return None$.MODULE$;
    }

    private String cleanName(String name) {
        return name.replaceAll("[.]", "").replaceAll("-", "").trim();
    }

    private void detectDirectory(File file, ListBuffer<DetectedFile> detected) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            File file = x0$1;
            if (file.isDirectory()) {
                MODULE$.detectDirectory(file, detected);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit2;
                Option<DetectedFile> option = MODULE$.detectFile(file);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DetectedFile df = (DetectedFile)some.value();
                    Predef$.MODULE$.println((Object)df);
                    boxedUnit2 = detected.$plus$eq((Object)df);
                } else if (None$.MODULE$.equals(option)) {
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(option);
                }
                boxedUnit = boxedUnit2;
            }
            return boxedUnit;
        });
    }

    private FileDetector$() {
        MODULE$ = this;
        this.EpisodeRegex1 = new StringOps(Predef$.MODULE$.augmentString("(.+)[s|S](\\d{1,2})[e|E](\\d{2})(.*)[.]([a-zA-Z0-9]{3})")).r();
        this.EpisodeRegex2 = new StringOps(Predef$.MODULE$.augmentString("(.+)(\\d{1,2})x(\\d{2})(.*)[.]([a-zA-Z0-9]{3})")).r();
        this.ExtensionRegex = new StringOps(Predef$.MODULE$.augmentString(".*[.]([a-zA-Z0-9]{3})")).r();
        this.DetectedExtensions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mkv", "avi", "mp4", "mpeg", "mpg", "webm"}));
    }
}

