/*
 * Decompiled with CFR 0.152.
 */
package org.matthicks.media4s.image;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Base64;
import org.im4java.core.CompositeCmd;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.IMOps;
import org.im4java.core.Info;
import org.im4java.core.Operation;
import org.matthicks.media4s.Size;
import org.matthicks.media4s.Size$;
import org.matthicks.media4s.image.GIFSicleTranscoder;
import org.matthicks.media4s.image.GIFSicleTranscoder$;
import org.matthicks.media4s.image.ImageInfo;
import org.matthicks.media4s.image.ImageType;
import org.matthicks.media4s.image.ImageType$;
import org.matthicks.media4s.image.ImageType$GIF$;
import org.matthicks.media4s.image.ImageType$JPEG$;
import org.matthicks.media4s.image.ImageType$PNG$;
import org.powerscala.io.IO$;
import org.powerscala.io.Reader;
import org.powerscala.io.Writer;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ImageUtil$ {
    public static ImageUtil$ MODULE$;
    private String iccProfiles;

    static {
        new ImageUtil$();
    }

    public String iccProfiles() {
        return this.iccProfiles;
    }

    public void iccProfiles_$eq(String x$1) {
        this.iccProfiles = x$1;
    }

    public ImageInfo info(File file) {
        String filename = file.getAbsolutePath();
        Info info = new Info(filename);
        String extension = filename.substring(filename.lastIndexOf(46) + 1);
        Option<ImageType> imageType = ImageType$.MODULE$.fromExtension(extension);
        return new ImageInfo(info.getImageWidth(0), info.getImageHeight(0), info.getImageDepth(0), info.getImageFormat(0), imageType, (Option<String>)Option$.MODULE$.apply((Object)info.getProperty("Colorspace")));
    }

    public ImageInfo scaleUp(ImageInfo imageInfo, int minWidth, int minHeight) {
        ImageInfo imageInfo2;
        if (imageInfo.width() < minWidth || imageInfo.height() <= minHeight) {
            ImageInfo widthScaled = imageInfo.copy(minWidth, (int)package$.MODULE$.round((double)minWidth * imageInfo.aspectRatio()), imageInfo.copy$default$3(), imageInfo.copy$default$4(), imageInfo.copy$default$5(), imageInfo.copy$default$6());
            ImageInfo heightScaled = imageInfo.copy((int)package$.MODULE$.round((double)minHeight / imageInfo.aspectRatio()), minHeight, imageInfo.copy$default$3(), imageInfo.copy$default$4(), imageInfo.copy$default$5(), imageInfo.copy$default$6());
            imageInfo2 = widthScaled.pixels() > heightScaled.pixels() ? widthScaled : heightScaled;
        } else {
            imageInfo2 = imageInfo;
        }
        return imageInfo2;
    }

    public void generateResized(File input, File output, Option<Object> width, Option<Object> height, boolean strip, double gaussianBlur, double quality, boolean isCMYK) {
        String original = input.getAbsolutePath();
        String altered = output.getAbsolutePath();
        IMOperation op = new IMOperation();
        op.autoOrient();
        Object object = altered.endsWith(".jpg") ? op.flatten() : BoxedUnit.UNIT;
        Object object2 = strip ? op.strip() : BoxedUnit.UNIT;
        Object object3 = gaussianBlur != 0.0 ? op.gaussianBlur(Predef$.MODULE$.double2Double(gaussianBlur)) : BoxedUnit.UNIT;
        Object object4 = quality != 0.0 ? op.quality(Predef$.MODULE$.double2Double(quality)) : BoxedUnit.UNIT;
        op.density(Predef$.MODULE$.int2Integer(288));
        op.addImage(new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[0]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{original}))});
        op.adaptiveResize((Integer)width.map((Function1 & Serializable & scala.Serializable)x -> ImageUtil$.$anonfun$generateResized$1(BoxesRunTime.unboxToInt((Object)x))).orNull(Predef$.MODULE$.$conforms()), (Integer)height.map((Function1 & Serializable & scala.Serializable)x -> ImageUtil$.$anonfun$generateResized$2(BoxesRunTime.unboxToInt((Object)x))).orNull(Predef$.MODULE$.$conforms()), Predef$.MODULE$.char2Character('>'));
        Object object5 = isCMYK ? this.applyCMYKConversion(op) : BoxedUnit.UNIT;
        op.addImage(new String[]{altered});
        ConvertCmd cmd = new ConvertCmd();
        cmd.run((Operation)op, new Object[0]);
    }

    public Option<Object> generateResized$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> generateResized$default$4() {
        return None$.MODULE$;
    }

    public boolean generateResized$default$5() {
        return true;
    }

    public double generateResized$default$6() {
        return 0.0;
    }

    public double generateResized$default$7() {
        return 0.0;
    }

    public boolean generateResized$default$8() {
        return false;
    }

    public IMOps applyCMYKConversion(IMOperation op) {
        if (!new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/CMYK/USWebCoatedSWOP.icc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.iccProfiles()}))).exists()) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ICC Profiles not installed properly in ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.iccProfiles()})));
        }
        op.profile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/CMYK/USWebCoatedSWOP.icc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.iccProfiles()})));
        return op.profile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/RGB/AdobeRGB1998.icc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.iccProfiles()})));
    }

    public void generateThumbnail(File input, File output, int width, int height, boolean isCMYK) {
        String original = input.getAbsolutePath();
        String altered = output.getAbsolutePath();
        IMOperation op = new IMOperation();
        op.autoOrient();
        op.density(Predef$.MODULE$.int2Integer(288));
        op.addImage(new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[0]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{original}))});
        op.thumbnail(Predef$.MODULE$.int2Integer(width), Predef$.MODULE$.int2Integer(height));
        op.background("transparent");
        op.flatten();
        op.gravity("center");
        op.extent(Predef$.MODULE$.int2Integer(width), Predef$.MODULE$.int2Integer(height));
        Object object = isCMYK ? this.applyCMYKConversion(op) : BoxedUnit.UNIT;
        op.addImage(new String[]{altered});
        ConvertCmd cmd = new ConvertCmd();
        cmd.run((Operation)op, new Object[0]);
    }

    public boolean generateThumbnail$default$5() {
        return false;
    }

    public void pngToJpg(File input, File output) {
        IMOperation op = new IMOperation();
        op.autoOrient();
        op.flatten();
        op.addImage(new String[]{input.getAbsolutePath()});
        op.addImage(new String[]{output.getAbsolutePath()});
        ConvertCmd cmd = new ConvertCmd();
        cmd.run((Operation)op, new Object[0]);
    }

    public void addWatermark(File input, File output, String overlayPath, String gravity) {
        String original = input.getAbsolutePath();
        String outputPath = output.getAbsolutePath();
        String altered = outputPath.endsWith(".jpg") ? outputPath + ".png" : outputPath;
        IMOperation op = new IMOperation();
        op.compose("over");
        op.gravity(gravity);
        op.addImage(new String[]{overlayPath});
        op.addImage(new String[]{original});
        op.addImage(new String[]{altered});
        CompositeCmd cmd = new CompositeCmd();
        cmd.run((Operation)op, new Object[0]);
        if (outputPath.endsWith(".jpg")) {
            File temp = new File(altered);
            this.pngToJpg(temp, new File(outputPath));
            if (!temp.delete()) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete the temporary PNG: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{temp.getAbsolutePath()})));
            }
        }
    }

    public String addWatermark$default$4() {
        return "center";
    }

    public ImageType destinationType(double gaussianBlur, double quality) {
        return gaussianBlur == 0.0 && quality == 0.0 ? ImageType$PNG$.MODULE$ : ImageType$JPEG$.MODULE$;
    }

    public void generateGIFCropped(File input, File output, int width, int height) {
        ImageInfo info = this.info(input);
        GIFSicleTranscoder transcoder = new GIFSicleTranscoder(input, output, GIFSicleTranscoder$.MODULE$.apply$default$3()).resize((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)width)), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)height))).optimize(3);
        Size destination = Size$.MODULE$.apply(width, height);
        if (info.aspectRatio() != destination.aspectRatio()) {
            Size cropped = info.cropToAspectRatio(destination);
            int x1 = (int)package$.MODULE$.round((double)(info.width() - cropped.width()) / 2.0);
            int y1 = (int)package$.MODULE$.round((double)(info.height() - cropped.height()) / 2.0);
            int x2 = x1 + cropped.width();
            int y2 = y1 + cropped.height();
            transcoder = transcoder.crop(x1, y1, x2, y2);
        }
        transcoder.execute();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void generateCropped(File input, File output, ImageType outputType, int width, int height, boolean strip, double gaussianBlur, double quality, boolean flatten, boolean isCMYK) {
        original = input.getAbsolutePath();
        altered = output.getAbsolutePath();
        op = new IMOperation();
        op.autoOrient();
        v0 = outputType;
        var16_14 = ImageType$GIF$.MODULE$;
        if (!(v0 == null ? var16_14 != null : v0.equals(var16_14) == false)) ** GOTO lbl-1000
        v1 = outputType;
        var17_15 = ImageType$PNG$.MODULE$;
        if (!(v1 != null ? v1.equals(var17_15) == false : var17_15 != null)) lbl-1000:
        // 2 sources

        {
            v2 = op.background("none");
        } else {
            v2 = BoxedUnit.UNIT;
        }
        v3 = outputType;
        var18_16 = ImageType$JPEG$.MODULE$;
        if (!(v3 != null ? v3.equals(var18_16) == false : var18_16 != null)) {
            v4 /* !! */  = strip != false ? op.strip() : BoxedUnit.UNIT;
            v5 /* !! */  = gaussianBlur != 0.0 ? op.gaussianBlur(Predef$.MODULE$.double2Double(gaussianBlur)) : BoxedUnit.UNIT;
            v6 /* !! */  = quality != (double)false ? op.quality(Predef$.MODULE$.double2Double(quality)) : BoxedUnit.UNIT;
        } else {
            v6 /* !! */  = BoxedUnit.UNIT;
        }
        op.density(Predef$.MODULE$.int2Integer(288));
        op.addImage(new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[0]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{original}))});
        v7 /* !! */  = flatten != false ? op.flatten() : BoxedUnit.UNIT;
        op.resize(Predef$.MODULE$.int2Integer(width), Predef$.MODULE$.int2Integer(height), Predef$.MODULE$.char2Character('^'));
        op.gravity("center");
        op.crop(Predef$.MODULE$.int2Integer(width), Predef$.MODULE$.int2Integer(height), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(0));
        op.p_repage();
        v8 /* !! */  = isCMYK != false ? this.applyCMYKConversion(op) : BoxedUnit.UNIT;
        op.addImage(new String[]{altered});
        cmd = new ConvertCmd();
        cmd.run((Operation)op, new Object[0]);
    }

    public boolean generateCropped$default$6() {
        return true;
    }

    public double generateCropped$default$7() {
        return 0.0;
    }

    public double generateCropped$default$8() {
        return 0.0;
    }

    public boolean generateCropped$default$9() {
        return true;
    }

    public boolean generateCropped$default$10() {
        return false;
    }

    public void saveBase64(String base64, File file) {
        int index = base64.indexOf("base64,");
        String encoded = index != -1 ? base64.substring(index + 7) : base64;
        byte[] decoded = Base64.getDecoder().decode(encoded);
        IO$.MODULE$.stream((Reader)org.powerscala.io.package$.MODULE$.InputStreamReader((InputStream)new ByteArrayInputStream(decoded)), (Writer)org.powerscala.io.package$.MODULE$.file2Writer(file), IO$.MODULE$.stream$default$3(), IO$.MODULE$.stream$default$4(), IO$.MODULE$.stream$default$5());
    }

    public static final /* synthetic */ Integer $anonfun$generateResized$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$generateResized$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private ImageUtil$() {
        MODULE$ = this;
        this.iccProfiles = "/opt/icc";
    }
}

