/*
 * Decompiled with CFR 0.152.
 */
package org.matthicks.media4s.video.transcode;

import java.io.File;
import java.io.Serializable;
import org.matthicks.media4s.TranscodeFailedException;
import org.matthicks.media4s.video.Preset;
import org.matthicks.media4s.video.Preset$Slow$;
import org.matthicks.media4s.video.VideoProfile;
import org.matthicks.media4s.video.VideoProfile$High$;
import org.matthicks.media4s.video.VideoUtil$;
import org.matthicks.media4s.video.codec.AudioCodec;
import org.matthicks.media4s.video.codec.AudioCodec$AAC$;
import org.matthicks.media4s.video.codec.AudioCodec$libmp3Lame$;
import org.matthicks.media4s.video.codec.AudioCodec$libvorbis$;
import org.matthicks.media4s.video.codec.VideoCodec;
import org.matthicks.media4s.video.codec.VideoCodec$libvpx_vp9$;
import org.matthicks.media4s.video.codec.VideoCodec$libx264$;
import org.matthicks.media4s.video.codec.VideoCodec$mjpeg$;
import org.matthicks.media4s.video.filter.VideoFilter;
import org.matthicks.media4s.video.info.MediaInfo;
import org.matthicks.media4s.video.transcode.FFMPEGArgument;
import org.matthicks.media4s.video.transcode.FFMPEGFile;
import org.matthicks.media4s.video.transcode.FFMPEGTime;
import org.matthicks.media4s.video.transcode.FFMPEGTranscoder$;
import org.matthicks.media4s.video.transcode.FFMPEGTranscoder$b$;
import org.matthicks.media4s.video.transcode.FFMPEGTranscoder$codec$;
import org.matthicks.media4s.video.transcode.FFMPEGTranscoder$profile$;
import org.matthicks.media4s.video.transcode.FFMPEGTranscoder$qscale$;
import org.matthicks.media4s.video.transcode.TranscodeListener;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.sys.process.ProcessLogger$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\rEh\u0001B\u0001\u0003\u00015\u0011\u0001C\u0012$N!\u0016;EK]1og\u000e|G-\u001a:\u000b\u0005\r!\u0011!\u0003;sC:\u001c8m\u001c3f\u0015\t)a!A\u0003wS\u0012,wN\u0003\u0002\b\u0011\u00059Q.\u001a3jCR\u001a(BA\u0005\u000b\u0003%i\u0017\r\u001e;iS\u000e\\7OC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005IqN^3soJLG/\u001a\t\u0003\u001f]I!\u0001\u0007\t\u0003\u000f\t{w\u000e\\3b]\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\u0003be\u001e\u001c\bc\u0001\u000f%O9\u0011QD\t\b\u0003=\u0005j\u0011a\b\u0006\u0003A1\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005\r\u0002\u0012a\u00029bG.\fw-Z\u0005\u0003K\u0019\u0012A\u0001T5ti*\u00111\u0005\u0005\t\u0003Q%j\u0011AA\u0005\u0003U\t\u0011aB\u0012$N!\u0016;\u0015I]4v[\u0016tG\u000fC\u0003-\u0001\u0011%Q&\u0001\u0004=S:LGO\u0010\u000b\u0004]=\u0002\u0004C\u0001\u0015\u0001\u0011\u001d)2\u0006%AA\u0002YAQAG\u0016A\u0002mAqA\r\u0001C\u0002\u0013%1'A\u0007Qe><'/Z:t%\u0016<W\r_\u000b\u0002iA\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\t[\u0006$8\r[5oO*\u0011\u0011\bE\u0001\u0005kRLG.\u0003\u0002<m\t)!+Z4fq\"1Q\b\u0001Q\u0001\nQ\na\u0002\u0015:pOJ,7o\u001d*fO\u0016D\b\u0005\u0003\u0005@\u0001!\u0015\r\u0011\"\u0001A\u0003\u001d\u0019w.\\7b]\u0012,\u0012!\u0011\t\u00049\u0011\u0012\u0005CA\"H\u001d\t!U\t\u0005\u0002\u001f!%\u0011a\tE\u0001\u0007!J,G-\u001a4\n\u0005!K%AB*ue&twM\u0003\u0002G!!)1\n\u0001C\u0001\u0019\u0006Aq/\u001b;i\u0003J<7\u000f\u0006\u0002/\u001b\")aJ\u0013a\u0001\u001f\u0006I\u0011M]4v[\u0016tGo\u001d\t\u0004\u001fA\u0013\u0016BA)\u0011\u0005)a$/\u001a9fCR,GM\u0010\t\u0003\u001fMK!\u0001\u0016\t\u0003\u0007\u0005s\u0017\u0010C\u0003W\u0001\u0011\u0005q+A\u0004gS:$\u0017I]4\u0015\u0005a[\u0006cA\bZO%\u0011!\f\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bq+\u0006\u0019\u0001\"\u0002\u000bA\f'/Y7\t\u000by\u0003A\u0011A0\u0002\u000f],'\r\u0013\u001a7iQaa\u0006\u00195ngblx0a\u0001\u0002\b!9\u0011-\u0018I\u0001\u0002\u0004\u0011\u0017A\u0003<jI\u0016|7i\u001c3fGB\u00111MZ\u0007\u0002I*\u0011Q\rB\u0001\u0006G>$WmY\u0005\u0003O\u0012\u0014!BV5eK>\u001cu\u000eZ3d\u0011\u001dIW\f%AA\u0002)\f!\"Y;eS>\u001cu\u000eZ3d!\t\u00197.\u0003\u0002mI\nQ\u0011)\u001e3j_\u000e{G-Z2\t\u000f9l\u0006\u0013!a\u0001_\u00069\u0001O]8gS2,\u0007C\u00019r\u001b\u0005!\u0011B\u0001:\u0005\u000511\u0016\u000eZ3p!J|g-\u001b7f\u0011\u001d!X\f%AA\u0002U\fa\u0001\u001d:fg\u0016$\bC\u00019w\u0013\t9HA\u0001\u0004Qe\u0016\u001cX\r\u001e\u0005\bsv\u0003\n\u00111\u0001{\u000311\u0018\u000eZ3p\u0005&$(+\u0019;f!\ty10\u0003\u0002}!\t!Aj\u001c8h\u0011\u001dqX\f%AA\u0002i\fA\"Y;eS>\u0014\u0015\u000e\u001e*bi\u0016D\u0001\"!\u0001^!\u0003\u0005\rA_\u0001\b[\u0006D(+\u0019;f\u0011!\t)!\u0018I\u0001\u0002\u0004Q\u0018A\u00032vM\u001a,'oU5{K\"I\u0011\u0011B/\u0011\u0002\u0003\u0007\u00111B\u0001\bi\"\u0014X-\u00193t!\ry\u0011QB\u0005\u0004\u0003\u001f\u0001\"aA%oi\"9\u00111\u0003\u0001\u0005\u0002\u0005U\u0011\u0001B<fE6$rBLA\f\u00033\tY\"!\b\u0002 \u0005\u0005\u00121\u0005\u0005\tC\u0006E\u0001\u0013!a\u0001E\"A\u0011.!\u0005\u0011\u0002\u0003\u0007!\u000e\u0003\u0005z\u0003#\u0001\n\u00111\u0001{\u0011!q\u0018\u0011\u0003I\u0001\u0002\u0004Q\b\"CA\u0001\u0003#\u0001\n\u00111\u0001{\u0011%\t)!!\u0005\u0011\u0002\u0003\u0007!\u0010\u0003\u0006\u0002\n\u0005E\u0001\u0013!a\u0001\u0003\u0017Aq!a\n\u0001\t\u0003\tI#A\u0002naN\"\u0012BLA\u0016\u0003[\t\t$!\u000e\t\u0011%\f)\u0003%AA\u0002)D!\"a\f\u0002&A\u0005\t\u0019AA\u0006\u00031\tW\u000fZ5p#V\fG.\u001b;z\u0011)\t\u0019$!\n\u0011\u0002\u0003\u0007\u00111B\u0001\rS\u0012\u001cdO\r,feNLwN\u001c\u0005\u000b\u0003o\t)\u0003%AA\u0002\u0005e\u0012A\u00029pgR,'\u000f\u0005\u0003\u00103\u0006m\u0002\u0003BA\u001f\u0003\u000fj!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\u0003S>T!!!\u0012\u0002\t)\fg/Y\u0005\u0005\u0003\u0013\nyD\u0001\u0003GS2,\u0007bBA'\u0001\u0011\u0005\u0011qJ\u0001\u0004_\u001e<G#\u0003\u0018\u0002R\u0005M\u0013QKA,\u0011!I\u00171\nI\u0001\u0002\u0004Q\u0007BCA\u0018\u0003\u0017\u0002\n\u00111\u0001\u0002\f!Q\u00111GA&!\u0003\u0005\r!a\u0003\t\u0015\u0005]\u00121\nI\u0001\u0002\u0004\tI\u0004C\u0004\u0002\\\u0001!\t!!\u0018\u0002\u0015M\u001c'/Z3o\u000fJ\f'\rF\u0002/\u0003?B\u0001\"!\u0019\u0002Z\u0001\u0007\u00111M\u0001\u0007_\u001a47/\u001a;\u0011\u0007=\t)'C\u0002\u0002hA\u0011a\u0001R8vE2,\u0007bBA6\u0001\u0011\u0005\u0011QN\u0001\u0006S:\u0004X\u000f\u001e\u000b\u0004]\u0005=\u0004\u0002CA9\u0003S\u0002\r!a\u000f\u0002\t\u0019LG.\u001a\u0005\b\u0003k\u0002A\u0011AA<\u0003\u0019yW\u000f\u001e9viR\u0019a&!\u001f\t\u0011\u0005E\u00141\u000fa\u0001\u0003wAq!! \u0001\t\u0003\ty(\u0001\u0006j]B,H\u000fR3mCf$2ALAA\u0011!\t\u0019)a\u001fA\u0002\u0005\r\u0014aB:fG>tGm\u001d\u0005\b\u0003\u000f\u0003A\u0011AAE\u0003-1\u0018\u000eZ3p\rJ\fW.Z:\u0015\u00079\nY\t\u0003\u0005\u0002\u000e\u0006\u0015\u0005\u0019AA\u0006\u0003)1'/Y7f\u0007>,h\u000e\u001e\u0005\u0007C\u0002!\t!!%\u0015\u00079\n\u0019\nC\u0004\u0002\u0016\u0006=\u0005\u0019\u00012\u0002\u0003\rDq!!'\u0001\t\u0003\tY*\u0001\u0007wS\u0012,w\u000e\u0015:pM&dW\rF\u0002/\u0003;Cq!a(\u0002\u0018\u0002\u0007q.A\u0001q\u0011\u0019I\b\u0001\"\u0001\u0002$R\u0019a&!*\t\u000f\u0005\u001d\u0016\u0011\u0015a\u0001u\u00069!-\u001b;SCR,\u0007bBA\u0001\u0001\u0011\u0005\u00111\u0016\u000b\u0004]\u00055\u0006bBAT\u0003S\u0003\rA\u001f\u0005\b\u0003\u000b\u0001A\u0011AAY)\rq\u00131\u0017\u0005\b\u0003k\u000by\u000b1\u0001{\u0003\u0011\u0019\u0018N_3\t\r%\u0004A\u0011AA])\rq\u00131\u0018\u0005\b\u0003+\u000b9\f1\u0001k\u0011\u0019q\b\u0001\"\u0001\u0002@R\u0019a&!1\t\u000f\u0005\u001d\u0016Q\u0018a\u0001u\"9\u0011q\u0006\u0001\u0005\u0002\u0005\u0015Gc\u0001\u0018\u0002H\"A\u0011\u0011ZAb\u0001\u0004\tY!A\u0004rk\u0006d\u0017\u000e^=\t\u000f\u00055\u0007\u0001\"\u0001\u0002P\u0006Yam\u001c:dK\u001a{'/\\1u)\rq\u0013\u0011\u001b\u0005\b\u0003'\fY\r1\u0001C\u0003\u00191wN]7bi\"9\u0011q\u001b\u0001\u0005\u0002\u0005e\u0017\u0001\u00043jg\u0006\u0014G.Z!vI&|G#\u0001\u0018\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\u0006aa/\u001b3f_\u001aKG\u000e^3sgR\u0019a&!9\t\u0011\u0005\r\u00181\u001ca\u0001\u0003K\fqAZ5mi\u0016\u00148\u000f\u0005\u0003\u0010!\u0006\u001d\b\u0003BAu\u0003_l!!a;\u000b\u0007\u00055H!\u0001\u0004gS2$XM]\u0005\u0005\u0003c\fYOA\u0006WS\u0012,wNR5mi\u0016\u0014\bbBA{\u0001\u0011\u0005\u0011q_\u0001\u0006gR\f'\u000f\u001e\u000b\u0004]\u0005e\b\u0002CAB\u0003g\u0004\r!a\u0019\t\u000f\u0005u\b\u0001\"\u0001\u0002\u0000\u0006AA-\u001e:bi&|g\u000eF\u0002/\u0005\u0003A\u0001\"a!\u0002|\u0002\u0007\u00111\r\u0005\b\u0005\u000b\u0001A\u0011AAm\u0003\t\tg\u000eC\u0004\u0003\n\u0001!\tAa\u0003\u0002\u000f\t,hm]5{KR\u0019aF!\u0004\t\u000f\u0005U&q\u0001a\u0001u\"9!\u0011\u0003\u0001\u0005\u0002\tM\u0011!\u00014\u0015\u00079\u0012)\u0002C\u0004\u0002T\n=\u0001\u0019\u0001\"\t\u000f\te\u0001\u0001\"\u0001\u0003\u001c\u0005\t\u0011\u000eF\u0002/\u0005;A\u0001\"!\u001d\u0003\u0018\u0001\u0007\u00111\b\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u00035IGm\r<3?Z,'o]5p]R\u0019aF!\n\t\u0011\t\u001d\"q\u0004a\u0001\u0003\u0017\tqA^3sg&|g\u000eC\u0004\u0003,\u0001!\tA!\f\u0002\u0013%$8o\u001c4gg\u0016$Hc\u0001\u0018\u00030!A\u00111\u0011B\u0015\u0001\u0004\t\u0019\u0007C\u0004\u00034\u0001!\tA!\u000e\u0002\u00075\f\u0007\u000fF\u0002/\u0005oA\u0001B!\u000f\u00032\u0001\u0007\u00111B\u0001\u0003S\u0012DqAa\r\u0001\t\u0003\u0011i\u0004F\u0003/\u0005\u007f\u0011\u0019\u0005\u0003\u0005\u0003B\tm\u0002\u0019AA\u0006\u0003\u0011Ig.\u00133\t\u0011\t\u0015#1\ba\u0001\u0003\u0017\tQa\\;u\u0013\u0012DqA!\u0013\u0001\t\u0003\u0011Y%\u0001\u0007nCB|V.\u001a;bI\u0006$\u0018\rF\u0002/\u0005\u001bB\u0001B!\u000f\u0003H\u0001\u0007\u00111\u0002\u0005\b\u0005#\u0002A\u0011\u0001B*\u0003\u001di\u0017\r\u001f:bi\u0016$2A\fB+\u0011\u001d\t\tAa\u0014A\u0002iDqA!\u0017\u0001\t\u0003\u0011Y&A\u0001p)\rq#Q\f\u0005\t\u0003c\u00129\u00061\u0001\u0002<!9!\u0011\f\u0001\u0005\u0002\t\u0005Dc\u0001\u0018\u0003d!9!Q\rB0\u0001\u0004\u0011\u0015\u0001\u00029bi\"DqA!\u001b\u0001\t\u0003\u0011Y'\u0001\u0003qCN\u001cHc\u0001\u0018\u0003n!A!\u0011\u000eB4\u0001\u0004\tY\u0001\u0003\u0004u\u0001\u0011\u0005!\u0011\u000f\u000b\u0004]\tM\u0004B\u0002;\u0003p\u0001\u0007Q\u000fC\u0004\u0003x\u0001!\tA!\u001f\u0002\u0005M\u001cHc\u0001\u0018\u0003|!A\u00111\u0011B;\u0001\u0004\t\u0019\u0007C\u0004\u0003\u0000\u0001!\tA!!\u0002\u0003Q$2A\fBB\u0011!\t\u0019I! A\u0002\u0005\r\u0004bBA\u0005\u0001\u0011\u0005!q\u0011\u000b\u0004]\t%\u0005\u0002\u0003BF\u0005\u000b\u0003\r!a\u0003\u0002\u0017QD'/Z1e\u0007>,h\u000e\u001e\u0005\b\u0005\u001f\u0003A\u0011\u0001BI\u0003\t1h\rF\u0002/\u0005'C\u0001\"a9\u0003\u000e\u0002\u0007!Q\u0013\t\u00059\u0011\n9\u000fC\u0004\u0003\u001a\u0002!\tAa'\u0002\u000fY4'/Y7fgR\u0019aF!(\t\u0011\u00055%q\u0013a\u0001\u0003\u0017Aa!\u0006\u0001\u0005\u0002\t\u0005Fc\u0001\u0018\u0003$\"9!Q\u0015BP\u0001\u00041\u0012!\u0002<bYV,wa\u0002BU\u0001!\u0005!1V\u0001\u0002EB!!Q\u0016BX\u001b\u0005\u0001aa\u0002BY\u0001!\u0005!1\u0017\u0002\u0002EN\u0019!q\u0016\b\t\u000f1\u0012y\u000b\"\u0001\u00038R\u0011!1\u0016\u0005\t\u0005w\u0013y\u000b\"\u0001\u0003>\u0006\t\u0011\rF\u0002/\u0005\u007fCq!a*\u0003:\u0002\u0007!\u0010\u0003\u0005\u0003D\n=F\u0011\u0001Bc\u0003\u00051Hc\u0001\u0018\u0003H\"9\u0011q\u0015Ba\u0001\u0004QxAB3\u0001\u0011\u0003\u0011Y\r\u0005\u0003\u0003.\n5ga\u0002Bh\u0001!\u0005!\u0011\u001b\u0002\u0006G>$WmY\n\u0004\u0005\u001bt\u0001b\u0002\u0017\u0003N\u0012\u0005!Q\u001b\u000b\u0003\u0005\u0017D\u0001B!7\u0003N\u0012\u0005\u0011\u0011\\\u0001\u0005G>\u0004\u0018\u0010\u0003\u0005\u0003<\n5G\u0011\u0001Bo)\rq#q\u001c\u0005\u0007K\nm\u0007\u0019\u00016\t\u0011\t\r'Q\u001aC\u0001\u0005G$2A\fBs\u0011\u0019)'\u0011\u001da\u0001E\u001e1a\u000e\u0001E\u0001\u0005S\u0004BA!,\u0003l\u001a9!Q\u001e\u0001\t\u0002\t=(a\u00029s_\u001aLG.Z\n\u0004\u0005Wt\u0001b\u0002\u0017\u0003l\u0012\u0005!1\u001f\u000b\u0003\u0005SD\u0001Ba1\u0003l\u0012\u0005!q\u001f\u000b\u0004]\te\bB\u00028\u0003v\u0002\u0007qnB\u0004\u0003~\u0002A\tAa@\u0002\rE\u001c8-\u00197f!\u0011\u0011ik!\u0001\u0007\u000f\r\r\u0001\u0001#\u0001\u0004\u0006\t1\u0011o]2bY\u0016\u001c2a!\u0001\u000f\u0011\u001da3\u0011\u0001C\u0001\u0007\u0013!\"Aa@\t\u0011\tm6\u0011\u0001C\u0001\u0007\u001b!2ALB\b\u0011!\tIma\u0003A\u0002\u0005-\u0001bBB\n\u0001\u0011\u00051QC\u0001\bKb,7-\u001e;f)\u0019\u00199b!\b\u0004*A\u0019qb!\u0007\n\u0007\rm\u0001C\u0001\u0003V]&$\bBCB\u0010\u0007#\u0001\n\u00111\u0001\u0004\"\u00059Qn\u001c8ji>\u0014\b\u0003B\bZ\u0007G\u00012\u0001KB\u0013\u0013\r\u00199C\u0001\u0002\u0012)J\fgn]2pI\u0016d\u0015n\u001d;f]\u0016\u0014\bBCB\u0016\u0007#\u0001\n\u00111\u0001\u0004.\u0005aa.[2f!JLwN]5usB!q\"WA\u0006\u0011%\u0019\t\u0004AI\u0001\n\u0003\u0019\u0019$A\txK\nD%G\u000e\u001b%I\u00164\u0017-\u001e7uIE*\"a!\u000e+\u0007\t\u001c9d\u000b\u0002\u0004:A!11HB#\u001b\t\u0019iD\u0003\u0003\u0004@\r\u0005\u0013!C;oG\",7m[3e\u0015\r\u0019\u0019\u0005E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB$\u0007{\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0019Y\u0005AI\u0001\n\u0003\u0019i%A\txK\nD%G\u000e\u001b%I\u00164\u0017-\u001e7uII*\"aa\u0014+\u0007)\u001c9\u0004C\u0005\u0004T\u0001\t\n\u0011\"\u0001\u0004V\u0005\tr/\u001a2IeY\"D\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r]#fA8\u00048!I11\f\u0001\u0012\u0002\u0013\u00051QL\u0001\u0012o\u0016\u0014\u0007J\r\u001c5I\u0011,g-Y;mi\u0012\"TCAB0U\r)8q\u0007\u0005\n\u0007G\u0002\u0011\u0013!C\u0001\u0007K\n\u0011c^3c\u0011J2D\u0007\n3fM\u0006,H\u000e\u001e\u00136+\t\u00199GK\u0002{\u0007oA\u0011ba\u001b\u0001#\u0003%\ta!\u001a\u0002#],'\r\u0013\u001a7i\u0011\"WMZ1vYR$c\u0007C\u0005\u0004p\u0001\t\n\u0011\"\u0001\u0004f\u0005\tr/\u001a2IeY\"D\u0005Z3gCVdG\u000fJ\u001c\t\u0013\rM\u0004!%A\u0005\u0002\r\u0015\u0014!E<fE\"\u0013d\u0007\u000e\u0013eK\u001a\fW\u000f\u001c;%q!I1q\u000f\u0001\u0012\u0002\u0013\u00051\u0011P\u0001\u0012o\u0016\u0014\u0007J\r\u001c5I\u0011,g-Y;mi\u0012JTCAB>U\u0011\tYaa\u000e\t\u0013\r}\u0004!%A\u0005\u0002\rM\u0012AD<fE6$C-\u001a4bk2$H%\r\u0005\n\u0007\u0007\u0003\u0011\u0013!C\u0001\u0007\u001b\nab^3c[\u0012\"WMZ1vYR$#\u0007C\u0005\u0004\b\u0002\t\n\u0011\"\u0001\u0004f\u0005qq/\u001a2nI\u0011,g-Y;mi\u0012\u001a\u0004\"CBF\u0001E\u0005I\u0011AB3\u000399XMY7%I\u00164\u0017-\u001e7uIQB\u0011ba$\u0001#\u0003%\ta!\u001a\u0002\u001d],'-\u001c\u0013eK\u001a\fW\u000f\u001c;%k!I11\u0013\u0001\u0012\u0002\u0013\u00051QM\u0001\u000fo\u0016\u0014W\u000e\n3fM\u0006,H\u000e\u001e\u00137\u0011%\u00199\nAI\u0001\n\u0003\u0019I(\u0001\bxK\nlG\u0005Z3gCVdG\u000fJ\u001c\t\u0013\rm\u0005!%A\u0005\u0002\r5\u0013!D7qg\u0011\"WMZ1vYR$\u0013\u0007C\u0005\u0004 \u0002\t\n\u0011\"\u0001\u0004z\u0005iQ\u000e]\u001a%I\u00164\u0017-\u001e7uIIB\u0011ba)\u0001#\u0003%\ta!\u001f\u0002\u001b5\u00048\u0007\n3fM\u0006,H\u000e\u001e\u00134\u0011%\u00199\u000bAI\u0001\n\u0003\u0019I+A\u0007naN\"C-\u001a4bk2$H\u0005N\u000b\u0003\u0007WSC!!\u000f\u00048!I1q\u0016\u0001\u0012\u0002\u0013\u00051QJ\u0001\u000e_\u001e<G\u0005Z3gCVdG\u000fJ\u0019\t\u0013\rM\u0006!%A\u0005\u0002\re\u0014!D8hO\u0012\"WMZ1vYR$#\u0007C\u0005\u00048\u0002\t\n\u0011\"\u0001\u0004z\u0005iqnZ4%I\u00164\u0017-\u001e7uIMB\u0011ba/\u0001#\u0003%\ta!+\u0002\u001b=<w\r\n3fM\u0006,H\u000e\u001e\u00135\u0011%\u0019y\fAI\u0001\n\u0003\u0019\t-A\tfq\u0016\u001cW\u000f^3%I\u00164\u0017-\u001e7uIE*\"aa1+\t\r\u00052q\u0007\u0005\n\u0007\u000f\u0004\u0011\u0013!C\u0001\u0007\u0013\f\u0011#\u001a=fGV$X\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019YM\u000b\u0003\u0004.\r]raBBh\u0005!\u00051\u0011[\u0001\u0011\r\u001ak\u0005+R$Ue\u0006t7oY8eKJ\u00042\u0001KBj\r\u0019\t!\u0001#\u0001\u0004VN\u001911\u001b\b\t\u000f1\u001a\u0019\u000e\"\u0001\u0004ZR\u00111\u0011\u001b\u0005\u000b\u0007;\u001c\u0019N1A\u0005\n\r}\u0017\u0001\u00022bg\u0016,\u0012A\f\u0005\t\u0007G\u001c\u0019\u000e)A\u0005]\u0005)!-Y:fA!A1q]Bj\t\u0003\tI.A\u0003baBd\u0017\u0010\u0003\u0006\u0004l\u000eM\u0017\u0013!C\u0005\u0007[\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nTCABxU\r12q\u0007")
public class FFMPEGTranscoder {
    private List<String> command;
    private volatile FFMPEGTranscoder$b$ b$module;
    private volatile FFMPEGTranscoder$codec$ codec$module;
    private volatile FFMPEGTranscoder$profile$ profile$module;
    private volatile FFMPEGTranscoder$qscale$ qscale$module;
    private final boolean overwrite;
    private final List<FFMPEGArgument> args;
    private final Regex ProgressRegex;
    private volatile boolean bitmap$0;

    public static FFMPEGTranscoder apply() {
        return FFMPEGTranscoder$.MODULE$.apply();
    }

    public FFMPEGTranscoder$b$ b() {
        if (this.b$module == null) {
            this.b$lzycompute$1();
        }
        return this.b$module;
    }

    public FFMPEGTranscoder$codec$ codec() {
        if (this.codec$module == null) {
            this.codec$lzycompute$1();
        }
        return this.codec$module;
    }

    public FFMPEGTranscoder$profile$ profile() {
        if (this.profile$module == null) {
            this.profile$lzycompute$1();
        }
        return this.profile$module;
    }

    public FFMPEGTranscoder$qscale$ qscale() {
        if (this.qscale$module == null) {
            this.qscale$lzycompute$1();
        }
        return this.qscale$module;
    }

    private Regex ProgressRegex() {
        return this.ProgressRegex;
    }

    private List<String> command$lzycompute() {
        FFMPEGTranscoder fFMPEGTranscoder = this;
        synchronized (fFMPEGTranscoder) {
            if (!this.bitmap$0) {
                String string = "ffmpeg";
                this.command = ((List)this.args.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (List)x$1.args().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).$colon$colon((Object)string);
                this.bitmap$0 = true;
            }
        }
        return this.command;
    }

    public List<String> command() {
        return !this.bitmap$0 ? this.command$lzycompute() : this.command;
    }

    public FFMPEGTranscoder withArgs(Seq<Object> arguments) {
        List<FFMPEGArgument> list = this.args;
        return new FFMPEGTranscoder(this.overwrite, (List<FFMPEGArgument>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FFMPEGArgument[]{new FFMPEGArgument((List<Object>)arguments.toList())})).$colon$colon$colon(list));
    }

    public Option<FFMPEGArgument> findArg(String param) {
        return this.args.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FFMPEGTranscoder.$anonfun$findArg$1(param, x$5)));
    }

    public FFMPEGTranscoder webH264(VideoCodec videoCodec, AudioCodec audioCodec, VideoProfile profile, Preset preset, long videoBitRate, long audioBitRate, long maxRate, long bufferSize, int threads) {
        return this.videoCodec(videoCodec).videoProfile(profile).preset(preset).videoBitRate(videoBitRate).maxRate(maxRate).bufferSize(bufferSize).threads(threads).audioCodec(audioCodec).audioBitRate(audioBitRate);
    }

    public VideoCodec webH264$default$1() {
        return VideoCodec$libx264$.MODULE$;
    }

    public AudioCodec webH264$default$2() {
        return AudioCodec$AAC$.MODULE$;
    }

    public VideoProfile webH264$default$3() {
        return VideoProfile$High$.MODULE$;
    }

    public Preset webH264$default$4() {
        return Preset$Slow$.MODULE$;
    }

    public long webH264$default$5() {
        return 500000L;
    }

    public long webH264$default$6() {
        return 128000L;
    }

    public long webH264$default$7() {
        return 500000L;
    }

    public long webH264$default$8() {
        return 1000000L;
    }

    public int webH264$default$9() {
        return 0;
    }

    public FFMPEGTranscoder webm(VideoCodec videoCodec, AudioCodec audioCodec, long videoBitRate, long audioBitRate, long maxRate, long bufferSize, int threads) {
        return this.videoCodec(videoCodec).videoBitRate(videoBitRate).maxRate(maxRate).bufferSize(bufferSize).threads(threads).audioCodec(audioCodec).audioBitRate(audioBitRate);
    }

    public VideoCodec webm$default$1() {
        return VideoCodec$libvpx_vp9$.MODULE$;
    }

    public AudioCodec webm$default$2() {
        return AudioCodec$libvorbis$.MODULE$;
    }

    public long webm$default$3() {
        return 500000L;
    }

    public long webm$default$4() {
        return 128000L;
    }

    public long webm$default$5() {
        return 500000L;
    }

    public long webm$default$6() {
        return 1000000L;
    }

    public int webm$default$7() {
        return 0;
    }

    public FFMPEGTranscoder mp3(AudioCodec audioCodec, int audioQuality, int id3v2Version, Option<File> poster) {
        ObjectRef t = ObjectRef.create((Object)this);
        poster.foreach((Function1 & Serializable & scala.Serializable)p -> {
            t.elem = ((FFMPEGTranscoder)t.elem).input(p).map(0, 0).map(1, 0).id3v2_version(id3v2Version);
            return BoxedUnit.UNIT;
        });
        return ((FFMPEGTranscoder)t.elem).audioCodec(audioCodec).audioQuality(audioQuality);
    }

    public AudioCodec mp3$default$1() {
        return AudioCodec$libmp3Lame$.MODULE$;
    }

    public int mp3$default$2() {
        return 2;
    }

    public int mp3$default$3() {
        return 4;
    }

    public Option<File> mp3$default$4() {
        return None$.MODULE$;
    }

    public FFMPEGTranscoder ogg(AudioCodec audioCodec, int audioQuality, int id3v2Version, Option<File> poster) {
        ObjectRef t = ObjectRef.create((Object)this);
        poster.foreach((Function1 & Serializable & scala.Serializable)p -> {
            t.elem = ((FFMPEGTranscoder)t.elem).input(p).map(0, 0).map(1, 0).id3v2_version(id3v2Version);
            return BoxedUnit.UNIT;
        });
        return ((FFMPEGTranscoder)t.elem).audioCodec(audioCodec).audioQuality(audioQuality);
    }

    public FFMPEGTranscoder screenGrab(double offset) {
        return this.start(offset).videoCodec(VideoCodec$mjpeg$.MODULE$).videoFrames(1).disableAudio().forceFormat("rawvideo");
    }

    public FFMPEGTranscoder input(File file) {
        return this.i(file);
    }

    public FFMPEGTranscoder output(File file) {
        return this.o(file);
    }

    public FFMPEGTranscoder inputDelay(double seconds) {
        return this.itsoffset(seconds);
    }

    public FFMPEGTranscoder videoFrames(int frameCount) {
        return this.vframes(frameCount);
    }

    public FFMPEGTranscoder videoCodec(VideoCodec c) {
        return this.codec().v(c);
    }

    public FFMPEGTranscoder videoProfile(VideoProfile p) {
        return this.profile().v(p);
    }

    public FFMPEGTranscoder videoBitRate(long bitRate) {
        return this.b().v(bitRate);
    }

    public FFMPEGTranscoder maxRate(long bitRate) {
        return this.maxrate(bitRate);
    }

    public FFMPEGTranscoder bufferSize(long size) {
        return this.bufsize(size);
    }

    public FFMPEGTranscoder audioCodec(AudioCodec c) {
        return this.codec().a(c);
    }

    public FFMPEGTranscoder audioBitRate(long bitRate) {
        return this.b().a(bitRate);
    }

    public FFMPEGTranscoder audioQuality(int quality) {
        return this.qscale().a(quality);
    }

    public FFMPEGTranscoder forceFormat(String format) {
        return this.f(format);
    }

    public FFMPEGTranscoder disableAudio() {
        return this.an();
    }

    public FFMPEGTranscoder videoFilters(Seq<VideoFilter> filters) {
        return this.vf((List<VideoFilter>)filters.toList());
    }

    public FFMPEGTranscoder start(double seconds) {
        return this.ss(seconds);
    }

    public FFMPEGTranscoder duration(double seconds) {
        return this.t(seconds);
    }

    public FFMPEGTranscoder an() {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-an"}));
    }

    public FFMPEGTranscoder bufsize(long size) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-bufsize", BoxesRunTime.boxToLong((long)size)}));
    }

    public FFMPEGTranscoder f(String format) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-f", format}));
    }

    public FFMPEGTranscoder i(File file) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-i", new FFMPEGFile(file)}));
    }

    public FFMPEGTranscoder id3v2_version(int version) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-id3v2_version", BoxesRunTime.boxToInteger((int)version)}));
    }

    public FFMPEGTranscoder itsoffset(double seconds) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-itsoffset", BoxesRunTime.boxToLong((long)package$.MODULE$.round(seconds))}));
    }

    public FFMPEGTranscoder map(int id) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-map", BoxesRunTime.boxToInteger((int)id)}));
    }

    public FFMPEGTranscoder map(int inId, int outId) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-map", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)inId), BoxesRunTime.boxToInteger((int)outId)}))}));
    }

    public FFMPEGTranscoder map_metadata(int id) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-map_metadata", BoxesRunTime.boxToInteger((int)id)}));
    }

    public FFMPEGTranscoder maxrate(long maxRate) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-maxrate", BoxesRunTime.boxToLong((long)maxRate)}));
    }

    public FFMPEGTranscoder o(File file) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new FFMPEGFile(file)}));
    }

    public FFMPEGTranscoder o(String path) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}));
    }

    public AudioCodec ogg$default$1() {
        return AudioCodec$libvorbis$.MODULE$;
    }

    public int ogg$default$2() {
        return 2;
    }

    public int ogg$default$3() {
        return 4;
    }

    public Option<File> ogg$default$4() {
        return None$.MODULE$;
    }

    public FFMPEGTranscoder pass(int pass) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-pass", BoxesRunTime.boxToInteger((int)pass)}));
    }

    public FFMPEGTranscoder preset(Preset preset) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-preset", preset.value()}));
    }

    public FFMPEGTranscoder ss(double seconds) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-ss", new FFMPEGTime(seconds)}));
    }

    public FFMPEGTranscoder t(double seconds) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-t", new FFMPEGTime(seconds)}));
    }

    public FFMPEGTranscoder threads(int threadCount) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-threads", BoxesRunTime.boxToInteger((int)threadCount)}));
    }

    public FFMPEGTranscoder vf(List<VideoFilter> filters) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-vf", ((TraversableOnce)filters.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.value(), List$.MODULE$.canBuildFrom())).mkString(",")}));
    }

    public FFMPEGTranscoder vframes(int frameCount) {
        return this.withArgs((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-vframes", BoxesRunTime.boxToInteger((int)frameCount)}));
    }

    public FFMPEGTranscoder overwrite(boolean value) {
        return new FFMPEGTranscoder(value, this.args);
    }

    public void execute(Option<TranscodeListener> monitor, Option<Object> nicePriority) {
        List list;
        File inputFile = ((FFMPEGFile)((IterableLike)((FFMPEGArgument)this.findArg("-i").getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No input file defined for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.command().mkString(" ")})));
        })).args().tail()).head()).file();
        MediaInfo info = VideoUtil$.MODULE$.info(inputFile, VideoUtil$.MODULE$.info$default$2());
        double duration = BoxesRunTime.unboxToDouble((Object)this.args.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)FFMPEGTranscoder.$anonfun$execute$2(x$7))).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)FFMPEGTranscoder.$anonfun$execute$3(x$8))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
        long start = System.currentTimeMillis();
        ObjectRef lastLine = ObjectRef.create(null);
        Function1 & Serializable & scala.Serializable log = (Function1 & Serializable & scala.Serializable)line -> {
            FFMPEGTranscoder.$anonfun$execute$5(this, monitor, info, duration, start, lastLine, line);
            return BoxedUnit.UNIT;
        };
        Option<Object> option = nicePriority;
        if (option instanceof Some) {
            Some some = (Some)option;
            int priority = BoxesRunTime.unboxToInt((Object)some.value());
            List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"nice", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--adjustment=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)priority)}))}));
            List<String> list3 = this.command();
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.overwrite ? "-y" : "-n"})).$colon$colon$colon(list3).$colon$colon$colon(list2);
        } else if (None$.MODULE$.equals(option)) {
            list = this.command();
        } else {
            throw new MatchError(option);
        }
        List niceCommand = list;
        int result = scala.sys.process.package$.MODULE$.stringSeqToProcess(niceCommand).$bang(ProcessLogger$.MODULE$.apply((Function1)log));
        if (result != 0) {
            throw new TranscodeFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed transcoding (", "). Received result: ", ". ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{niceCommand.mkString(" "), BoxesRunTime.boxToInteger((int)result), (String)lastLine.elem})));
        }
    }

    public Option<TranscodeListener> execute$default$1() {
        return None$.MODULE$;
    }

    public Option<Object> execute$default$2() {
        return new Some((Object)BoxesRunTime.boxToInteger((int)10));
    }

    private final void b$lzycompute$1() {
        FFMPEGTranscoder fFMPEGTranscoder = this;
        synchronized (fFMPEGTranscoder) {
            if (this.b$module == null) {
                this.b$module = new FFMPEGTranscoder$b$(this);
            }
        }
    }

    private final void codec$lzycompute$1() {
        FFMPEGTranscoder fFMPEGTranscoder = this;
        synchronized (fFMPEGTranscoder) {
            if (this.codec$module == null) {
                this.codec$module = new FFMPEGTranscoder$codec$(this);
            }
        }
    }

    private final void profile$lzycompute$1() {
        FFMPEGTranscoder fFMPEGTranscoder = this;
        synchronized (fFMPEGTranscoder) {
            if (this.profile$module == null) {
                this.profile$module = new FFMPEGTranscoder$profile$(this);
            }
        }
    }

    private final void qscale$lzycompute$1() {
        FFMPEGTranscoder fFMPEGTranscoder = this;
        synchronized (fFMPEGTranscoder) {
            if (this.qscale$module == null) {
                this.qscale$module = new FFMPEGTranscoder$qscale$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$findArg$1(String param$1, FFMPEGArgument x$5) {
        Object object = x$5.args().head();
        String string = param$1;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$execute$2(FFMPEGArgument x$7) {
        Object object = x$7.args().head();
        String string = "-t";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ double $anonfun$execute$3(FFMPEGArgument x$8) {
        return ((FFMPEGTime)((IterableLike)x$8.args().tail()).head()).seconds();
    }

    public static final /* synthetic */ void $anonfun$execute$5(FFMPEGTranscoder $this, Option monitor$1, MediaInfo info$1, double duration$1, long start$1, ObjectRef lastLine$1, String line) {
        String string = line;
        Option option = $this.ProgressRegex().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(10) == 0) {
            String frame = (String)((LinearSeqOptimized)option.get()).apply(0);
            String fps = (String)((LinearSeqOptimized)option.get()).apply(1);
            String q = (String)((LinearSeqOptimized)option.get()).apply(2);
            String last = (String)((LinearSeqOptimized)option.get()).apply(3);
            String size = (String)((LinearSeqOptimized)option.get()).apply(4);
            String hours = (String)((LinearSeqOptimized)option.get()).apply(5);
            String minutes = (String)((LinearSeqOptimized)option.get()).apply(6);
            String seconds = (String)((LinearSeqOptimized)option.get()).apply(7);
            String millis = (String)((LinearSeqOptimized)option.get()).apply(8);
            String bitRate = (String)((LinearSeqOptimized)option.get()).apply(9);
            double timeProcessed = new StringOps(Predef$.MODULE$.augmentString(seconds)).toDouble() + new StringOps(Predef$.MODULE$.augmentString(minutes)).toDouble() * 60.0 + new StringOps(Predef$.MODULE$.augmentString(hours)).toDouble() * 60.0 * 60.0;
            double percentage = duration$1 != 0.0 ? timeProcessed / duration$1 : timeProcessed / info$1.duration();
            double time = (double)(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(new StringOps(Predef$.MODULE$.augmentString(hours)).toInt())).hours().toSeconds() + new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(new StringOps(Predef$.MODULE$.augmentString(minutes)).toInt())).minute().toSeconds() + (long)new StringOps(Predef$.MODULE$.augmentString(seconds)).toInt()) + new StringOps(Predef$.MODULE$.augmentString(millis)).toDouble() / 100.0;
            double elapsed = (double)(System.currentTimeMillis() - start$1) / 1000.0;
            String string2 = last;
            String string3 = "L";
            boolean finished = !(string2 != null ? !string2.equals(string3) : string3 != null);
            monitor$1.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                x$9.progress(percentage, new StringOps(Predef$.MODULE$.augmentString(frame)).toInt(), new StringOps(Predef$.MODULE$.augmentString(fps)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(q)).toDouble(), package$.MODULE$.round(new StringOps(Predef$.MODULE$.augmentString(size)).toDouble() * (double)1000), time, package$.MODULE$.round(new StringOps(Predef$.MODULE$.augmentString(bitRate)).toDouble() * (double)1000), elapsed, finished);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            monitor$1.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                x$10.log(line);
                return BoxedUnit.UNIT;
            });
            lastLine$1.elem = line;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public FFMPEGTranscoder(boolean overwrite, List<FFMPEGArgument> args) {
        this.overwrite = overwrite;
        this.args = args;
        this.ProgressRegex = new StringOps(Predef$.MODULE$.augmentString("frame=\\s*(\\d+) fps=\\s*([0-9.]+) q=([-0-9.]+) (L?)size=\\s*(\\d+)kB time=(\\d{2}):(\\d{2}):(\\d{2})[.](\\d+) bitrate=\\s*([0-9.]+)kbits/s.*")).r();
    }
}

