/*
 * Decompiled with CFR 0.152.
 */
package org.mattrick.enbeet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.mattrick.enbeet.NBTList;

public class NBTCompound {
    private String name;
    private final Map<String, Object> data = new HashMap<String, Object>();

    public NBTCompound() {
        this(null);
    }

    public NBTCompound(String name) {
        this.name = name;
    }

    public Optional<String> getName() {
        return Optional.of(this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void set(Object value, String ... path) {
        if (path == null) {
            throw new IllegalArgumentException("path must not be blank");
        }
        NBTCompound curr = this;
        for (int i = 0; i < path.length - 1; ++i) {
            String part = path[i];
            Object currVal = curr.data.get(part);
            NBTCompound newVal = currVal instanceof NBTCompound ? (NBTCompound)currVal : new NBTCompound();
            curr.data.put(part, newVal);
            curr = newVal;
        }
        curr.data.put(path[path.length - 1], value);
    }

    public Optional<Object> get(String ... path) {
        if (path == null) {
            return Optional.of(this);
        }
        Object curr = this;
        for (String part : path) {
            Object object = curr;
            if (!(object instanceof NBTCompound)) {
                return Optional.empty();
            }
            NBTCompound comp = object;
            if (!comp.data.containsKey(part)) {
                return Optional.empty();
            }
            curr = comp.data.get(part);
        }
        return Optional.of(curr);
    }

    public <T> Optional<T> get(Class<T> type, String ... path) {
        return this.get(path).map(obj -> {
            try {
                return type.cast(obj);
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        });
    }

    public Optional<Byte> getByte(String ... path) {
        return this.get(Byte.class, path);
    }

    public Optional<Short> getShort(String ... path) {
        return this.get(Short.class, path);
    }

    public Optional<Integer> getInt(String ... path) {
        return this.get(Integer.class, path);
    }

    public Optional<Long> getLong(String ... path) {
        return this.get(Long.class, path);
    }

    public Optional<Float> getFloat(String ... path) {
        return this.get(Float.class, path);
    }

    public Optional<Double> getDouble(String ... path) {
        return this.get(Double.class, path);
    }

    public Optional<byte[]> getByteArray(String ... path) {
        return this.get(byte[].class, path);
    }

    public Optional<String> getString(String ... path) {
        return this.get(String.class, path);
    }

    public Optional<NBTList> getList(String ... path) {
        return this.get(NBTList.class, path);
    }

    public Optional<NBTCompound> getCompound(String ... path) {
        return this.get(NBTCompound.class, path);
    }

    public Optional<int[]> getIntArray(String ... path) {
        return this.get(int[].class, path);
    }

    public Optional<long[]> getLongArray(String ... path) {
        return this.get(long[].class, path);
    }

    public Optional<int[]> getVarIntArray(String ... path) {
        Optional<byte[]> optionalData = this.getByteArray(path);
        if (optionalData.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        byte[] data = optionalData.get();
        int index = 0;
        int i = 0;
        while (i < data.length) {
            int value = 0;
            int varint_length = 0;
            while (true) {
                value |= (data[i] & 0x7F) << varint_length++ * 7;
                if (varint_length > 5) {
                    throw new RuntimeException("VarInt too big (probably due to corrupted data)");
                }
                if ((data[i] & 0x80) != 128) {
                    ++i;
                    break;
                }
                ++i;
            }
            result.add(index, value);
            ++index;
        }
        return Optional.of(result.stream().mapToInt(val -> val).toArray());
    }

    public Map<String, Object> data() {
        return this.data;
    }

    public String toString() {
        return "NBTCompound{" + this.data + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBTCompound that = (NBTCompound)o;
        return this.data.equals(that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }
}

