/*
 * Decompiled with CFR 0.152.
 */
package org.mattrick.enbeet;

import java.util.ArrayList;
import java.util.Optional;
import org.mattrick.enbeet.NBTCompound;
import org.mattrick.enbeet.TagType;

public class NBTList
extends ArrayList<Object> {
    private final TagType type;

    public NBTList(TagType type) {
        this.type = type;
    }

    public TagType getType() {
        return this.type;
    }

    @Override
    public Optional<Object> get(int index) {
        return Optional.of(super.get(index));
    }

    public <T> Optional<T> get(Class<T> type, int index) {
        if (this.type != TagType.from(type)) {
            return Optional.empty();
        }
        return Optional.of(super.get(index)).map(obj -> {
            try {
                return type.cast(obj);
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        });
    }

    public Optional<Byte> getByte(int index) {
        return this.get(Byte.class, index);
    }

    public Optional<Short> getShort(int index) {
        return this.get(Short.class, index);
    }

    public Optional<Integer> getInt(int index) {
        return this.get(Integer.class, index);
    }

    public Optional<Long> getLong(int index) {
        return this.get(Long.class, index);
    }

    public Optional<Float> getFloat(int index) {
        return this.get(Float.class, index);
    }

    public Optional<Double> getDouble(int index) {
        return this.get(Double.class, index);
    }

    public Optional<byte[]> getByteArray(int index) {
        return this.get(byte[].class, index);
    }

    public Optional<String> getString(int index) {
        return this.get(String.class, index);
    }

    public Optional<NBTList> getList(int index) {
        return this.get(NBTList.class, index);
    }

    public Optional<NBTCompound> getCompound(int index) {
        return this.get(NBTCompound.class, index);
    }

    public Optional<int[]> getIntArray(int index) {
        return this.get(int[].class, index);
    }

    public Optional<long[]> getLongArray(int index) {
        return this.get(long[].class, index);
    }
}

