/*
 * Decompiled with CFR 0.152.
 */
package org.mattrick.enbeet;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mattrick.enbeet.NBTCompound;
import org.mattrick.enbeet.NBTList;

public enum TagType {
    END(0, Void.TYPE),
    BYTE(1, Byte.TYPE),
    SHORT(2, Short.TYPE),
    INT(3, Integer.TYPE),
    LONG(4, Long.TYPE),
    FLOAT(5, Float.TYPE),
    DOUBLE(6, Double.TYPE),
    BYTE_ARRAY(7, byte[].class),
    STRING(8, String.class),
    LIST(9, NBTList.class),
    COMPOUND(10, NBTCompound.class),
    INT_ARRAY(11, int[].class),
    LONG_ARRAY(12, long[].class);

    private static final Map<Byte, TagType> ID_MAP;
    private static final Map<Class<?>, TagType> TYPE_MAP;
    private final byte id;
    private final Class<?> type;

    private TagType(int id, Class<?> type) {
        this.id = (byte)id;
        this.type = type;
    }

    public byte getId() {
        return this.id;
    }

    public Class<?> getType() {
        return this.type;
    }

    public static TagType from(byte id) {
        return ID_MAP.get(id);
    }

    public static TagType from(Class<?> type) {
        type = TagType.unboxType(type);
        return TYPE_MAP.get(type);
    }

    private static Class<?> unboxType(Class<?> type) {
        if (type == Void.class) {
            return Void.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Integer.class) {
            return Integer.class;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        return type;
    }

    static {
        ID_MAP = Stream.of(TagType.values()).collect(Collectors.toMap(TagType::getId, Function.identity()));
        TYPE_MAP = Stream.of(TagType.values()).collect(Collectors.toMap(TagType::getType, Function.identity()));
    }
}

