/*
 * Decompiled with CFR 0.152.
 */
package org.mattrick.enbeet.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;
import org.mattrick.enbeet.NBTCompound;
import org.mattrick.enbeet.NBTList;
import org.mattrick.enbeet.TagType;
import org.mattrick.enbeet.io.NBTException;

public class NBTReader {
    private final DataInputStream in;

    public NBTReader(InputStream in) throws IOException {
        this.in = new DataInputStream(this.conditionallyUngzip(in));
    }

    public NBTCompound read() throws IOException {
        TagType type = this.readType();
        if (type == TagType.END) {
            return new NBTCompound();
        }
        if (type != TagType.COMPOUND) {
            throw new IOException("Expected COMPOUND at root, instead got " + type.name() + ".");
        }
        this.in.readUTF();
        return this.readCompound();
    }

    private TagType readType() throws IOException {
        byte id = this.in.readByte();
        TagType type = TagType.from(id);
        if (type == null) {
            throw new NBTException("Invalid NBT tag type id: " + id);
        }
        return type;
    }

    private NBTCompound readCompound() throws IOException {
        NBTCompound comp = new NBTCompound();
        TagType type = this.readType();
        while (type != TagType.END) {
            String key = this.in.readUTF();
            Object value = this.readTag(type);
            comp.set(value, key);
            type = this.readType();
        }
        return comp;
    }

    private Object readTag(TagType type) throws IOException {
        return switch (type) {
            case TagType.END -> null;
            case TagType.BYTE -> (Object)this.in.readByte();
            case TagType.SHORT -> (Object)this.in.readShort();
            case TagType.INT -> (Object)this.in.readInt();
            case TagType.LONG -> (Object)this.in.readLong();
            case TagType.FLOAT -> (Object)Float.valueOf(this.in.readFloat());
            case TagType.DOUBLE -> (Object)this.in.readDouble();
            case TagType.BYTE_ARRAY -> this.readByteArray();
            case TagType.STRING -> (Object)this.in.readUTF();
            case TagType.LIST -> (Object)this.readList();
            case TagType.COMPOUND -> (Object)this.readCompound();
            case TagType.INT_ARRAY -> (Object)this.readIntArray();
            case TagType.LONG_ARRAY -> (Object)this.readLongArray();
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private byte[] readByteArray() throws IOException {
        int len = this.in.readInt();
        byte[] value = new byte[len];
        for (int i = 0; i < len; ++i) {
            value[i] = this.in.readByte();
        }
        return value;
    }

    private NBTList readList() throws IOException {
        TagType listType = this.readType();
        int len = this.in.readInt();
        if (len < 0) {
            len = 0;
        }
        NBTList list = new NBTList(listType);
        for (int i = 0; i < len; ++i) {
            list.add(this.readTag(listType));
        }
        return list;
    }

    private int[] readIntArray() throws IOException {
        int len = this.in.readInt();
        int[] value = new int[len];
        for (int i = 0; i < len; ++i) {
            value[i] = this.in.readInt();
        }
        return value;
    }

    private long[] readLongArray() throws IOException {
        int len = this.in.readInt();
        long[] value = new long[len];
        for (int i = 0; i < len; ++i) {
            value[i] = this.in.readLong();
        }
        return value;
    }

    private InputStream conditionallyUngzip(InputStream in) throws IOException {
        PushbackInputStream pushback = new PushbackInputStream(in, 2);
        byte[] bytes = new byte[2];
        int len = pushback.read(bytes);
        pushback.unread(bytes, 0, len);
        int magic = bytes[1] << 8 & 0xFF00 | bytes[0];
        if (magic == 35615) {
            return new GZIPInputStream(pushback);
        }
        return pushback;
    }
}

