/*
 * Decompiled with CFR 0.152.
 */
package org.mattrick.enbeet.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import org.mattrick.enbeet.NBTCompound;
import org.mattrick.enbeet.NBTList;
import org.mattrick.enbeet.TagType;
import org.mattrick.enbeet.io.NBTException;

public class NBTWriter {
    private final DataOutputStream out;

    public NBTWriter(OutputStream out) throws IOException {
        this(out, true);
    }

    public NBTWriter(OutputStream out, boolean gzip) throws IOException {
        Objects.requireNonNull(out);
        if (gzip) {
            out = new GZIPOutputStream(out);
        }
        this.out = new DataOutputStream(out);
    }

    public void write(NBTCompound nbt) throws IOException {
        Objects.requireNonNull(nbt);
        this.writeTagId(TagType.COMPOUND);
        this.out.writeUTF(nbt.getName().orElse(""));
        this.writeCompound(nbt);
    }

    private void writeTagId(TagType type) throws IOException {
        this.out.writeByte(type.getId());
    }

    private void writeTag(String key, Object value) throws IOException {
        TagType type = TagType.from(value.getClass());
        if (type == null) {
            throw new NBTException("Cannot write " + value.getClass().getName() + " object to NBT");
        }
        this.writeTagId(type);
        this.out.writeUTF(key);
        this.writeValue(type, value);
    }

    private void writeValue(TagType type, Object value) throws IOException {
        switch (type) {
            case END: {
                break;
            }
            case BYTE: {
                this.out.writeByte(((Byte)value).byteValue());
                break;
            }
            case SHORT: {
                this.out.writeShort(((Short)value).shortValue());
                break;
            }
            case INT: {
                this.out.writeInt((Integer)value);
                break;
            }
            case LONG: {
                this.out.writeLong((Long)value);
                break;
            }
            case FLOAT: {
                this.out.writeFloat(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                this.out.writeDouble((Double)value);
                break;
            }
            case BYTE_ARRAY: {
                this.writeByteArray((byte[])value);
                break;
            }
            case STRING: {
                this.out.writeUTF((String)value);
                break;
            }
            case LIST: {
                this.writeList((NBTList)value);
                break;
            }
            case COMPOUND: {
                this.writeCompound((NBTCompound)value);
                break;
            }
            case INT_ARRAY: {
                this.writeIntArray((int[])value);
                break;
            }
            case LONG_ARRAY: {
                this.writeLongArray((long[])value);
            }
        }
    }

    private void writeByteArray(byte[] data) throws IOException {
        this.out.writeInt(data.length);
        for (byte value : data) {
            this.out.writeByte(value);
        }
    }

    private void writeList(NBTList data) throws IOException {
        TagType type = data.getType();
        this.out.writeByte(type.getId());
        this.out.writeByte(data.size());
        for (Object value : data) {
            this.writeValue(type, value);
        }
    }

    private void writeCompound(NBTCompound comp) throws IOException {
        for (Map.Entry<String, Object> entry : comp.data().entrySet()) {
            this.writeTag(entry.getKey(), entry.getValue());
        }
        this.writeTagId(TagType.END);
    }

    private void writeIntArray(int[] data) throws IOException {
        this.out.writeInt(data.length);
        for (int value : data) {
            this.out.writeInt(value);
        }
    }

    private void writeLongArray(long[] data) throws IOException {
        this.out.writeInt(data.length);
        for (long value : data) {
            this.out.writeLong(value);
        }
    }
}

