/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattshoe.shoebox.kernl.data.ext;

import io.github.mattshoe.shoebox.kernl.data.DataResult;
import io.github.mattshoe.shoebox.kernl.data.ext.ExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a\b\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\b\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\b\u0010\u0006\u001a\u00020\u0004H\u0002\u001a\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"fetchData", "Lio/github/mattshoe/shoebox/kernl/data/DataResult;", "", "sampleValueOrNull", "", "sampleUnwrap", "sampleUnwrapWithErrorHandling", "sampleOrElse", "Kernl.Runtime"})
public final class SamplesKt {
    private static final DataResult<String> fetchData() {
        return new DataResult.Success<String>("");
    }

    private static final void sampleValueOrNull() {
        DataResult<String> result = SamplesKt.fetchData();
        String value = ExtensionsKt.valueOrNull(result);
        System.out.println((Object)("Retrieved value: " + value));
    }

    private static final void sampleUnwrap() {
        DataResult<String> result = SamplesKt.fetchData();
        try {
            String data = ExtensionsKt.unwrap(result);
            System.out.println((Object)("Data: " + data));
        }
        catch (Throwable e) {
            System.out.println((Object)("Error occurred: " + e.getMessage()));
        }
    }

    private static final void sampleUnwrapWithErrorHandling() {
        DataResult<String> result = SamplesKt.fetchData();
        String data = ExtensionsKt.unwrap(result, (Function1<? super Throwable, Unit>)((Function1)SamplesKt::sampleUnwrapWithErrorHandling$lambda$0));
        System.out.println((Object)("Unwrapped data: " + data));
    }

    public static final void sampleOrElse() {
        DataResult<String> result = SamplesKt.fetchData();
        String data = ExtensionsKt.orElse(result, SamplesKt::sampleOrElse$lambda$1);
        System.out.println((Object)("Result data: " + data));
    }

    private static final Unit sampleUnwrapWithErrorHandling$lambda$0(Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        System.out.println((Object)("Handled error: " + error.getMessage()));
        return Unit.INSTANCE;
    }

    private static final String sampleOrElse$lambda$1(Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return "Default value due to error: " + error.getMessage();
    }
}

