/*
 * Decompiled with CFR 0.152.
 */
package org.mattshoe.shoebox.kernl.runtime.cache.invalidation.tracker;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mattshoe.shoebox.kernl.InvalidationStrategy;
import org.mattshoe.shoebox.kernl.runtime.cache.invalidation.tracker.InvalidationExecutor;
import org.mattshoe.shoebox.kernl.runtime.cache.invalidation.tracker.InvalidationTrackerFactory;
import org.mattshoe.shoebox.kernl.runtime.cache.invalidation.tracker.impl.EagerRefreshInvalidationExecutor;
import org.mattshoe.shoebox.kernl.runtime.cache.invalidation.tracker.impl.EmptyInvalidationExecutor;
import org.mattshoe.shoebox.kernl.runtime.cache.invalidation.tracker.impl.LazyRefreshInvalidationExecutor;
import org.mattshoe.shoebox.kernl.runtime.cache.invalidation.tracker.impl.PreemptiveRefreshInvalidationExecutor;
import org.mattshoe.shoebox.kernl.runtime.cache.invalidation.tracker.impl.TimeToLiveInvalidationExecutor;
import org.mattshoe.shoebox.kernl.runtime.session.KernlResourceManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/mattshoe/shoebox/kernl/runtime/cache/invalidation/tracker/InvalidationTrackerFactoryImpl;", "Lorg/mattshoe/shoebox/kernl/runtime/cache/invalidation/tracker/InvalidationTrackerFactory;", "kernlResourceManager", "Lorg/mattshoe/shoebox/kernl/runtime/session/KernlResourceManager;", "<init>", "(Lorg/mattshoe/shoebox/kernl/runtime/session/KernlResourceManager;)V", "getExecutor", "Lorg/mattshoe/shoebox/kernl/runtime/cache/invalidation/tracker/InvalidationExecutor;", "strategy", "Lorg/mattshoe/shoebox/kernl/InvalidationStrategy;", "Kernl.Runtime"})
public final class InvalidationTrackerFactoryImpl
implements InvalidationTrackerFactory {
    @NotNull
    private final KernlResourceManager kernlResourceManager;

    public InvalidationTrackerFactoryImpl(@NotNull KernlResourceManager kernlResourceManager) {
        Intrinsics.checkNotNullParameter((Object)kernlResourceManager, (String)"kernlResourceManager");
        this.kernlResourceManager = kernlResourceManager;
    }

    @Override
    @NotNull
    public InvalidationExecutor getExecutor(@NotNull InvalidationStrategy strategy) {
        InvalidationExecutor invalidationExecutor;
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        InvalidationStrategy invalidationStrategy = strategy;
        if (invalidationStrategy instanceof InvalidationStrategy.Manual) {
            invalidationExecutor = new EmptyInvalidationExecutor();
        } else if (invalidationStrategy instanceof InvalidationStrategy.TimeToLive) {
            invalidationExecutor = new TimeToLiveInvalidationExecutor((InvalidationStrategy.TimeToLive)strategy, this.kernlResourceManager);
        } else if (invalidationStrategy instanceof InvalidationStrategy.LazyRefresh) {
            invalidationExecutor = new LazyRefreshInvalidationExecutor((InvalidationStrategy.LazyRefresh)strategy, this.kernlResourceManager);
        } else if (invalidationStrategy instanceof InvalidationStrategy.EagerRefresh) {
            invalidationExecutor = new EagerRefreshInvalidationExecutor((InvalidationStrategy.EagerRefresh)strategy, this.kernlResourceManager);
        } else if (invalidationStrategy instanceof InvalidationStrategy.PreemptiveRefresh) {
            invalidationExecutor = new PreemptiveRefreshInvalidationExecutor((InvalidationStrategy.PreemptiveRefresh)strategy, this.kernlResourceManager);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return invalidationExecutor;
    }
}

