package org.matwoess.jsourceprofiler.tool.instrument;

import java.util.ArrayList;
import org.matwoess.jsourceprofiler.tool.model.ClassType;
import org.matwoess.jsourceprofiler.tool.model.BlockType;

import static org.matwoess.jsourceprofiler.tool.model.ClassType.*;
import static org.matwoess.jsourceprofiler.tool.model.BlockType.*;

public class Parser {
	public static final int _EOF = 0;
	public static final int _ident = 1;
	public static final int _char = 2;
	public static final int _string = 3;
	public static final int _class = 4;
	public static final int _this = 5;
	public static final int _newRef = 6;
	public static final int maxT = 48;

	static final boolean _T = true;
	static final boolean _x = false;
	static final int minErrDist = 2;

	public Token t;    // last recognized token
	public Token la;   // lookahead token
	int errDist = minErrDist;
	
	public Scanner scanner;
	public Errors errors;

	ParserState state = new ParserState(this);



	public Parser(Scanner scanner) {
		this.scanner = scanner;
		errors = new Errors();
	}

	void SynErr (int n) {
		if (errDist >= minErrDist) errors.SynErr(la.line, la.col, n);
		errDist = 0;
	}

	public void SemErr (String msg) {
		if (errDist >= minErrDist) errors.SemErr(t.line, t.col, msg);
		errDist = 0;
	}
	
	void Get () {
		for (;;) {
			t = la;
			la = scanner.Scan();
			if (la.kind <= maxT) {
				++errDist;
				break;
			}

			la = t;
		}
	}
	
	void Expect (int n) {
		if (la.kind==n) Get(); else { SynErr(n); }
	}
	
	boolean StartOf (int s) {
		return set[s][la.kind];
	}
	
	void ExpectWeak (int n, int follow) {
		if (la.kind == n) Get();
		else {
			SynErr(n);
			while (!StartOf(follow)) Get();
		}
	}
	
	boolean WeakSeparator (int n, int syFol, int repFol) {
		int kind = la.kind;
		if (kind == n) { Get(); return true; }
		else if (StartOf(repFol)) return false;
		else {
			SynErr(n);
			while (!(set[syFol][kind] || set[repFol][kind] || set[0][kind])) {
				Get();
				kind = la.kind;
			}
			return StartOf(syFol);
		}
	}
	
	void JavaFile() {
		if (la.kind == 7) {
			PackageDecl();
		}
		while (StartOf(1)) {
			if (la.kind == 10) {
				AnnotationType();
			} else if (la.kind == 11) {
				Annotation();
			} else if (state.classDefWithNoLeadingDot()) {
				Class(CLASS);
			} else if (la.kind == 14) {
				Enum(CLASS);
			} else {
				Get();
			}
		}
	}

	void PackageDecl() {
		Expect(7);
		ArrayList<String> packageName = new ArrayList<>(); 
		Expect(1);
		packageName.add(t.val); 
		while (la.kind == 8) {
			Get();
			Expect(1);
			packageName.add(t.val); 
		}
		Expect(9);
		state.setPackageName(packageName); 
	}

	void AnnotationType() {
		Expect(10);
		Expect(1);
		BraceExpr();
	}

	void Annotation() {
		Expect(11);
		QualIdent();
		if (la.kind == 34) {
			ParExpr();
		}
	}

	void Class(ClassType classType) {
		if (la.kind == 4) {
			Get();
		} else if (la.kind == 12) {
			Get();
		} else if (la.kind == 1) {
			Get();
		} else SynErr(49);
		Expect(1);
		String className = t.val; 
		while (StartOf(2)) {
			Get();
		}
		state.enterClass(classType, className); 
		Expect(13);
		ClassBody();
		state.leaveClass(); 
	}

	void Enum(ClassType classType) {
		Expect(14);
		Expect(1);
		String className = t.val; 
		while (StartOf(2)) {
			Get();
		}
		state.enterClass(classType, className); 
		Expect(13);
		while (la.kind == 1 || la.kind == 11) {
			while (la.kind == 11) {
				Annotation();
			}
			Expect(1);
			if (la.kind == 34) {
				ParExpr();
			}
			if (la.kind == 13) {
				Get();
				ClassBody();
			}
			if (la.kind == 15) {
				Get();
			}
		}
		if (la.kind == 9) {
			Get();
			ClassBody();
		} else if (la.kind == 16) {
			Get();
		} else SynErr(50);
		state.leaveClass(); 
	}

	void BraceExpr() {
		Expect(13);
		while (StartOf(3)) {
			if (la.kind == 13) {
				BraceExpr();
			} else {
				Get();
			}
		}
		Expect(16);
	}

	void QualIdent() {
		Expect(1);
		while (la.kind == 8) {
			Get();
			Expect(1);
		}
	}

	void ParExpr() {
		Expect(34);
		while (StartOf(4)) {
			if (la.kind == 34) {
				ParExpr();
			} else {
				Get();
			}
		}
		Expect(35);
	}

	void ClassBody() {
		while (StartOf(3)) {
			if (la.kind == 14) {
				Enum(CLASS);
			} else if (state.classDefWithNoLeadingDot()) {
				Class(CLASS);
			} else if (la.kind == 17) {
				Get();
				if (la.kind == 13) {
					BraceExpr();
				} else if (StartOf(5)) {
					while (StartOf(6)) {
						Get();
					}
					Statement();
				} else SynErr(51);
			} else if (state.identAndLPar()) {
				MethodDecl();
			} else if (state.classNameAndLBrace()) {
				MethodDecl();
			} else if (state.staticAndLBrace()) {
				StaticBlock();
			} else if (la.kind == 10) {
				AnnotationType();
			} else if (la.kind == 11) {
				Annotation();
			} else {
				Get();
			}
		}
		Expect(16);
	}

	void Statement() {
		if (la.kind == 37) {
			IfStatement();
		} else if (la.kind == 39) {
			SwitchStatement();
		} else if (la.kind == 19) {
			Get();
			ParExpr();
			BlockOrSingleStatement(LOOP);
		} else if (la.kind == 20) {
			Get();
			BlockOrSingleStatement(LOOP);
			Expect(19);
			ParExpr();
			Expect(9);
		} else if (la.kind == 21) {
			Get();
			ParExpr();
			BlockOrSingleStatement(LOOP);
		} else if (la.kind == 22) {
			Get();
			if (la.kind == 34) {
				ParExpr();
			}
			Block(TRY);
			while (la.kind == 23) {
				Get();
				ParExpr();
				Block(BLOCK);
			}
			if (la.kind == 24) {
				Get();
				Block(BLOCK);
			}
		} else if (la.kind == 25 || la.kind == 26) {
			if (la.kind == 25) {
				Get();
			} else {
				Get();
			}
			state.registerControlBreak(); 
			if (la.kind == 1) {
				Get();
			}
			Expect(9);
		} else if (la.kind == 27 || la.kind == 28) {
			if (la.kind == 27) {
				Get();
			} else {
				Get();
			}
			state.registerControlBreak(); 
			if (la.kind == 39) {
				SwitchStatement();
			} else if (StartOf(7)) {
				while (StartOf(8)) {
					if (StartOf(9)) {
						Get();
					} else if (la.kind == 34) {
						ParExpr();
					} else {
						BraceExpr();
					}
				}
			} else SynErr(52);
			Expect(9);
		} else if (la.kind == 29) {
			Get();
			state.registerControlBreak(); 
			while (StartOf(10)) {
				Get();
			}
			Expect(9);
		} else if (state.isLabel()) {
			state.registerLabel(); 
			Expect(1);
			Expect(30);
		} else if (la.kind == 11) {
			Annotation();
		} else if (la.kind == 31) {
			Get();
			if (la.kind == 34) {
				ParExpr();
				Expect(9);
				state.markEndOfSuperCall(); 
			} else if (la.kind == 8) {
				Get();
				while (StartOf(10)) {
					Get();
				}
				Expect(9);
			} else SynErr(53);
		} else if (state.thisAndLPar()) {
			Expect(5);
			ParExpr();
			Expect(9);
			state.markEndOfSuperCall(); 
		} else if (la.kind == 32 || la.kind == 33) {
			if (la.kind == 32) {
				Get();
			} else {
				Get();
			}
			if (la.kind == 34) {
				Get();
			}
			Expect(1);
			if (la.kind == 35) {
				Get();
			}
			Expect(9);
		} else if (la.kind == 36) {
			Get();
			ParExpr();
			Block(BLOCK);
		} else if (state.classDefWithNoLeadingDot()) {
			Class(LOCAL);
		} else if (la.kind == 14) {
			Enum(LOCAL);
		} else if (StartOf(11)) {
			GenericStatement();
		} else if (la.kind == 13) {
			Block(BLOCK);
		} else if (la.kind == 9) {
			Get();
		} else SynErr(54);
	}

	void MethodDecl() {
		Expect(1);
		String methName = t.val; 
		while (StartOf(12)) {
			Get();
		}
		if (la.kind == 9) {
			Get();
			state.registerAbstractMethod(methName); 
		} else if (la.kind == 13) {
			state.enterMethod(methName); 
			Block(METHOD);
			state.leaveMethod(); 
		} else SynErr(55);
	}

	void StaticBlock() {
		Expect(18);
		Block(STATIC);
	}

	void Block(BlockType blockType) {
		state.enterBlock(blockType); 
		Expect(13);
		while (StartOf(13)) {
			Statement();
		}
		state.leaveBlock(blockType); 
		Expect(16);
	}

	void IfStatement() {
		Expect(37);
		ParExpr();
		BlockOrSingleStatement(BLOCK);
		if (la.kind == 38) {
			Get();
			if (la.kind == 37) {
				IfStatement();
			} else if (StartOf(13)) {
				BlockOrSingleStatement(BLOCK);
			} else SynErr(56);
		}
	}

	void SwitchStatement() {
		BlockType switchType = state.isAssignment() ? SWITCH_EXPR : SWITCH_STMT; 
		Expect(39);
		ParExpr();
		state.enterBlock(switchType); 
		Expect(13);
		while (la.kind == 40 || la.kind == 41) {
			SwitchCase();
		}
		state.leaveBlock(switchType); 
		Expect(16);
	}

	void BlockOrSingleStatement(BlockType blockType) {
		if (la.kind == 13) {
			Block(blockType);
		} else if (StartOf(13)) {
			state.enterSSBlock(blockType); 
			Statement();
			state.leaveBlock(blockType); 
		} else SynErr(57);
	}

	void GenericStatement() {
		if (la.kind == 1) {
			Get();
		} else if (la.kind == 3) {
			Get();
		} else if (la.kind == 5) {
			Get();
		} else if (la.kind == 34) {
			ParExpr();
		} else if (la.kind == 47) {
			Instantiation();
		} else SynErr(58);
		while (StartOf(10)) {
			switch (la.kind) {
			case 3: {
				Get();
				break;
			}
			case 2: {
				Get();
				break;
			}
			case 46: {
				ArrowExpression(LAMBDA);
				break;
			}
			case 39: {
				SwitchStatement();
				break;
			}
			case 47: {
				Instantiation();
				break;
			}
			case 1: case 4: case 5: case 6: case 7: case 8: case 10: case 11: case 12: case 13: case 14: case 15: case 16: case 17: case 18: case 19: case 20: case 21: case 22: case 23: case 24: case 25: case 26: case 27: case 28: case 29: case 30: case 31: case 32: case 33: case 34: case 35: case 36: case 37: case 38: case 40: case 41: case 42: case 43: case 44: case 45: case 48: {
				Get();
				break;
			}
			}
		}
		Expect(9);
	}

	void Instantiation() {
		Expect(47);
		QualIdent();
		if (la.kind == 44) {
			AngleBracketExpr();
		}
		if (la.kind == 42) {
			ArrayInitRest();
		} else if (la.kind == 34) {
			ClassInitRest();
		} else SynErr(59);
	}

	void ArrowExpression(BlockType blockType) {
		Expect(46);
		if (la.kind == 13) {
			Block(blockType);
		} else if (StartOf(5)) {
			SSArrowBody(blockType);
		} else SynErr(60);
	}

	void SwitchCase() {
		if (la.kind == 40) {
			Get();
		} else if (la.kind == 41) {
			Get();
		} else SynErr(61);
		while (StartOf(14)) {
			Get();
		}
		if (la.kind == 46) {
			ArrowExpression(ARROW_CASE);
		} else if (la.kind == 30) {
			Get();
			while (la.kind == 40) {
				Get();
				while (StartOf(15)) {
					Get();
				}
				Expect(30);
			}
			state.enterSwitchColonCase(); 
			while (StartOf(13)) {
				Statement();
			}
			state.leaveBlock(COLON_CASE); 
		} else SynErr(62);
	}

	void BracketExpr() {
		Expect(42);
		while (StartOf(16)) {
			Get();
		}
		Expect(43);
	}

	void AngleBracketExpr() {
		Expect(44);
		while (StartOf(17)) {
			if (la.kind == 44) {
				AngleBracketExpr();
			} else {
				Get();
			}
		}
		Expect(45);
	}

	void SSArrowBody(BlockType blockType) {
		state.enterSSBlock(blockType); 
		boolean inSwitch = blockType.isSwitchCase(); 
		switch (la.kind) {
		case 3: {
			Get();
			break;
		}
		case 2: {
			Get();
			break;
		}
		case 34: {
			ParExpr();
			break;
		}
		case 1: {
			Get();
			break;
		}
		case 29: {
			Get();
			state.registerControlBreak(); 
			break;
		}
		case 4: case 5: case 6: case 7: case 8: case 9: case 10: case 11: case 12: case 13: case 14: case 15: case 16: case 17: case 18: case 19: case 20: case 21: case 22: case 23: case 24: case 25: case 26: case 27: case 28: case 30: case 31: case 32: case 33: case 35: case 36: case 37: case 38: case 39: case 40: case 41: case 42: case 43: case 44: case 45: case 46: case 47: case 48: {
			Get();
			break;
		}
		default: SynErr(63); break;
		}
		while (StartOf(18)) {
			if (StartOf(19)) {
				Get();
			} else {
				ParExpr();
			}
		}
		if (!inSwitch) { state.leaveBlock(blockType); return; } 
		if (la.kind == 35) {
			Get();
		} else if (la.kind == 9) {
			Get();
		} else SynErr(64);
		state.leaveBlock(blockType); 
	}

	void ArrayInitRest() {
		BracketExpr();
		if (la.kind == 13) {
			BraceExpr();
		}
	}

	void ClassInitRest() {
		ParExpr();
		if (la.kind == 13) {
			ClassExtension();
		}
	}

	void ClassExtension() {
		state.enterClass(ANONYMOUS, null); 
		Expect(13);
		ClassBody();
		state.leaveClass();
	}



	public void Parse() {
		la = new Token();
		la.val = "";		
		Get();
		JavaFile();
		Expect(0);

	}

	private static final boolean[][] set = {
		{_T,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x},
		{_x,_T,_T,_T, _T,_T,_T,_x, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_x,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _x,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_x, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_x},
		{_x,_x,_T,_x, _x,_x,_T,_T, _T,_x,_T,_x, _x,_x,_x,_T, _T,_T,_T,_x, _x,_x,_x,_T, _T,_x,_x,_x, _x,_x,_T,_x, _x,_x,_x,_T, _x,_x,_T,_x, _T,_T,_T,_T, _T,_T,_T,_x, _T,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_x, _T,_T,_T,_T, _T,_T,_T,_T, _T,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _T,_x,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_x, _T,_T,_T,_T, _T,_T,_T,_T, _T,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _T,_x,_T,_T, _T,_x,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_x,_T, _T,_T,_T,_x, _T,_T,_T,_T, _T,_T,_T,_T, _T,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _T,_x,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_x},
		{_x,_T,_x,_T, _x,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_T, _x,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _T,_x,_T,_T, _T,_x,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_x},
		{_x,_T,_x,_T, _T,_T,_x,_x, _x,_T,_x,_T, _T,_T,_T,_x, _x,_x,_x,_T, _T,_T,_T,_x, _x,_T,_T,_T, _T,_T,_x,_T, _T,_T,_T,_x, _T,_T,_x,_T, _x,_x,_x,_x, _x,_x,_x,_T, _x,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_x,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_x,_T, _T,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_x,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_x, _T,_T,_T,_T, _T,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_x,_T,_T, _T,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _T,_x,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_x, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _T,_x,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_x,_x, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_x}

	};
} // end Parser


class Errors {
	public int count = 0;                                    // number of errors detected
	public java.io.PrintStream errorStream = System.out;     // error messages go to this stream
	public String errMsgFormat = "-- line {0} col {1}: {2}"; // 0=line, 1=column, 2=text
	
	protected void printMsg(int line, int column, String msg) {
		StringBuffer b = new StringBuffer(errMsgFormat);
		int pos = b.indexOf("{0}");
		if (pos >= 0) { b.delete(pos, pos+3); b.insert(pos, line); }
		pos = b.indexOf("{1}");
		if (pos >= 0) { b.delete(pos, pos+3); b.insert(pos, column); }
		pos = b.indexOf("{2}");
		if (pos >= 0) b.replace(pos, pos+3, msg);
		errorStream.println(b.toString());
	}
	
	public void SynErr (int line, int col, int n) {
		String s;
		switch (n) {
			case 0: s = "EOF expected"; break;
			case 1: s = "ident expected"; break;
			case 2: s = "char expected"; break;
			case 3: s = "string expected"; break;
			case 4: s = "class expected"; break;
			case 5: s = "this expected"; break;
			case 6: s = "newRef expected"; break;
			case 7: s = "\"package\" expected"; break;
			case 8: s = "\".\" expected"; break;
			case 9: s = "\";\" expected"; break;
			case 10: s = "\"@interface\" expected"; break;
			case 11: s = "\"@\" expected"; break;
			case 12: s = "\"interface\" expected"; break;
			case 13: s = "\"{\" expected"; break;
			case 14: s = "\"enum\" expected"; break;
			case 15: s = "\",\" expected"; break;
			case 16: s = "\"}\" expected"; break;
			case 17: s = "\"=\" expected"; break;
			case 18: s = "\"static\" expected"; break;
			case 19: s = "\"while\" expected"; break;
			case 20: s = "\"do\" expected"; break;
			case 21: s = "\"for\" expected"; break;
			case 22: s = "\"try\" expected"; break;
			case 23: s = "\"catch\" expected"; break;
			case 24: s = "\"finally\" expected"; break;
			case 25: s = "\"break\" expected"; break;
			case 26: s = "\"continue\" expected"; break;
			case 27: s = "\"return\" expected"; break;
			case 28: s = "\"yield\" expected"; break;
			case 29: s = "\"throw\" expected"; break;
			case 30: s = "\":\" expected"; break;
			case 31: s = "\"super\" expected"; break;
			case 32: s = "\"++\" expected"; break;
			case 33: s = "\"--\" expected"; break;
			case 34: s = "\"(\" expected"; break;
			case 35: s = "\")\" expected"; break;
			case 36: s = "\"synchronized\" expected"; break;
			case 37: s = "\"if\" expected"; break;
			case 38: s = "\"else\" expected"; break;
			case 39: s = "\"switch\" expected"; break;
			case 40: s = "\"case\" expected"; break;
			case 41: s = "\"default\" expected"; break;
			case 42: s = "\"[\" expected"; break;
			case 43: s = "\"]\" expected"; break;
			case 44: s = "\"<\" expected"; break;
			case 45: s = "\">\" expected"; break;
			case 46: s = "\"->\" expected"; break;
			case 47: s = "\"new\" expected"; break;
			case 48: s = "??? expected"; break;
			case 49: s = "invalid Class"; break;
			case 50: s = "invalid Enum"; break;
			case 51: s = "invalid ClassBody"; break;
			case 52: s = "invalid Statement"; break;
			case 53: s = "invalid Statement"; break;
			case 54: s = "invalid Statement"; break;
			case 55: s = "invalid MethodDecl"; break;
			case 56: s = "invalid IfStatement"; break;
			case 57: s = "invalid BlockOrSingleStatement"; break;
			case 58: s = "invalid GenericStatement"; break;
			case 59: s = "invalid Instantiation"; break;
			case 60: s = "invalid ArrowExpression"; break;
			case 61: s = "invalid SwitchCase"; break;
			case 62: s = "invalid SwitchCase"; break;
			case 63: s = "invalid SSArrowBody"; break;
			case 64: s = "invalid SSArrowBody"; break;
			default: s = "error " + n; break;
		}
		printMsg(line, col, s);
		count++;
	}

	public void SemErr (int line, int col, String s) {	
		printMsg(line, col, s);
		count++;
	}
	
	public void SemErr (String s) {
		errorStream.println(s);
		count++;
	}
	
	public void Warning (int line, int col, String s) {	
		printMsg(line, col, s);
	}
	
	public void Warning (String s) {
		errorStream.println(s);
	}
} // Errors


class FatalError extends RuntimeException {
	public static final long serialVersionUID = 1L;
	public FatalError(String s) { super(s); }
}
