/*
 * Decompiled with CFR 0.152.
 */
package auxiliary;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.Supplier;

public class __Counter {
    private static long[] blockCounts;
    private static AtomicLongArray atomicBlockCounts;

    public static void inc(int n) {
        int n2 = n;
        blockCounts[n2] = blockCounts[n2] + 1L;
    }

    public static void incSync(int n) {
        atomicBlockCounts.incrementAndGet(n);
    }

    private static void init(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new RuntimeException("Metadata not found at expected path: " + file.getAbsolutePath());
        }
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
            int nBlocks = ois.readInt();
            blockCounts = new long[nBlocks];
            atomicBlockCounts = new AtomicLongArray(nBlocks);
        }
        catch (IOException | NumberFormatException e) {
            throw new RuntimeException(e);
        }
    }

    private static void save(String fileName) {
        try (DataOutputStream dis = new DataOutputStream(new FileOutputStream(fileName));){
            dis.writeInt(blockCounts.length);
            for (int i = 0; i < blockCounts.length; ++i) {
                dis.writeLong(blockCounts[i] + atomicBlockCounts.get(i));
            }
        }
        catch (IOException | NumberFormatException e) {
            throw new RuntimeException(e);
        }
    }

    public static void incLambda(int n, Runnable method) {
        __Counter.inc(n);
        method.run();
    }

    public static <T> T incLambda(int n, Supplier<T> function) {
        __Counter.inc(n);
        return function.get();
    }

    public static void incLambdaSync(int n, Runnable method) {
        __Counter.incSync(n);
        method.run();
    }

    public static <T> T incLambdaSync(int n, Supplier<T> function) {
        __Counter.incSync(n);
        return function.get();
    }

    static {
        __Counter.init(".profiler/metadata.dat");
        Runtime.getRuntime().addShutdownHook(new Thread(() -> __Counter.save(".profiler/counts.dat")));
    }
}

