/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.cli;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import org.matwoess.jsourceprofiler.common.RunMode;
import org.matwoess.jsourceprofiler.common.Util;

public record Arguments(RunMode runMode, Path targetPath, Path sourcesDir, boolean syncCounters, boolean verboseOutput, String[] programArgs) {
    public static Arguments parse(String[] args) throws IllegalArgumentException {
        int i;
        if (args.length == 0) {
            throw new IllegalArgumentException("No arguments specified.");
        }
        RunMode runMode = RunMode.DEFAULT;
        boolean syncCounters = false;
        boolean verboseOutput = false;
        Path sourcesDir = null;
        block27: for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            switch (args[i]) {
                case "-h": 
                case "--help": {
                    Arguments.printUsage();
                    return null;
                }
                case "-s": 
                case "--synchronized": {
                    syncCounters = true;
                    continue block27;
                }
                case "-v": 
                case "--verbose": {
                    verboseOutput = true;
                    continue block27;
                }
                case "-i": 
                case "--instrument-only": {
                    if (runMode != RunMode.DEFAULT) {
                        throw new IllegalArgumentException("Multiple run modes specified.");
                    }
                    runMode = RunMode.INSTRUMENT_ONLY;
                    continue block27;
                }
                case "-r": 
                case "--generate-report": {
                    if (runMode != RunMode.DEFAULT) {
                        throw new IllegalArgumentException("Multiple run modes specified.");
                    }
                    runMode = RunMode.REPORT_ONLY;
                    continue block27;
                }
                case "-d": 
                case "--sources-directory": {
                    if (++i == args.length) {
                        throw new IllegalArgumentException("No sources directory specified.");
                    }
                    sourcesDir = Path.of(args[i], new String[0]);
                    if (sourcesDir.toFile().isDirectory()) continue block27;
                    throw new IllegalArgumentException("Not a directory: " + String.valueOf(sourcesDir.toAbsolutePath().normalize()));
                }
                default: {
                    throw new IllegalArgumentException("Unknown option: " + args[i]);
                }
            }
        }
        String[] remainingArgs = Arrays.copyOfRange(args, i, args.length);
        Path targetPath = null;
        String[] programArgs = null;
        if (remainingArgs.length > 0) {
            targetPath = Path.of(remainingArgs[0], new String[0]);
        }
        switch (runMode) {
            case REPORT_ONLY: {
                if (remainingArgs.length <= 0) break;
                throw new IllegalArgumentException("No arguments allowed for the report-only run mode.");
            }
            case INSTRUMENT_ONLY: {
                if (remainingArgs.length == 1) break;
                throw new IllegalArgumentException("Exactly one argument required for the instrument-only run mode.");
            }
            case DEFAULT: {
                if (remainingArgs.length == 0) {
                    throw new IllegalArgumentException("No main file specified.");
                }
                if (!Util.isJavaFile((Path)targetPath)) {
                    throw new IllegalArgumentException("Not a Java source file: " + String.valueOf(targetPath.toAbsolutePath().normalize()));
                }
                if (sourcesDir != null && !Util.isAncestorOf((Path)sourcesDir, (Path)targetPath)) {
                    throw new IllegalArgumentException("Main file must be located inside the sources directory or in any child directory.");
                }
                if (remainingArgs.length <= 1) break;
                programArgs = Arrays.copyOfRange(remainingArgs, 1, remainingArgs.length);
            }
        }
        return new Arguments(runMode, targetPath, sourcesDir, syncCounters, verboseOutput, programArgs);
    }

    public static void printUsage() {
        System.out.println(Arguments.getUsage());
    }

    public static String getUsage() {
        return "Usage: profiler [options] <main file> [program args]\nOr   : profiler [options] <run mode>\nOptions:\n  -h, --help                        display this message and quit\n  -s, --synchronized                instrument using synchronized counter increments\n  -v, --verbose                     output verbose info about instrumentation of files\n  -d, --sources-directory <dir>     directory with additional Java files to instrument\nRun mode (exclusive):\n  -i, --instrument-only <file|dir>  only instrument a single file or directory and exit\n  -r, --generate-report             only generate the report from metadata and counts\nMain file:\n  The path to the main Java file. It will be compiled and and executed after instrumentation.\n  (Must not be specified for the generate-report run mode)\nProgram args:\n  Will be passed to the main method if given\n";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Arguments arguments = (Arguments)o;
        if (this.syncCounters != arguments.syncCounters) {
            return false;
        }
        if (this.verboseOutput != arguments.verboseOutput) {
            return false;
        }
        if (this.runMode != arguments.runMode) {
            return false;
        }
        if (!Objects.equals(this.targetPath, arguments.targetPath)) {
            return false;
        }
        if (!Objects.equals(this.sourcesDir, arguments.sourcesDir)) {
            return false;
        }
        return Arrays.equals(this.programArgs, arguments.programArgs);
    }

    @Override
    public int hashCode() {
        int result = this.runMode.hashCode();
        result = 31 * result + (this.targetPath != null ? this.targetPath.hashCode() : 0);
        result = 31 * result + (this.sourcesDir != null ? this.sourcesDir.hashCode() : 0);
        result = 31 * result + (this.syncCounters ? 1 : 0);
        result = 31 * result + (this.verboseOutput ? 1 : 0);
        result = 31 * result + Arrays.hashCode(this.programArgs);
        return result;
    }
}

