/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.cli;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class FileCollector {
    final Path baseDirectory;
    final String fileExtension;
    final boolean excludeHiddenDirs;
    final List<String> nameExclusions = new ArrayList<String>();
    final List<Path> pathExclusions = new ArrayList<Path>();

    public FileCollector(Path baseDir, String fileExtension, boolean excludeHiddenDirs) {
        this.baseDirectory = baseDir.normalize();
        this.fileExtension = "." + fileExtension.toLowerCase();
        this.excludeHiddenDirs = excludeHiddenDirs;
    }

    public FileCollector excludeFileName(String fileName) {
        this.nameExclusions.add(fileName);
        return this;
    }

    public FileCollector excludePath(Path exclusion) {
        if (exclusion != null) {
            this.pathExclusions.add(exclusion.toAbsolutePath().normalize());
        }
        return this;
    }

    public List<Path> collect() {
        final ArrayList<Path> files = new ArrayList<Path>();
        try {
            Files.walkFileTree(this.baseDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    String dirName;
                    if (FileCollector.this.excludeHiddenDirs && (dirName = dir.getFileName().toString()).startsWith(".") && !dirName.startsWith("..")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String fileName = file.getFileName().toString();
                    if (fileName.toLowerCase().endsWith(FileCollector.this.fileExtension) && !FileCollector.this.nameExclusions.contains(fileName) && !FileCollector.this.pathExclusions.contains(file.toAbsolutePath().normalize())) {
                        files.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Error while scanning directory for files", e);
        }
        return files;
    }
}

