/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.cli;

import java.nio.file.Path;
import org.matwoess.jsourceprofiler.common.Util;
import org.matwoess.jsourceprofiler.tool.cli.Arguments;
import org.matwoess.jsourceprofiler.tool.cli.FileCollector;
import org.matwoess.jsourceprofiler.tool.instrument.Instrumenter;
import org.matwoess.jsourceprofiler.tool.model.JavaFile;
import org.matwoess.jsourceprofiler.tool.profile.Profiler;

public class Main {
    public static void main(String[] args) {
        Arguments arguments = null;
        try {
            arguments = Arguments.parse(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.out.println("Use -h for help.");
            System.exit(1);
        }
        if (arguments == null) {
            return;
        }
        switch (arguments.runMode()) {
            case REPORT_ONLY: {
                Main.generateReportOnly();
                break;
            }
            case INSTRUMENT_ONLY: {
                Main.instrumentOnly(arguments);
                break;
            }
            case DEFAULT: {
                Main.instrumentCompileAndRun(arguments);
            }
        }
    }

    private static void generateReportOnly() {
        Profiler profiler = new Profiler(null, new JavaFile[0]);
        profiler.generateReport();
        profiler.createLinkForReport();
    }

    private static void instrumentOnly(Arguments arguments) {
        JavaFile[] javaFiles = arguments.targetPath().toFile().isFile() ? new JavaFile[]{new JavaFile(arguments.targetPath())} : Main.getJavaFilesInFolder(arguments.targetPath(), null);
        Instrumenter instrumenter = new Instrumenter(javaFiles, arguments);
        instrumenter.analyzeFiles();
        instrumenter.instrumentFiles();
        instrumenter.exportMetadata();
    }

    private static void instrumentCompileAndRun(Arguments arguments) {
        JavaFile mainJavaFile;
        Object[] additionalJavaFiles = new JavaFile[]{};
        if (arguments.sourcesDir() != null) {
            mainJavaFile = new JavaFile(arguments.targetPath(), arguments.sourcesDir());
            additionalJavaFiles = Main.getJavaFilesInFolder(arguments.sourcesDir(), arguments.targetPath());
        } else {
            mainJavaFile = new JavaFile(arguments.targetPath());
        }
        JavaFile[] allJavaFiles = (JavaFile[])Util.prependToArray((Object[])additionalJavaFiles, (Object[])new JavaFile[]{mainJavaFile});
        Instrumenter instrumenter = new Instrumenter(allJavaFiles, arguments);
        instrumenter.analyzeFiles();
        instrumenter.instrumentFiles();
        instrumenter.exportMetadata();
        Profiler profiler = new Profiler(mainJavaFile, (JavaFile[])additionalJavaFiles);
        profiler.compileInstrumented();
        profiler.profile(arguments.programArgs());
        profiler.generateReport();
        profiler.createLinkForReport();
    }

    private static JavaFile[] getJavaFilesInFolder(Path sourcesFolder, Path exceptFor) {
        return (JavaFile[])new FileCollector(sourcesFolder, "java", true).excludeFileName("package-info.java").excludeFileName("module-info.java").excludePath(exceptFor).collect().stream().map(sourceFile -> new JavaFile((Path)sourceFile, sourcesFolder)).toArray(JavaFile[]::new);
    }
}

