/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.instrument;

import java.io.PrintStream;

class Errors {
    public int count = 0;
    public PrintStream errorStream = System.out;
    public String errMsgFormat = "-- line {0} col {1}: {2}";

    Errors() {
    }

    protected void printMsg(int line, int column, String msg) {
        StringBuffer b = new StringBuffer(this.errMsgFormat);
        int pos = b.indexOf("{0}");
        if (pos >= 0) {
            b.delete(pos, pos + 3);
            b.insert(pos, line);
        }
        if ((pos = b.indexOf("{1}")) >= 0) {
            b.delete(pos, pos + 3);
            b.insert(pos, column);
        }
        if ((pos = b.indexOf("{2}")) >= 0) {
            b.replace(pos, pos + 3, msg);
        }
        this.errorStream.println(b.toString());
    }

    public void SynErr(int line, int col, int n) {
        this.printMsg(line, col, (String)(switch (n) {
            case 0 -> "EOF expected";
            case 1 -> "ident expected";
            case 2 -> "char expected";
            case 3 -> "string expected";
            case 4 -> "class expected";
            case 5 -> "this expected";
            case 6 -> "newRef expected";
            case 7 -> "\"package\" expected";
            case 8 -> "\".\" expected";
            case 9 -> "\";\" expected";
            case 10 -> "\"@interface\" expected";
            case 11 -> "\"@\" expected";
            case 12 -> "\"interface\" expected";
            case 13 -> "\"{\" expected";
            case 14 -> "\"enum\" expected";
            case 15 -> "\",\" expected";
            case 16 -> "\"}\" expected";
            case 17 -> "\"=\" expected";
            case 18 -> "\"static\" expected";
            case 19 -> "\"while\" expected";
            case 20 -> "\"do\" expected";
            case 21 -> "\"for\" expected";
            case 22 -> "\"try\" expected";
            case 23 -> "\"catch\" expected";
            case 24 -> "\"finally\" expected";
            case 25 -> "\"break\" expected";
            case 26 -> "\"continue\" expected";
            case 27 -> "\"return\" expected";
            case 28 -> "\"yield\" expected";
            case 29 -> "\"throw\" expected";
            case 30 -> "\":\" expected";
            case 31 -> "\"super\" expected";
            case 32 -> "\"++\" expected";
            case 33 -> "\"--\" expected";
            case 34 -> "\"(\" expected";
            case 35 -> "\")\" expected";
            case 36 -> "\"synchronized\" expected";
            case 37 -> "\"if\" expected";
            case 38 -> "\"else\" expected";
            case 39 -> "\"switch\" expected";
            case 40 -> "\"case\" expected";
            case 41 -> "\"default\" expected";
            case 42 -> "\"[\" expected";
            case 43 -> "\"]\" expected";
            case 44 -> "\"<\" expected";
            case 45 -> "\">\" expected";
            case 46 -> "\"->\" expected";
            case 47 -> "\"new\" expected";
            case 48 -> "??? expected";
            case 49 -> "invalid Class";
            case 50 -> "invalid Enum";
            case 51 -> "invalid ClassBody";
            case 52 -> "invalid Statement";
            case 53 -> "invalid Statement";
            case 54 -> "invalid Statement";
            case 55 -> "invalid MethodDecl";
            case 56 -> "invalid IfStatement";
            case 57 -> "invalid BlockOrSingleStatement";
            case 58 -> "invalid GenericStatement";
            case 59 -> "invalid Instantiation";
            case 60 -> "invalid ArrowExpression";
            case 61 -> "invalid SwitchCase";
            case 62 -> "invalid SwitchCase";
            case 63 -> "invalid SSArrowBody";
            case 64 -> "invalid SSArrowBody";
            default -> "error " + n;
        }));
        ++this.count;
    }

    public void SemErr(int line, int col, String s) {
        this.printMsg(line, col, s);
        ++this.count;
    }

    public void SemErr(String s) {
        this.errorStream.println(s);
        ++this.count;
    }

    public void Warning(int line, int col, String s) {
        this.printMsg(line, col, s);
    }

    public void Warning(String s) {
        this.errorStream.println(s);
    }
}

