/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.instrument;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.matwoess.jsourceprofiler.common.IO;
import org.matwoess.jsourceprofiler.tool.cli.Arguments;
import org.matwoess.jsourceprofiler.tool.instrument.Parser;
import org.matwoess.jsourceprofiler.tool.instrument.Scanner;
import org.matwoess.jsourceprofiler.tool.model.Block;
import org.matwoess.jsourceprofiler.tool.model.BlockType;
import org.matwoess.jsourceprofiler.tool.model.CodeInsert;
import org.matwoess.jsourceprofiler.tool.model.ControlBreak;
import org.matwoess.jsourceprofiler.tool.model.JavaFile;
import org.matwoess.jsourceprofiler.tool.model.Metadata;

public class Instrumenter {
    JavaFile[] javaFiles;
    int blockCounter;
    public String incRefAdd;
    boolean verboseOutput;

    public Instrumenter(JavaFile[] javaFiles, Arguments toolArgs) {
        assert (javaFiles.length > 0);
        this.verboseOutput = toolArgs.verboseOutput();
        this.incRefAdd = toolArgs.syncCounters() ? "Sync" : "";
        this.javaFiles = javaFiles;
    }

    public void analyzeFiles() {
        Arrays.stream(this.javaFiles).forEach(this::analyze);
    }

    void analyze(JavaFile javaFile) {
        System.out.println("Parsing file: \"" + String.valueOf(javaFile.sourceFile) + "\"");
        Parser parser = new Parser(new Scanner(javaFile.sourceFile.toString()));
        parser.state.logger.active = this.verboseOutput;
        parser.Parse();
        int errors = parser.errors.count;
        if (errors > 0) {
            throw new RuntimeException("Abort due to parse errors.");
        }
        javaFile.packageName = parser.state.packageName;
        javaFile.beginOfImports = parser.state.beginOfImports;
        javaFile.foundBlocks = parser.state.allBlocks;
        javaFile.topLevelClasses = parser.state.topLevelClasses;
    }

    public void instrumentFiles() {
        IO.clearDirectoryContents((Path)IO.getInstrumentDir());
        this.blockCounter = 0;
        try {
            for (JavaFile javaFile : this.javaFiles) {
                this.instrument(javaFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Instrumenter.copyAuxiliaryFiles();
        System.out.println();
        List allClasses = Arrays.stream(this.javaFiles).flatMap(jFile -> jFile.getClassesRecursive().stream()).toList();
        System.out.println("Total classes found: " + allClasses.size());
        List allMethods = allClasses.stream().flatMap(cls -> cls.methods.stream()).toList();
        System.out.println("Total methods found: " + allMethods.size());
        System.out.println("Total code block found: " + this.blockCounter);
    }

    void instrument(JavaFile javaFile) throws IOException {
        List<CodeInsert> codeInserts = this.getCodeInserts(javaFile);
        String fileContent = Files.readString(javaFile.sourceFile, StandardCharsets.ISO_8859_1);
        StringBuilder builder = new StringBuilder();
        int prevIdx = 0;
        for (CodeInsert codeInsert : codeInserts) {
            builder.append(fileContent, prevIdx, codeInsert.chPos());
            prevIdx = codeInsert.chPos();
            builder.append(codeInsert.code());
        }
        builder.append(fileContent.substring(prevIdx));
        Path instrumentedFilePath = IO.getInstrumentedFilePath((Path)javaFile.relativePath);
        IO.createDirectoriesIfNotExists((Path)instrumentedFilePath);
        Files.writeString(instrumentedFilePath, (CharSequence)builder.toString(), new OpenOption[0]);
    }

    List<CodeInsert> getCodeInserts(JavaFile javaFile) {
        ArrayList<CodeInsert> inserts = new ArrayList<CodeInsert>();
        inserts.add(new CodeInsert(javaFile.beginOfImports, "import auxiliary.__Counter;"));
        for (Block block : javaFile.foundBlocks) {
            if (block.blockType.isSwitchBody()) continue;
            if (block.isSingleStatement && block.blockType != BlockType.LAMBDA) {
                assert (block.blockType != BlockType.METHOD);
                inserts.add(new CodeInsert(block.beg.pos(), "{"));
            }
            if (block.isSingleStatement && block.blockType == BlockType.LAMBDA) {
                inserts.add(new CodeInsert(block.getIncInsertPos(), String.format("__Counter.incLambda%s(%d, () -> ", this.incRefAdd, this.blockCounter++)));
                inserts.add(new CodeInsert(block.end.pos(), ")"));
            } else {
                inserts.add(new CodeInsert(block.getIncInsertPos(), String.format("__Counter.inc%s(%d);", this.incRefAdd, this.blockCounter++)));
            }
            if (block.isSingleStatement && block.isSwitchExpressionCase() && (block.controlBreak == null || block.controlBreak.kind() != ControlBreak.Kind.THROW)) {
                inserts.add(new CodeInsert(block.getIncInsertPos(), "yield "));
            }
            if (!block.isSingleStatement || block.blockType == BlockType.LAMBDA) continue;
            inserts.add(new CodeInsert(block.end.pos(), "}"));
        }
        inserts.sort(Comparator.comparing(CodeInsert::chPos));
        return inserts;
    }

    public void exportMetadata() {
        new Metadata(this.blockCounter, this.javaFiles).exportMetadata(IO.getMetadataPath());
    }

    public static void copyAuxiliaryFiles() {
        IO.copyResource(Instrumenter.class, (String)"auxiliary/__Counter.class", (Path)IO.getAuxiliaryCounterInstrumentPath());
    }
}

