/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.instrument;

import java.util.List;
import org.matwoess.jsourceprofiler.tool.instrument.Parser;
import org.matwoess.jsourceprofiler.tool.model.Block;
import org.matwoess.jsourceprofiler.tool.model.CodeRegion;
import org.matwoess.jsourceprofiler.tool.model.Component;
import org.matwoess.jsourceprofiler.tool.model.JClass;
import org.matwoess.jsourceprofiler.tool.model.Method;

public class Logger {
    private static final String GREEN = "\u001b[32m";
    private static final String RED = "\u001b[31m";
    private static final String BRIGHT = "\u001b[97m";
    private static final String RESET = "\u001b[0m";
    private final Parser parser;
    private static int indent = 1;
    public boolean active;

    public Logger(Parser p) {
        this.parser = p;
    }

    public void log(String logMessage) {
        if (!this.active) {
            return;
        }
        System.out.printf("%s%3d:%s%-" + indent + "s%s%n", BRIGHT, this.parser.t.line, RESET, "", logMessage);
    }

    public void log(String formatString, Object ... values) {
        this.log(String.format(formatString, values));
    }

    void enter(Component comp) {
        this.log(this.describe(comp, false) + "\u001b[32m -->\u001b[0m");
        indent += 2;
    }

    void leave(Component comp) {
        indent -= 2;
        this.log(this.describe(comp, true) + "\u001b[31m <--\u001b[0m");
    }

    private String describe(Component comp, boolean leave) {
        if (comp instanceof JClass) {
            JClass clazz = (JClass)comp;
            return "class <" + clazz.getFullName() + ">";
        }
        if (comp instanceof Method) {
            Method meth = (Method)comp;
            return String.valueOf(meth) + "()";
        }
        if (comp instanceof Block) {
            Block block = (Block)comp;
            return String.format("%s%s%s [%d]%s", new Object[]{block.labels.isEmpty() ? "" : String.join((CharSequence)": ", block.labels) + ": ", block.blockType, block.isSingleStatement ? ", SS" : "", leave ? block.end.pos() : block.beg.pos(), block.controlBreak == null ? "" : " (" + String.valueOf(block.controlBreak) + ")"});
        }
        if (comp instanceof CodeRegion) {
            CodeRegion region = (CodeRegion)comp;
            List<String> minusBlockLineNrs = region.dependentBlocks.stream().map(b -> String.valueOf(b.beg.line())).toList();
            return String.format("region [%d]%s", leave ? region.end.pos() : region.beg.pos(), minusBlockLineNrs.isEmpty() ? "" : " -(" + String.join((CharSequence)",", minusBlockLineNrs) + ")");
        }
        throw new RuntimeException("unknown component type: " + String.valueOf(comp.getClass()));
    }
}

