/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.instrument;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.matwoess.jsourceprofiler.tool.instrument.Logger;
import org.matwoess.jsourceprofiler.tool.instrument.Parser;
import org.matwoess.jsourceprofiler.tool.instrument.Token;
import org.matwoess.jsourceprofiler.tool.instrument.Util;
import org.matwoess.jsourceprofiler.tool.model.Block;
import org.matwoess.jsourceprofiler.tool.model.BlockType;
import org.matwoess.jsourceprofiler.tool.model.ClassType;
import org.matwoess.jsourceprofiler.tool.model.CodeRegion;
import org.matwoess.jsourceprofiler.tool.model.ControlBreak;
import org.matwoess.jsourceprofiler.tool.model.JClass;
import org.matwoess.jsourceprofiler.tool.model.Method;

public class ParserState {
    private final Parser parser;
    final Logger logger;
    int beginOfImports = 0;
    String packageName = null;
    final List<JClass> topLevelClasses = new ArrayList<JClass>();
    final List<Block> allBlocks = new ArrayList<Block>();
    private final Stack<Block> blockBackupStack = new Stack();
    private JClass curClass = null;
    private Method curMeth = null;
    private Block curBlock = null;
    private int curBlockId = 0;
    private CodeRegion curCodeRegion;
    private final List<String> curLabels = new ArrayList<String>();

    public ParserState(Parser p) {
        this.parser = p;
        this.logger = new Logger(p);
    }

    void setPackageName(List<String> packageName) {
        this.packageName = String.join((CharSequence)".", packageName);
        this.beginOfImports = Util.endOfToken(this.parser.t);
    }

    void markEndOfSuperCall() {
        assert (this.curClass != null && this.curMeth != null && this.curBlock.blockType == BlockType.CONSTRUCTOR);
        this.curBlock.incInsertOffset = Util.endOfToken(this.parser.t) - this.curBlock.beg.pos();
    }

    void registerLabel() {
        this.curLabels.add(this.parser.la.val);
    }

    void registerControlBreak() {
        ControlBreak controlBreak = (this.parser.t.val.equals("break") || this.parser.t.val.equals("continue")) && this.parser.la.kind == 1 ? ControlBreak.fromTokenWithLabel(this.parser.t.val, this.parser.la.val) : ControlBreak.fromToken(this.parser.t.val);
        this.curBlock.controlBreak = controlBreak;
        this.logger.log("> found control break: %s", controlBreak);
        this.registerControlBreakInOuterBlocks(controlBreak);
    }

    private void registerControlBreakInOuterBlocks(ControlBreak controlBreak) {
        if (controlBreak.stopPropagationAt(this.curBlock)) {
            return;
        }
        Block block = this.curBlock.parentBlock;
        while (block != null) {
            block.registerInnerControlBreak(this.curBlock);
            if (controlBreak.stopPropagationAt(block)) break;
            block = block.parentBlock;
        }
    }

    void enterClass(ClassType classType, String className) {
        this.endCodeRegion();
        JClass newClass = new JClass(className, classType);
        newClass.packageName = this.packageName;
        newClass.setParentClass(this.curClass);
        if (this.curClass == null) {
            this.topLevelClasses.add(newClass);
        }
        if (this.curBlock != null) {
            this.blockBackupStack.push(this.curBlock);
            this.curBlock = null;
            this.curMeth = null;
        }
        this.logger.enter(newClass);
        this.curClass = newClass;
    }

    void leaveClass() {
        this.logger.leave(this.curClass);
        if (!(this.curClass.classType != ClassType.ANONYMOUS && this.curClass.classType != ClassType.LOCAL || this.blockBackupStack.isEmpty())) {
            this.curBlock = this.blockBackupStack.pop();
            this.curMeth = this.curBlock.method;
            this.reenterBlock(this.curBlock.blockType, true);
        }
        this.curClass = this.curClass.parentClass;
    }

    void enterMethod(String methName) {
        assert (this.curClass != null);
        this.curMeth = new Method(methName);
        this.curMeth.setParentClass(this.curClass);
        this.logger.enter(this.curMeth);
    }

    void registerAbstractMethod(String methName) {
        assert (this.curClass != null);
        new Method(methName).setParentClass(this.curClass);
        this.logger.log("> found abstract method: %s", methName);
    }

    void leaveMethod() {
        assert (this.curMeth != null);
        this.logger.leave(this.curMeth);
        this.curMeth = null;
    }

    void enterBlock(BlockType blockType) {
        if (blockType == BlockType.METHOD && this.curMeth.name.equals(this.curClass.name)) {
            blockType = BlockType.CONSTRUCTOR;
        }
        this.enterBlock(blockType, false);
    }

    void enterSSBlock(BlockType blockType) {
        this.enterBlock(blockType, true);
    }

    void enterSwitchColonCase() {
        assert (this.curBlock != null && this.curBlock.blockType.isSwitchBody());
        this.enterBlock(BlockType.COLON_CASE, true);
    }

    private void enterBlock(BlockType blockType, boolean missingBraces) {
        assert (this.curClass != null);
        this.endCodeRegion();
        Block newBlock = new Block(blockType);
        newBlock.id = this.curBlockId++;
        newBlock.setParentBlock(this.curBlock);
        newBlock.setParentMethod(this.curMeth);
        newBlock.setParentClass(this.curClass);
        newBlock.isSingleStatement = blockType != BlockType.COLON_CASE && missingBraces;
        newBlock.beg = Util.getBlockBegPos(this.parser, blockType, missingBraces);
        newBlock.incInsertOffset = Util.getIncInsertOffset(this.parser, blockType, missingBraces);
        this.allBlocks.add(newBlock);
        if (!this.curLabels.isEmpty()) {
            newBlock.labels.addAll(this.curLabels);
            this.curLabels.clear();
        }
        this.logger.enter(newBlock);
        this.curBlock = newBlock;
        this.startCodeRegion(blockType, missingBraces);
    }

    void leaveBlock(BlockType blockType) {
        this.leaveBlock(blockType, this.curBlock.hasNoBraces());
    }

    private void leaveBlock(BlockType blockType, boolean missingBraces) {
        this.curBlock.end = Util.tokenEndPosition(missingBraces ? this.parser.t : this.parser.la);
        this.logger.leave(this.curBlock);
        this.endCodeRegion();
        this.curBlock = this.curBlock.parentBlock;
        this.reenterBlock(blockType, missingBraces);
    }

    private void startCodeRegion(BlockType blockType, boolean missingBraces) {
        assert (this.curCodeRegion == null);
        Token nextToken = Util.getRegionStartToken(this.parser, blockType, missingBraces);
        if (this.validCodeRegionStartToken(nextToken)) {
            this.curCodeRegion = new CodeRegion();
            this.curCodeRegion.beg = Util.tokenStartPosition(nextToken);
            this.curCodeRegion.block = this.curBlock;
            this.logger.enter(this.curCodeRegion);
        }
    }

    private boolean validCodeRegionStartToken(Token nextToken) {
        if (!this.curBlock.blockType.hasCounter()) {
            return false;
        }
        return !nextToken.val.equals("else") && !nextToken.val.equals("catch") && !nextToken.val.equals("finally");
    }

    private void endCodeRegion() {
        if (this.curCodeRegion == null) {
            return;
        }
        this.curCodeRegion.end = Util.tokenEndPosition(this.parser.t);
        this.logger.leave(this.curCodeRegion);
        this.curBlock.addCodeRegion(this.curCodeRegion);
        this.curCodeRegion = null;
    }

    private void reenterBlock(BlockType blockType, boolean missingBraces) {
        Token nextToken;
        if (this.curBlock == null) {
            return;
        }
        Token token = nextToken = missingBraces ? this.parser.la : this.parser.scanner.Peek();
        if (this.validCodeRegionStartToken(nextToken)) {
            this.startCodeRegion(blockType, missingBraces);
            this.curCodeRegion.dependentBlocks.addAll(this.curBlock.innerControlBreaks);
        }
    }

    boolean identAndLPar() {
        this.parser.scanner.ResetPeek();
        return this.parser.la.kind == 1 && this.parser.scanner.Peek().val.equals("(");
    }

    boolean classNameAndLBrace() {
        this.parser.scanner.ResetPeek();
        return this.parser.la.val.equals(this.curClass.name) && this.parser.scanner.Peek().val.equals("{");
    }

    boolean staticAndLBrace() {
        this.parser.scanner.ResetPeek();
        return this.parser.la.val.equals("static") && this.parser.scanner.Peek().val.equals("{");
    }

    boolean isLabel() {
        return this.parser.la.kind == 1 && this.parser.scanner.Peek().val.equals(":");
    }

    boolean thisAndLPar() {
        return this.parser.la.val.equals("this") && this.parser.scanner.Peek().val.equals("(");
    }

    boolean isAssignment() {
        return this.parser.t.val.equals("=") || this.parser.t.val.equals("return") || this.parser.t.val.equals("yield");
    }

    boolean classDefWithNoLeadingDot() {
        this.parser.scanner.ResetPeek();
        return !this.parser.t.val.equals(".") && (this.parser.la.val.equals("class") || this.parser.la.val.equals("interface") || this.parser.la.val.equals("record") && this.parser.scanner.Peek().kind == 1);
    }
}

