/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.instrument;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.matwoess.jsourceprofiler.tool.instrument.Buffer;
import org.matwoess.jsourceprofiler.tool.instrument.FatalError;
import org.matwoess.jsourceprofiler.tool.instrument.StartStates;
import org.matwoess.jsourceprofiler.tool.instrument.Token;
import org.matwoess.jsourceprofiler.tool.instrument.UTF8Buffer;

public class Scanner {
    static final char EOL = '\n';
    static final int eofSym = 0;
    static final int maxT = 48;
    static final int noSym = 48;
    public Buffer buffer;
    Token t;
    int ch;
    int pos;
    int charPos;
    int col;
    int line;
    int oldEols;
    static final StartStates start;
    static final Map literals;
    Token tokens;
    Token pt;
    char[] tval = new char[16];
    int tlen;

    public Scanner(String fileName) {
        this.buffer = new Buffer(fileName);
        this.Init();
    }

    public Scanner(InputStream s) {
        this.buffer = new Buffer(s);
        this.Init();
    }

    void Init() {
        this.pos = -1;
        this.line = 1;
        this.col = 0;
        this.charPos = -1;
        this.oldEols = 0;
        this.NextCh();
        if (this.ch == 239) {
            this.NextCh();
            int ch1 = this.ch;
            this.NextCh();
            int ch2 = this.ch;
            if (ch1 != 187 || ch2 != 191) {
                throw new FatalError("Illegal byte order mark at start of file");
            }
            this.buffer = new UTF8Buffer(this.buffer);
            this.col = 0;
            this.charPos = -1;
            this.NextCh();
        }
        this.pt = this.tokens = new Token();
    }

    void NextCh() {
        if (this.oldEols > 0) {
            this.ch = 10;
            --this.oldEols;
        } else {
            this.pos = this.buffer.getPos();
            this.ch = this.buffer.Read();
            ++this.col;
            ++this.charPos;
            if (this.ch == 13 && this.buffer.Peek() != 10) {
                this.ch = 10;
            }
            if (this.ch == 10) {
                ++this.line;
                this.col = 0;
            }
        }
    }

    void AddCh() {
        if (this.tlen >= this.tval.length) {
            char[] newBuf = new char[2 * this.tval.length];
            System.arraycopy(this.tval, 0, newBuf, 0, this.tval.length);
            this.tval = newBuf;
        }
        if (this.ch != 65536) {
            this.tval[this.tlen++] = (char)this.ch;
            this.NextCh();
        }
    }

    boolean Comment0() {
        int level = 1;
        int pos0 = this.pos;
        int line0 = this.line;
        int col0 = this.col;
        int charPos0 = this.charPos;
        this.NextCh();
        if (this.ch == 47) {
            this.NextCh();
            while (true) {
                if (this.ch == 10) {
                    if (--level == 0) {
                        this.oldEols = this.line - line0;
                        this.NextCh();
                        return true;
                    }
                    this.NextCh();
                    continue;
                }
                if (this.ch == 65536) {
                    return false;
                }
                this.NextCh();
            }
        }
        this.buffer.setPos(pos0);
        this.NextCh();
        this.line = line0;
        this.col = col0;
        this.charPos = charPos0;
        return false;
    }

    boolean Comment1() {
        int level = 1;
        int pos0 = this.pos;
        int line0 = this.line;
        int col0 = this.col;
        int charPos0 = this.charPos;
        this.NextCh();
        if (this.ch == 42) {
            this.NextCh();
            while (true) {
                if (this.ch == 42) {
                    this.NextCh();
                    if (this.ch != 47) continue;
                    if (--level == 0) {
                        this.oldEols = this.line - line0;
                        this.NextCh();
                        return true;
                    }
                    this.NextCh();
                    continue;
                }
                if (this.ch == 65536) {
                    return false;
                }
                this.NextCh();
            }
        }
        this.buffer.setPos(pos0);
        this.NextCh();
        this.line = line0;
        this.col = col0;
        this.charPos = charPos0;
        return false;
    }

    void CheckLiteral() {
        String val = this.t.val;
        Object kind = literals.get(val);
        if (kind != null) {
            this.t.kind = (Integer)kind;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    Token NextToken() {
        while (this.ch == 32 || this.ch >= 9 && this.ch <= 10 || this.ch == 13) {
            this.NextCh();
        }
        if (this.ch == 47 && this.Comment0() || this.ch == 47 && this.Comment1()) {
            return this.NextToken();
        }
        int recKind = 48;
        int recEnd = this.pos;
        this.t = new Token();
        this.t.pos = this.pos;
        this.t.col = this.col;
        this.t.line = this.line;
        this.t.charPos = this.charPos;
        int state = start.state(this.ch);
        this.tlen = 0;
        this.AddCh();
        block69: while (true) {
            switch (state) {
                case -1: {
                    this.t.kind = 0;
                    break block69;
                }
                case 0: {
                    if (recKind != 48) {
                        this.tlen = recEnd - this.t.pos;
                        this.SetScannerBehindT();
                    }
                    this.t.kind = recKind;
                    break block69;
                }
                case 1: {
                    recEnd = this.pos;
                    recKind = 1;
                    if (this.ch >= 48 && this.ch <= 57 || this.ch >= 65 && this.ch <= 90 || this.ch == 95 || this.ch >= 97 && this.ch <= 122) {
                        this.AddCh();
                        state = 1;
                        break;
                    }
                    this.t.kind = 1;
                    this.t.val = new String(this.tval, 0, this.tlen);
                    this.CheckLiteral();
                    return this.t;
                }
                case 2: {
                    if (this.ch <= 9 || this.ch >= 11 && this.ch <= 12 || this.ch >= 14 && this.ch <= 38 || this.ch >= 40 && this.ch <= 91 || this.ch >= 93 && this.ch <= 65535) {
                        this.AddCh();
                        state = 3;
                        break;
                    }
                    if (this.ch == 92) {
                        this.AddCh();
                        state = 4;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 3: {
                    if (this.ch == 39) {
                        this.AddCh();
                        state = 10;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 4: {
                    if (this.ch == 34 || this.ch == 39 || this.ch == 92 || this.ch == 98 || this.ch == 102 || this.ch == 110 || this.ch >= 114 && this.ch <= 116) {
                        this.AddCh();
                        state = 3;
                        break;
                    }
                    if (this.ch >= 52 && this.ch <= 55) {
                        this.AddCh();
                        state = 9;
                        break;
                    }
                    if (this.ch >= 48 && this.ch <= 51) {
                        this.AddCh();
                        state = 26;
                        break;
                    }
                    if (this.ch == 117) {
                        this.AddCh();
                        state = 5;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 5: {
                    if (this.ch >= 48 && this.ch <= 57 || this.ch >= 65 && this.ch <= 70 || this.ch >= 97 && this.ch <= 102) {
                        this.AddCh();
                        state = 6;
                        break;
                    }
                    if (this.ch == 117) {
                        this.AddCh();
                        state = 5;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 6: {
                    if (this.ch >= 48 && this.ch <= 57 || this.ch >= 65 && this.ch <= 70 || this.ch >= 97 && this.ch <= 102) {
                        this.AddCh();
                        state = 7;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 7: {
                    if (this.ch >= 48 && this.ch <= 57 || this.ch >= 65 && this.ch <= 70 || this.ch >= 97 && this.ch <= 102) {
                        this.AddCh();
                        state = 8;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 8: {
                    if (this.ch >= 48 && this.ch <= 57 || this.ch >= 65 && this.ch <= 70 || this.ch >= 97 && this.ch <= 102) {
                        this.AddCh();
                        state = 3;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 9: {
                    if (this.ch == 39) {
                        this.AddCh();
                        state = 10;
                        break;
                    }
                    if (this.ch >= 48 && this.ch <= 55) {
                        this.AddCh();
                        state = 3;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 10: {
                    this.t.kind = 2;
                    break block69;
                }
                case 11: {
                    if (this.ch == 34) {
                        this.AddCh();
                        state = 27;
                        break;
                    }
                    if (this.ch <= 33 || this.ch >= 35 && this.ch <= 91 || this.ch >= 93 && this.ch <= 65535) {
                        this.AddCh();
                        state = 14;
                        break;
                    }
                    if (this.ch == 92) {
                        this.AddCh();
                        state = 15;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 12: {
                    if (this.ch == 10) {
                        this.AddCh();
                        state = 13;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 13: {
                    if (this.ch == 34) {
                        this.AddCh();
                        state = 28;
                        break;
                    }
                    if (this.ch <= 33 || this.ch >= 35 && this.ch <= 91 || this.ch >= 93 && this.ch <= 65535) {
                        this.AddCh();
                        state = 13;
                        break;
                    }
                    if (this.ch == 92) {
                        this.AddCh();
                        state = 29;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 14: {
                    if (this.ch == 34) {
                        this.AddCh();
                        state = 21;
                        break;
                    }
                    if (this.ch <= 33 || this.ch >= 35 && this.ch <= 91 || this.ch >= 93 && this.ch <= 65535) {
                        this.AddCh();
                        state = 14;
                        break;
                    }
                    if (this.ch == 92) {
                        this.AddCh();
                        state = 15;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 15: {
                    if (this.ch == 34 || this.ch == 39 || this.ch == 92 || this.ch == 98 || this.ch == 102 || this.ch == 110 || this.ch >= 114 && this.ch <= 116) {
                        this.AddCh();
                        state = 14;
                        break;
                    }
                    if (this.ch >= 52 && this.ch <= 55) {
                        this.AddCh();
                        state = 20;
                        break;
                    }
                    if (this.ch >= 48 && this.ch <= 51) {
                        this.AddCh();
                        state = 30;
                        break;
                    }
                    if (this.ch == 117) {
                        this.AddCh();
                        state = 16;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 16: {
                    if (this.ch >= 48 && this.ch <= 57 || this.ch >= 65 && this.ch <= 70 || this.ch >= 97 && this.ch <= 102) {
                        this.AddCh();
                        state = 17;
                        break;
                    }
                    if (this.ch == 117) {
                        this.AddCh();
                        state = 16;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 17: {
                    if (this.ch >= 48 && this.ch <= 57 || this.ch >= 65 && this.ch <= 70 || this.ch >= 97 && this.ch <= 102) {
                        this.AddCh();
                        state = 18;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 18: {
                    if (this.ch >= 48 && this.ch <= 57 || this.ch >= 65 && this.ch <= 70 || this.ch >= 97 && this.ch <= 102) {
                        this.AddCh();
                        state = 19;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 19: {
                    if (this.ch >= 48 && this.ch <= 57 || this.ch >= 65 && this.ch <= 70 || this.ch >= 97 && this.ch <= 102) {
                        this.AddCh();
                        state = 14;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 20: {
                    if (this.ch == 34) {
                        this.AddCh();
                        state = 21;
                        break;
                    }
                    if (this.ch <= 33 || this.ch >= 35 && this.ch <= 91 || this.ch >= 93 && this.ch <= 65535) {
                        this.AddCh();
                        state = 14;
                        break;
                    }
                    if (this.ch == 92) {
                        this.AddCh();
                        state = 15;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 21: {
                    this.t.kind = 3;
                    break block69;
                }
                case 22: {
                    if (this.ch == 110) {
                        this.AddCh();
                        state = 23;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 23: {
                    if (this.ch == 101) {
                        this.AddCh();
                        state = 24;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 24: {
                    if (this.ch == 119) {
                        this.AddCh();
                        state = 25;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 25: {
                    this.t.kind = 6;
                    break block69;
                }
                case 26: {
                    if (this.ch == 39) {
                        this.AddCh();
                        state = 10;
                        break;
                    }
                    if (this.ch >= 48 && this.ch <= 55) {
                        this.AddCh();
                        state = 31;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 27: {
                    recEnd = this.pos;
                    recKind = 3;
                    if (this.ch == 34) {
                        this.AddCh();
                        state = 12;
                        break;
                    }
                    this.t.kind = 3;
                    break block69;
                }
                case 28: {
                    if (this.ch == 34) {
                        this.AddCh();
                        state = 32;
                        break;
                    }
                    if (this.ch <= 33 || this.ch >= 35 && this.ch <= 91 || this.ch >= 93 && this.ch <= 65535) {
                        this.AddCh();
                        state = 13;
                        break;
                    }
                    if (this.ch == 92) {
                        this.AddCh();
                        state = 29;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 29: {
                    if (this.ch == 34) {
                        this.AddCh();
                        state = 33;
                        break;
                    }
                    if (this.ch <= 33 || this.ch >= 35 && this.ch <= 91 || this.ch >= 93 && this.ch <= 65535) {
                        this.AddCh();
                        state = 13;
                        break;
                    }
                    if (this.ch == 92) {
                        this.AddCh();
                        state = 29;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 30: {
                    if (this.ch == 34) {
                        this.AddCh();
                        state = 21;
                        break;
                    }
                    if (this.ch <= 33 || this.ch >= 35 && this.ch <= 47 || this.ch >= 56 && this.ch <= 91 || this.ch >= 93 && this.ch <= 65535) {
                        this.AddCh();
                        state = 14;
                        break;
                    }
                    if (this.ch == 92) {
                        this.AddCh();
                        state = 15;
                        break;
                    }
                    if (this.ch >= 48 && this.ch <= 55) {
                        this.AddCh();
                        state = 34;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 31: {
                    if (this.ch == 39) {
                        this.AddCh();
                        state = 10;
                        break;
                    }
                    if (this.ch >= 48 && this.ch <= 55) {
                        this.AddCh();
                        state = 3;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 32: {
                    if (this.ch == 34) {
                        this.AddCh();
                        state = 21;
                        break;
                    }
                    if (this.ch <= 33 || this.ch >= 35 && this.ch <= 91 || this.ch >= 93 && this.ch <= 65535) {
                        this.AddCh();
                        state = 13;
                        break;
                    }
                    if (this.ch == 92) {
                        this.AddCh();
                        state = 29;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 33: {
                    if (this.ch == 34) {
                        this.AddCh();
                        state = 35;
                        break;
                    }
                    if (this.ch <= 33 || this.ch >= 35 && this.ch <= 91 || this.ch >= 93 && this.ch <= 65535) {
                        this.AddCh();
                        state = 13;
                        break;
                    }
                    if (this.ch == 92) {
                        this.AddCh();
                        state = 29;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 34: {
                    if (this.ch == 34) {
                        this.AddCh();
                        state = 21;
                        break;
                    }
                    if (this.ch <= 33 || this.ch >= 35 && this.ch <= 91 || this.ch >= 93 && this.ch <= 65535) {
                        this.AddCh();
                        state = 14;
                        break;
                    }
                    if (this.ch == 92) {
                        this.AddCh();
                        state = 15;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 35: {
                    if (this.ch == 34) {
                        this.AddCh();
                        state = 36;
                        break;
                    }
                    if (this.ch <= 33 || this.ch >= 35 && this.ch <= 91 || this.ch >= 93 && this.ch <= 65535) {
                        this.AddCh();
                        state = 13;
                        break;
                    }
                    if (this.ch == 92) {
                        this.AddCh();
                        state = 29;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 36: {
                    recEnd = this.pos;
                    recKind = 3;
                    if (this.ch == 34) {
                        this.AddCh();
                        state = 21;
                        break;
                    }
                    if (this.ch <= 33 || this.ch >= 35 && this.ch <= 91 || this.ch >= 93 && this.ch <= 65535) {
                        this.AddCh();
                        state = 13;
                        break;
                    }
                    if (this.ch == 92) {
                        this.AddCh();
                        state = 29;
                        break;
                    }
                    this.t.kind = 3;
                    break block69;
                }
                case 37: {
                    this.t.kind = 8;
                    break block69;
                }
                case 38: {
                    this.t.kind = 9;
                    break block69;
                }
                case 39: {
                    if (this.ch == 110) {
                        this.AddCh();
                        state = 40;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 40: {
                    if (this.ch == 116) {
                        this.AddCh();
                        state = 41;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 41: {
                    if (this.ch == 101) {
                        this.AddCh();
                        state = 42;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 42: {
                    if (this.ch == 114) {
                        this.AddCh();
                        state = 43;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 43: {
                    if (this.ch == 102) {
                        this.AddCh();
                        state = 44;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 44: {
                    if (this.ch == 97) {
                        this.AddCh();
                        state = 45;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 45: {
                    if (this.ch == 99) {
                        this.AddCh();
                        state = 46;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 46: {
                    if (this.ch == 101) {
                        this.AddCh();
                        state = 47;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 47: {
                    this.t.kind = 10;
                    break block69;
                }
                case 48: {
                    this.t.kind = 13;
                    break block69;
                }
                case 49: {
                    this.t.kind = 15;
                    break block69;
                }
                case 50: {
                    this.t.kind = 16;
                    break block69;
                }
                case 51: {
                    this.t.kind = 17;
                    break block69;
                }
                case 52: {
                    if (this.ch == 43) {
                        this.AddCh();
                        state = 53;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 53: {
                    this.t.kind = 32;
                    break block69;
                }
                case 54: {
                    this.t.kind = 33;
                    break block69;
                }
                case 55: {
                    this.t.kind = 34;
                    break block69;
                }
                case 56: {
                    this.t.kind = 35;
                    break block69;
                }
                case 57: {
                    this.t.kind = 42;
                    break block69;
                }
                case 58: {
                    this.t.kind = 43;
                    break block69;
                }
                case 59: {
                    this.t.kind = 44;
                    break block69;
                }
                case 60: {
                    this.t.kind = 45;
                    break block69;
                }
                case 61: {
                    this.t.kind = 46;
                    break block69;
                }
                case 62: {
                    recEnd = this.pos;
                    recKind = 30;
                    if (this.ch == 58) {
                        this.AddCh();
                        state = 22;
                        break;
                    }
                    this.t.kind = 30;
                    break block69;
                }
                case 63: {
                    recEnd = this.pos;
                    recKind = 11;
                    if (this.ch == 105) {
                        this.AddCh();
                        state = 39;
                        break;
                    }
                    this.t.kind = 11;
                    break block69;
                }
                case 64: {
                    if (this.ch == 45) {
                        this.AddCh();
                        state = 54;
                        break;
                    }
                    if (this.ch == 62) {
                        this.AddCh();
                        state = 61;
                        break;
                    }
                    state = 0;
                }
            }
        }
        this.t.val = new String(this.tval, 0, this.tlen);
        return this.t;
    }

    private void SetScannerBehindT() {
        this.buffer.setPos(this.t.pos);
        this.NextCh();
        this.line = this.t.line;
        this.col = this.t.col;
        this.charPos = this.t.charPos;
        for (int i = 0; i < this.tlen; ++i) {
            this.NextCh();
        }
    }

    public Token Scan() {
        if (this.tokens.next == null) {
            return this.NextToken();
        }
        this.pt = this.tokens = this.tokens.next;
        return this.tokens;
    }

    public Token Peek() {
        do {
            if (this.pt.next == null) {
                this.pt.next = this.NextToken();
            }
            this.pt = this.pt.next;
        } while (this.pt.kind > 48);
        return this.pt;
    }

    public void ResetPeek() {
        this.pt = this.tokens;
    }

    static {
        int i;
        start = new StartStates();
        literals = new HashMap();
        for (i = 65; i <= 90; ++i) {
            start.set(i, 1);
        }
        for (i = 95; i <= 95; ++i) {
            start.set(i, 1);
        }
        for (i = 97; i <= 122; ++i) {
            start.set(i, 1);
        }
        for (i = 39; i <= 39; ++i) {
            start.set(i, 2);
        }
        for (i = 34; i <= 34; ++i) {
            start.set(i, 11);
        }
        start.set(58, 62);
        start.set(46, 37);
        start.set(59, 38);
        start.set(64, 63);
        start.set(123, 48);
        start.set(44, 49);
        start.set(125, 50);
        start.set(61, 51);
        start.set(43, 52);
        start.set(45, 64);
        start.set(40, 55);
        start.set(41, 56);
        start.set(91, 57);
        start.set(93, 58);
        start.set(60, 59);
        start.set(62, 60);
        start.set(65536, -1);
        literals.put("class", 4);
        literals.put("this", 5);
        literals.put("package", 7);
        literals.put("interface", 12);
        literals.put("enum", 14);
        literals.put("static", 18);
        literals.put("while", 19);
        literals.put("do", 20);
        literals.put("for", 21);
        literals.put("try", 22);
        literals.put("catch", 23);
        literals.put("finally", 24);
        literals.put("break", 25);
        literals.put("continue", 26);
        literals.put("return", 27);
        literals.put("yield", 28);
        literals.put("throw", 29);
        literals.put("super", 31);
        literals.put("synchronized", 36);
        literals.put("if", 37);
        literals.put("else", 38);
        literals.put("switch", 39);
        literals.put("case", 40);
        literals.put("default", 41);
        literals.put("new", 47);
    }
}

