/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.instrument;

import org.matwoess.jsourceprofiler.tool.instrument.Buffer;

class UTF8Buffer
extends Buffer {
    UTF8Buffer(Buffer b) {
        super(b);
    }

    @Override
    public int Read() {
        int ch;
        while ((ch = super.Read()) >= 128 && (ch & 0xC0) != 192 && ch != 65536) {
        }
        if (ch >= 128 && ch != 65536) {
            if ((ch & 0xF0) == 240) {
                int c1 = ch & 7;
                ch = super.Read();
                int c2 = ch & 0x3F;
                ch = super.Read();
                int c3 = ch & 0x3F;
                ch = super.Read();
                int c4 = ch & 0x3F;
                ch = ((c1 << 6 | c2) << 6 | c3) << 6 | c4;
            } else if ((ch & 0xE0) == 224) {
                int c1 = ch & 0xF;
                ch = super.Read();
                int c2 = ch & 0x3F;
                ch = super.Read();
                int c3 = ch & 0x3F;
                ch = (c1 << 6 | c2) << 6 | c3;
            } else if ((ch & 0xC0) == 192) {
                int c1 = ch & 0x1F;
                ch = super.Read();
                int c2 = ch & 0x3F;
                ch = c1 << 6 | c2;
            }
        }
        return ch;
    }
}

