/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.instrument;

import org.matwoess.jsourceprofiler.tool.instrument.Parser;
import org.matwoess.jsourceprofiler.tool.instrument.Token;
import org.matwoess.jsourceprofiler.tool.model.BlockType;
import org.matwoess.jsourceprofiler.tool.model.CodePosition;

public class Util {
    static int startOfToken(Token token) {
        return token.charPos;
    }

    static int endOfToken(Token token) {
        return token.charPos + token.val.length();
    }

    static CodePosition tokenStartPosition(Token token) {
        return new CodePosition(token.line, Util.startOfToken(token));
    }

    static CodePosition tokenEndPosition(Token token) {
        return new CodePosition(token.line, Util.endOfToken(token));
    }

    public static CodePosition getBlockBegPos(Parser parser, BlockType blockType, boolean isSingleStatement) {
        if (blockType == BlockType.COLON_CASE || isSingleStatement) {
            return Util.tokenEndPosition(parser.t);
        }
        return Util.tokenStartPosition(parser.la);
    }

    public static int getIncInsertOffset(Parser parser, BlockType blockType, boolean isSingleStatement) {
        if (!isSingleStatement && blockType != BlockType.COLON_CASE) {
            return Util.endOfToken(parser.la) - Util.getBlockBegPos(parser, blockType, false).pos();
        }
        return 0;
    }

    static Token getRegionStartToken(Parser parser, BlockType blockType, boolean isSingleStatement) {
        parser.scanner.ResetPeek();
        if (blockType == BlockType.COLON_CASE || isSingleStatement) {
            return parser.la;
        }
        return parser.scanner.Peek();
    }
}

