/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.matwoess.jsourceprofiler.tool.model.BlockType;
import org.matwoess.jsourceprofiler.tool.model.CodePosition;
import org.matwoess.jsourceprofiler.tool.model.CodeRegion;
import org.matwoess.jsourceprofiler.tool.model.Component;
import org.matwoess.jsourceprofiler.tool.model.ControlBreak;
import org.matwoess.jsourceprofiler.tool.model.JClass;
import org.matwoess.jsourceprofiler.tool.model.Method;

public class Block
implements Serializable,
Component {
    public int id;
    public JClass clazz;
    public Method method;
    public Block parentBlock;
    public CodePosition beg;
    public CodePosition end;
    public BlockType blockType;
    public boolean isSingleStatement;
    public final List<Block> innerBlocks = new ArrayList<Block>();
    public ControlBreak controlBreak = null;
    public final List<String> labels = new ArrayList<String>();
    public final List<CodeRegion> codeRegions = new ArrayList<CodeRegion>();
    public int incInsertOffset;
    public transient long hits;
    public final transient List<Block> innerControlBreaks = new ArrayList<Block>();

    public Block(BlockType type) {
        this.blockType = type;
    }

    public void setParentMethod(Method method) {
        assert (this.method == null);
        if (method != null) {
            this.method = method;
            if (this.blockType.isMethod()) {
                method.setMethodBlock(this);
            }
        }
    }

    public void setParentClass(JClass clazz) {
        assert (this.clazz == null);
        this.clazz = clazz;
        if (this.method == null && this.parentBlock == null) {
            clazz.classBlocks.add(this);
        }
    }

    public void setParentBlock(Block block) {
        if (block == null) {
            return;
        }
        this.parentBlock = block;
        this.parentBlock.innerBlocks.add(this);
    }

    public void registerInnerControlBreak(Block controlBreakBlock) {
        this.innerControlBreaks.add(controlBreakBlock);
    }

    public void addCodeRegion(CodeRegion region) {
        region.id = this.codeRegions.size();
        this.codeRegions.add(region);
    }

    public List<Block> getInnerBlocksRecursive() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Block b : this.innerBlocks) {
            blocks.add(b);
            blocks.addAll(b.getInnerBlocksRecursive());
        }
        return blocks;
    }

    public boolean hasNoBraces() {
        return this.isSingleStatement || this.blockType.hasNoBraces();
    }

    public boolean isSwitchStatementCase() {
        return this.blockType.isSwitchCase() && this.parentBlock != null && this.parentBlock.blockType == BlockType.SWITCH_STMT;
    }

    public boolean isSwitchExpressionCase() {
        return this.blockType.isSwitchCase() && this.parentBlock != null && this.parentBlock.blockType == BlockType.SWITCH_EXPR;
    }

    public int getIncInsertPos() {
        return this.beg.pos() + this.incInsertOffset;
    }

    public String toString() {
        return String.format("%s%s%s: {%d[%s%s]-%s[%s]} (%s%s)%s%s%s", this.labels.isEmpty() ? "" : String.join((CharSequence)": ", this.labels) + ": ", this.clazz.name, this.method != null ? "." + this.method.name : "", this.beg.line(), this.beg.pos(), this.incInsertOffset != 0 ? "(+" + this.incInsertOffset + ")" : "", this.end != null ? Integer.valueOf(this.end.line()) : "?", this.end != null ? Integer.valueOf(this.end.pos()) : "?", this.blockType.toString(), this.isSingleStatement ? ", SS" : "", this.method == null ? " [class-level]" : "", this.controlBreak != null ? " [" + String.valueOf(this.controlBreak) + "]" : "", this.parentBlock == null ? "" : " (in " + String.valueOf(this.parentBlock) + ")");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        if (!Objects.equals(this.beg, block.beg)) {
            return false;
        }
        if (!Objects.equals(this.end, block.end)) {
            return false;
        }
        if (this.incInsertOffset != block.incInsertOffset) {
            return false;
        }
        if (!this.clazz.equals(block.clazz)) {
            return false;
        }
        if (!Objects.equals(this.method, block.method)) {
            return false;
        }
        if (!Objects.equals(this.controlBreak, block.controlBreak)) {
            return false;
        }
        if (!Objects.equals(this.parentBlock, block.parentBlock)) {
            return false;
        }
        return this.blockType == block.blockType;
    }

    public int hashCode() {
        int result = this.clazz.hashCode();
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 31 * result + this.beg.hashCode();
        result = 31 * result + this.end.hashCode();
        result = 31 * result + this.blockType.hashCode();
        result = 31 * result + this.incInsertOffset;
        result = 31 * result + (this.controlBreak != null ? this.controlBreak.hashCode() : 0);
        result = 31 * result + (this.parentBlock != null ? this.parentBlock.hashCode() : 0);
        return result;
    }
}

