/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.model;

public enum BlockType {
    BLOCK,
    METHOD,
    CONSTRUCTOR,
    STATIC,
    LOOP,
    TRY,
    LAMBDA,
    SWITCH_STMT,
    SWITCH_EXPR,
    COLON_CASE,
    ARROW_CASE;


    public String toString() {
        String prefix = switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "";
            case 1 -> "method ";
            case 2 -> "constructor ";
            case 3 -> "static ";
            case 4 -> "loop ";
            case 5 -> "try ";
            case 6 -> "lambda ";
            case 7 -> "switch statement ";
            case 8 -> "switch expression ";
            case 9 -> "colon case ";
            case 10 -> "arrow case ";
        };
        return prefix + "block";
    }

    public boolean isSwitchBody() {
        return this == SWITCH_STMT || this == SWITCH_EXPR;
    }

    public boolean isSwitchCase() {
        return this == COLON_CASE || this == ARROW_CASE;
    }

    public boolean isMethod() {
        return this == METHOD || this == CONSTRUCTOR;
    }

    public boolean hasCounter() {
        return !this.isSwitchBody();
    }

    public boolean hasNoBraces() {
        return this == COLON_CASE;
    }
}

