/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.model;

import java.io.Serializable;
import org.matwoess.jsourceprofiler.tool.model.Block;
import org.matwoess.jsourceprofiler.tool.model.BlockType;

public record ControlBreak(Kind kind, String label) implements Serializable
{
    public boolean stopPropagationAt(Block block) {
        if (this.label != null) {
            return block.labels.contains(this.label);
        }
        return switch (this.kind.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                if (block.blockType == BlockType.LOOP || block.isSwitchStatementCase()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (block.blockType == BlockType.LOOP) {
                    yield true;
                }
                yield false;
            }
            case 3 -> block.isSwitchExpressionCase();
            case 2 -> {
                if (block.blockType == BlockType.METHOD || block.blockType == BlockType.LAMBDA) {
                    yield true;
                }
                yield false;
            }
            case 4 -> block.blockType == BlockType.METHOD || block.blockType == BlockType.TRY;
        };
    }

    public static ControlBreak fromToken(String tokenValue) {
        Kind type = switch (tokenValue) {
            case "break" -> Kind.BREAK;
            case "continue" -> Kind.CONTINUE;
            case "return" -> Kind.RETURN;
            case "yield" -> Kind.YIELD;
            case "throw" -> Kind.THROW;
            default -> throw new RuntimeException("unknown control flow break '" + tokenValue + "'");
        };
        return new ControlBreak(type, null);
    }

    public static ControlBreak fromTokenWithLabel(String tokenValue, String label) {
        assert (tokenValue.equals("break") || tokenValue.equals("continue"));
        Kind type = switch (tokenValue) {
            case "break" -> Kind.BREAK;
            case "continue" -> Kind.CONTINUE;
            default -> throw new RuntimeException("unknown control break '" + tokenValue + "'");
        };
        return new ControlBreak(type, label);
    }

    @Override
    public String toString() {
        return this.kind.name() + (String)(this.label == null ? "" : " " + this.label);
    }

    public static enum Kind {
        BREAK,
        CONTINUE,
        RETURN,
        YIELD,
        THROW;

    }
}

