/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.matwoess.jsourceprofiler.tool.model.Block;
import org.matwoess.jsourceprofiler.tool.model.ClassType;
import org.matwoess.jsourceprofiler.tool.model.Component;
import org.matwoess.jsourceprofiler.tool.model.Method;

public class JClass
implements Serializable,
Component {
    public String name;
    public ClassType classType;
    public String packageName;
    public JClass parentClass;
    public final List<JClass> innerClasses = new ArrayList<JClass>();
    public final List<Method> methods = new ArrayList<Method>();
    public final List<Block> classBlocks = new ArrayList<Block>();

    public JClass(String name, ClassType type) {
        this.name = name;
        this.classType = type;
    }

    public void setParentClass(JClass parentClass) {
        if (parentClass == null) {
            return;
        }
        if (this.name == null) {
            long nextAnonymousClass = parentClass.innerClasses.stream().filter(c -> c.classType == ClassType.ANONYMOUS).count() + 1L;
            this.name = String.valueOf(nextAnonymousClass);
        }
        this.parentClass = parentClass;
        parentClass.innerClasses.add(this);
    }

    public String getName() {
        if (this.parentClass != null) {
            return this.parentClass.getName() + "$" + this.name;
        }
        return this.name;
    }

    public String getFullName() {
        if (this.packageName == null) {
            return this.getName();
        }
        return this.packageName + "." + this.getName();
    }

    public String toString() {
        return this.getName();
    }

    public List<JClass> getClassesRecursive() {
        ArrayList<JClass> allClasses = new ArrayList<JClass>(this.innerClasses);
        for (JClass clazz : this.innerClasses) {
            allClasses.addAll(clazz.getClassesRecursive());
        }
        return allClasses;
    }

    public List<Method> getMethodsRecursive() {
        ArrayList<Method> allMethods = new ArrayList<Method>(this.methods);
        for (JClass clazz : this.innerClasses) {
            allMethods.addAll(clazz.getMethodsRecursive());
        }
        return allMethods;
    }

    public long getAggregatedMethodBlockCounts() {
        return this.getMethodsRecursive().stream().filter(m -> !m.isAbstract()).map(Method::getMethodBlock).mapToLong(b -> b.hits).sum();
    }

    public List<Block> getBlocksRecursive() {
        ArrayList<Block> allBlocks = new ArrayList<Block>();
        allBlocks.addAll(this.classBlocks);
        allBlocks.addAll(this.classBlocks.stream().flatMap(block -> block.getInnerBlocksRecursive().stream()).toList());
        allBlocks.addAll(this.methods.stream().flatMap(method -> method.getBlocksRecursive().stream()).toList());
        for (JClass clazz : this.innerClasses) {
            allBlocks.addAll(clazz.getBlocksRecursive());
        }
        return allBlocks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JClass aClass = (JClass)o;
        if (!Objects.equals(this.name, aClass.name)) {
            return false;
        }
        if (this.classType != aClass.classType) {
            return false;
        }
        if (!Objects.equals(this.packageName, aClass.packageName)) {
            return false;
        }
        return Objects.equals(this.parentClass, aClass.parentClass);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.classType.hashCode();
        result = 31 * result + (this.packageName != null ? this.packageName.hashCode() : 0);
        result = 31 * result + (this.parentClass != null ? this.parentClass.hashCode() : 0);
        return result;
    }
}

