/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.matwoess.jsourceprofiler.tool.model.Block;
import org.matwoess.jsourceprofiler.tool.model.JClass;

public class JavaFile
implements Serializable {
    public int beginOfImports = 0;
    public String packageName;
    public List<JClass> topLevelClasses;
    public List<Block> foundBlocks;
    public transient Path sourceFile;
    public transient Path relativePath;

    public JavaFile(Path sourceFile, Path sourcesDir) {
        this.sourceFile = sourceFile;
        Path fileAbsolute = sourceFile.toAbsolutePath().normalize();
        Path dirAbsolute = sourcesDir.toAbsolutePath().normalize();
        this.relativePath = dirAbsolute.relativize(fileAbsolute);
    }

    public JavaFile(Path sourceFile) {
        this.sourceFile = sourceFile;
        this.relativePath = sourceFile.getFileName();
    }

    public List<JClass> getClassesRecursive() {
        ArrayList<JClass> allClasses = new ArrayList<JClass>(this.topLevelClasses);
        for (JClass clazz : this.topLevelClasses) {
            allClasses.addAll(clazz.getClassesRecursive());
        }
        return allClasses;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeUTF(this.sourceFile.toString());
        oos.writeUTF(this.relativePath.toString());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.sourceFile = Paths.get(ois.readUTF(), new String[0]);
        this.relativePath = Paths.get(ois.readUTF(), new String[0]);
    }
}

