/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.model;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import org.matwoess.jsourceprofiler.tool.model.JavaFile;

public record Metadata(int blocksCount, JavaFile[] javaFiles) {
    public void exportMetadata(Path metadataPath) {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(metadataPath.toFile()));){
            oos.writeInt(this.blocksCount);
            oos.writeObject(this.javaFiles);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Metadata importMetadata(Path metadataPath) {
        Metadata metadata;
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(metadataPath.toFile()));){
            int blocksCount = ois.readInt();
            JavaFile[] javaFiles = (JavaFile[])ois.readObject();
            metadata = new Metadata(blocksCount, javaFiles);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return metadata;
    }
}

