/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.matwoess.jsourceprofiler.tool.model.Block;
import org.matwoess.jsourceprofiler.tool.model.Component;
import org.matwoess.jsourceprofiler.tool.model.JClass;

public class Method
implements Serializable,
Component {
    public final String name;
    public JClass parentClass;
    public Block methodBlock = null;

    public Method(String name) {
        this.name = name;
    }

    public void setParentClass(JClass parentClass) {
        assert (this.parentClass == null);
        this.parentClass = parentClass;
        parentClass.methods.add(this);
    }

    public void setMethodBlock(Block block) {
        assert (this.methodBlock == null && block.blockType.isMethod());
        this.methodBlock = block;
    }

    public Block getMethodBlock() {
        return this.methodBlock;
    }

    public List<Block> getBlocksRecursive() {
        if (this.isAbstract()) {
            return List.of();
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        blocks.add(this.methodBlock);
        blocks.addAll(this.methodBlock.getInnerBlocksRecursive());
        return blocks;
    }

    public boolean isAbstract() {
        return this.methodBlock == null;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Method method = (Method)o;
        if (!this.name.equals(method.name)) {
            return false;
        }
        return this.parentClass.equals(method.parentClass);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.parentClass.hashCode();
        return result;
    }
}

