/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.profile;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.matwoess.jsourceprofiler.common.IO;

public abstract class AbstractHtmlWriter {
    final StringBuilder content = new StringBuilder();
    public String title;
    public String[] includeScripts;
    public String[] bodyScripts;
    public String[] cssFiles;

    public void header() {
        this.content.append("<!DOCTYPE html>\n").append("<html>\n").append("<head>\n");
        this.content.append("<meta charset=\"UTF-8\">\n");
        if (this.title != null) {
            this.content.append("<title>").append(this.title).append("</title>\n");
        }
        for (String scriptSrc : this.includeScripts) {
            this.content.append(String.format("<script src=\"%s\"></script>\n", scriptSrc));
        }
        for (String cssFile : this.cssFiles) {
            if (cssFile.startsWith("http")) {
                this.content.append("<link rel=\"stylesheet\" href=\"").append(cssFile).append("\">\n");
                continue;
            }
            Path cssResource = IO.getReportResourcePath((String)cssFile);
            Path relativeCssPath = this.getFileOutputPath().getParent().relativize(cssResource);
            this.content.append("<style>@import url(").append(IO.normalize((Path)relativeCssPath)).append(");</style>\n");
        }
        this.content.append("</head>\n");
    }

    public void bodyStart() {
        this.content.append("<body>\n");
    }

    private void breadcrumbBar() {
        if (this.getFileOutputPath().equals(IO.getReportIndexPath())) {
            return;
        }
        this.content.append("<div class=\"breadcrumbs\">");
        String backlinkButton = String.format("<input type=\"button\" onclick=\"location.href='%s';\" value=\"%s\"/>", IO.normalize((Path)this.getFileOutputPath().getParent().relativize(IO.getReportIndexPath())), "Back to Class Overview");
        this.content.append(backlinkButton);
        this.content.append("</div>");
    }

    public void heading(String heading) {
        this.content.append("<h2>").append(heading).append("</h2>\n");
    }

    public abstract void body();

    public void bodyEnd() {
        if (this.bodyScripts != null) {
            for (String bodyScript : this.bodyScripts) {
                Path scriptResource = IO.getReportResourcePath((String)bodyScript);
                Path relativeScriptResource = this.getFileOutputPath().getParent().relativize(scriptResource);
                this.content.append(String.format("<script type=\"text/javascript\" src=\"%s\"></script>\n", IO.normalize((Path)relativeScriptResource)));
            }
        }
        this.content.append("</body>\n");
        this.content.append("</html>\n");
    }

    private void footer() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.content.append("<footer>\n").append("<p>Generated on ").append(dateFormat.format(new Date())).append("</p>\n").append("</footer>\n");
    }

    public void generate() {
        this.header();
        this.bodyStart();
        this.breadcrumbBar();
        this.heading(this.title);
        this.body();
        this.bodyEnd();
        this.footer();
    }

    public void write() {
        this.generate();
        Path destPath = this.getFileOutputPath();
        IO.createDirectoriesIfNotExists((Path)destPath);
        try {
            Files.writeString(destPath, (CharSequence)this.content.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract Path getFileOutputPath();
}

