/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.profile;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.PrimitiveIterator;
import org.matwoess.jsourceprofiler.common.IO;
import org.matwoess.jsourceprofiler.common.JCompilerCommandBuilder;
import org.matwoess.jsourceprofiler.common.JavaCommandBuilder;
import org.matwoess.jsourceprofiler.common.Util;
import org.matwoess.jsourceprofiler.tool.model.Block;
import org.matwoess.jsourceprofiler.tool.model.JClass;
import org.matwoess.jsourceprofiler.tool.model.JavaFile;
import org.matwoess.jsourceprofiler.tool.model.Metadata;
import org.matwoess.jsourceprofiler.tool.profile.ReportClassIndexWriter;
import org.matwoess.jsourceprofiler.tool.profile.ReportMethodIndexWriter;
import org.matwoess.jsourceprofiler.tool.profile.ReportSourceWriter;

public class Profiler {
    private final JavaFile mainJavaFile;
    private final JavaFile[] additionalJavaFiles;

    public Profiler(JavaFile mainJavaFile, JavaFile ... additionalJavaFiles) {
        this.mainJavaFile = mainJavaFile;
        this.additionalJavaFiles = additionalJavaFiles;
    }

    public void compileInstrumented() {
        IO.clearDirectoryContents((Path)IO.getClassesDir());
        Profiler.copyAuxiliaryFiles();
        Path mainFile = IO.getInstrumentedFilePath((Path)this.mainJavaFile.relativePath);
        int exitCode = Util.runCommand((String[])new JCompilerCommandBuilder().setClassPath(IO.getInstrumentDir()).setDirectory(IO.getClassesDir()).addSourceFile(mainFile).build());
        if (exitCode != 0) {
            throw new RuntimeException("Error compiling instrumented file: " + String.valueOf(mainFile));
        }
    }

    private static void copyAuxiliaryFiles() {
        IO.copyResource(Profiler.class, (String)"auxiliary/__Counter.class", (Path)IO.getAuxiliaryCounterClassPath());
    }

    public void profile(String[] programArgs) {
        Path mainFile = IO.getInstrumentDir().relativize(IO.getInstrumentedFilePath((Path)this.mainJavaFile.relativePath));
        String filePath = mainFile.toString();
        String classFilePath = filePath.substring(0, filePath.lastIndexOf("."));
        if (File.separatorChar == '\\') {
            classFilePath = classFilePath.replace("\\", "/");
        }
        System.out.println("Program output:");
        int exitCode = Util.runCommand((String[])new JavaCommandBuilder().setClassPath(IO.getClassesDir()).setMainClass(classFilePath).addArgs(programArgs).build());
        if (exitCode != 0) {
            throw new RuntimeException("Error executing compiled class: " + classFilePath);
        }
    }

    public void generateReport() {
        JavaFile[] allJavaFiles = this.mainJavaFile != null ? (JavaFile[])Util.prependToArray((Object[])this.additionalJavaFiles, (Object[])new JavaFile[]{this.mainJavaFile}) : Metadata.importMetadata(IO.getMetadataPath()).javaFiles();
        Profiler.addHitCountToJavaFileBlocks(allJavaFiles);
        IO.clearDirectoryContents((Path)IO.getReportDir());
        new ReportClassIndexWriter(allJavaFiles).write();
        for (JavaFile jFile : allJavaFiles) {
            if (jFile.foundBlocks.isEmpty()) continue;
            new ReportSourceWriter(jFile).write();
            for (JClass clazz : jFile.topLevelClasses) {
                new ReportMethodIndexWriter(clazz, jFile).write();
            }
        }
        Profiler.copyReportResources();
    }

    private static void addHitCountToJavaFileBlocks(JavaFile[] allJavaFiles) {
        long[] counts;
        try (DataInputStream dis = new DataInputStream(new FileInputStream(IO.getCountsPath().toString()));){
            int nCounts = dis.readInt();
            counts = new long[nCounts];
            for (int i = 0; i < nCounts; ++i) {
                counts[i] = dis.readLong();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PrimitiveIterator.OfLong allBlockCounts = Arrays.stream(counts).iterator();
        for (JavaFile jFile : allJavaFiles) {
            for (Block block : jFile.foundBlocks) {
                if (!block.blockType.hasCounter()) continue;
                if (!allBlockCounts.hasNext()) {
                    throw new RuntimeException("Ran out of block counts. Mismatching entry counts");
                }
                block.hits = allBlockCounts.next();
            }
        }
        if (allBlockCounts.hasNext()) {
            throw new RuntimeException("Too many block counts. Mismatching entry counts!");
        }
    }

    private static void copyReportResources() {
        String[] reportResourceFolders;
        for (String resourceFolder : reportResourceFolders = new String[]{"js", "css"}) {
            IO.copyResourceFolder(Profiler.class, (String)resourceFolder, (Path)IO.getReportResourcePath((String)resourceFolder));
        }
    }

    public void createLinkForReport() {
        IO.createLink((Path)IO.getReportIndexSymLinkPath(), (Path)IO.getReportIndexPath());
    }
}

