/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.profile;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.matwoess.jsourceprofiler.common.IO;
import org.matwoess.jsourceprofiler.tool.model.JClass;
import org.matwoess.jsourceprofiler.tool.model.JavaFile;
import org.matwoess.jsourceprofiler.tool.model.Method;
import org.matwoess.jsourceprofiler.tool.profile.AbstractHtmlWriter;
import org.matwoess.jsourceprofiler.tool.profile.ComponentCoverage;
import org.matwoess.jsourceprofiler.tool.profile.ReportUtil;

public class ReportClassIndexWriter
extends AbstractHtmlWriter {
    private final JavaFile[] allJavaFiles;

    public ReportClassIndexWriter(JavaFile[] allJavaFiles) {
        this.allJavaFiles = allJavaFiles;
        this.title = "Class Overview";
        this.cssFiles = new String[]{"css/index.css"};
        this.includeScripts = new String[]{"https://ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js"};
        this.bodyScripts = new String[]{"js/sorter.js"};
    }

    @Override
    public void body() {
        this.sortedClassTable();
    }

    public void sortedClassTable() {
        HashMap<JClass, JavaFile> fileByClass = new HashMap<JClass, JavaFile>();
        for (JavaFile jFile : this.allJavaFiles) {
            for (JClass clazz : jFile.topLevelClasses) {
                fileByClass.put(clazz, jFile);
            }
        }
        List<JClass> sortedClasses = Arrays.stream(this.allJavaFiles).flatMap(f -> f.topLevelClasses.stream()).filter(c -> c.getMethodsRecursive().stream().anyMatch(m -> !m.isAbstract())).sorted(Comparator.comparingLong(JClass::getAggregatedMethodBlockCounts).reversed()).toList();
        this.content.append("<table class=\"sortable\">\n").append("<tr>\n").append("<th>Class</th>\n").append("<th class=\"metric desc\">Total Method Calls</th>\n").append("<th class=\"metric\">Block Hit Max</th>\n").append("<th class=\"metric\">Method Coverage</th>\n").append("<th>Source File</th>\n").append("</tr>\n");
        for (JClass clazz : sortedClasses) {
            JavaFile javaFile = (JavaFile)fileByClass.get(clazz);
            Path methIdxHref = IO.getReportMethodIndexPath((String)clazz.name).getFileName();
            Path sourceFileHref = IO.getReportDir().relativize(IO.getReportSourceFilePath((Path)javaFile.relativePath));
            ComponentCoverage methodCoverage = this.getMethodCoverage(clazz);
            long aggregatedMethodHitCounts = clazz.getAggregatedMethodBlockCounts();
            long blockHitMax = this.getBlockHitMax(clazz);
            this.content.append("<tr>\n").append(String.format("<td><a href=\"%s\">%s</a></td>\n", IO.normalize((Path)methIdxHref), clazz.getName())).append(String.format("<td class=\"metric\" data-total=\"%s\">%s</td>\n", aggregatedMethodHitCounts, ReportUtil.formatHitCount(aggregatedMethodHitCounts))).append(String.format("<td class=\"metric\" data-total=\"%s\">%s</td>\n", blockHitMax, ReportUtil.formatHitCount(blockHitMax))).append(String.format("<td class=\"metric coverage\" data-percentage=\"%s\" data-total=\"%s\">%s</td>\n", Float.valueOf(methodCoverage.percentage()), methodCoverage.total(), methodCoverage)).append(String.format("<td><a href=\"%s\">%s</a></td>\n", IO.normalize((Path)sourceFileHref), javaFile.sourceFile.toFile().getName())).append("</tr>\n");
        }
        this.content.append("</table>\n");
    }

    private ComponentCoverage getMethodCoverage(JClass clazz) {
        List<Method> methods = clazz.getMethodsRecursive().stream().filter(m -> !m.isAbstract()).toList();
        int coveredMethods = (int)methods.stream().filter(m -> m.getMethodBlock().hits > 0L).count();
        return new ComponentCoverage(coveredMethods, methods.size());
    }

    private long getBlockHitMax(JClass clazz) {
        return clazz.getBlocksRecursive().stream().map(b -> b.hits).max(Long::compareTo).orElse(0L);
    }

    @Override
    public Path getFileOutputPath() {
        return IO.getReportIndexPath();
    }
}

