/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.profile;

import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import org.matwoess.jsourceprofiler.common.IO;
import org.matwoess.jsourceprofiler.tool.model.Block;
import org.matwoess.jsourceprofiler.tool.model.JClass;
import org.matwoess.jsourceprofiler.tool.model.JavaFile;
import org.matwoess.jsourceprofiler.tool.model.Method;
import org.matwoess.jsourceprofiler.tool.profile.AbstractHtmlWriter;
import org.matwoess.jsourceprofiler.tool.profile.ComponentCoverage;
import org.matwoess.jsourceprofiler.tool.profile.ReportUtil;

public class ReportMethodIndexWriter
extends AbstractHtmlWriter {
    private final JClass clazz;
    private final Path reportSourceFile;

    public ReportMethodIndexWriter(JClass clazz, JavaFile javaFile) {
        this.clazz = clazz;
        this.reportSourceFile = IO.getReportSourceFilePath((Path)javaFile.relativePath);
        this.title = "Methods in " + clazz.getFullName();
        this.cssFiles = new String[]{"css/index.css"};
        this.includeScripts = new String[]{"https://ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js"};
        this.bodyScripts = new String[]{"js/sorter.js"};
    }

    @Override
    public void body() {
        this.sortedMethodTable();
    }

    public void sortedMethodTable() {
        List<Method> sortedMethods = this.clazz.getMethodsRecursive().stream().filter(method -> !method.isAbstract()).sorted(Comparator.comparingLong(m -> m.getMethodBlock().hits).reversed()).toList();
        this.content.append("<table class=\"sortable\">\n").append("<tr>\n").append("<th>Method</th>\n").append("<th class=\"metric desc\">Invocations</th>\n").append("<th class=\"metric\">Block Hit Max</th>\n").append("<th class=\"metric\">Code Block Coverage</th>\n").append("</tr>\n");
        Path sourceFileHref = IO.getReportDir().relativize(this.reportSourceFile);
        for (Method meth : sortedMethods) {
            Block methBlock = meth.getMethodBlock();
            String lineNrRef = IO.normalize((Path)sourceFileHref) + "#" + methBlock.beg.line();
            String methName = methBlock.clazz != this.clazz ? methBlock.clazz.getName() + "::" + meth.name : meth.name;
            ComponentCoverage blockCoverage = this.getBlockCoverage(meth);
            long methodHitCount = methBlock.hits;
            long blockHitMax = this.getBlockHitMax(meth);
            this.content.append("<tr>\n").append(String.format("<td><a href=\"%s\">%s</a></td>\n", lineNrRef, methName)).append(String.format("<td class=\"metric\" data-total=\"%s\">%s</td>\n", methodHitCount, ReportUtil.formatHitCount(methodHitCount))).append(String.format("<td class=\"metric\" data-total=\"%s\">%s</td>\n", blockHitMax, ReportUtil.formatHitCount(blockHitMax))).append(String.format("<td class=\"metric coverage\" data-percentage=\"%s\" data-total=\"%s\">%s</td>\n", Float.valueOf(blockCoverage.percentage()), blockCoverage.total(), blockCoverage)).append("</tr>\n");
        }
        this.content.append("</table>\n");
    }

    private ComponentCoverage getBlockCoverage(Method method) {
        List<Block> blocks = method.getBlocksRecursive().stream().filter(b -> b.blockType.hasCounter()).toList();
        int coveredBlocks = (int)blocks.stream().filter(b -> b.hits > 0L).count();
        return new ComponentCoverage(coveredBlocks, blocks.size());
    }

    private long getBlockHitMax(Method method) {
        return method.getBlocksRecursive().stream().map(b -> b.hits).max(Long::compareTo).orElse(0L);
    }

    @Override
    public Path getFileOutputPath() {
        return IO.getReportMethodIndexPath((String)this.clazz.name);
    }
}

