/*
 * Decompiled with CFR 0.152.
 */
package org.matwoess.jsourceprofiler.tool.profile;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.matwoess.jsourceprofiler.common.IO;
import org.matwoess.jsourceprofiler.tool.model.Block;
import org.matwoess.jsourceprofiler.tool.model.CodeInsert;
import org.matwoess.jsourceprofiler.tool.model.CodeRegion;
import org.matwoess.jsourceprofiler.tool.model.JavaFile;
import org.matwoess.jsourceprofiler.tool.profile.AbstractHtmlWriter;
import org.matwoess.jsourceprofiler.tool.profile.ReportUtil;

public class ReportSourceWriter
extends AbstractHtmlWriter {
    private final JavaFile javaFile;
    private static final String spanPatternStr = "<span class=\"[^\"]*\" title=\"[^\"]*\">";
    private static final Pattern emptySpanPattern = Pattern.compile("<span class=\"[^\"]*\" title=\"[^\"]*\"></span>", 8);
    private static final Pattern blankStartSpanBeforeSpanPattern = Pattern.compile("^%s(\\s+)</span>(%s)(.*)".formatted("<span class=\"[^\"]*\" title=\"[^\"]*\">", "<span class=\"[^\"]*\" title=\"[^\"]*\">"), 8);

    public ReportSourceWriter(JavaFile javaFile) {
        this.javaFile = javaFile;
        this.title = javaFile.sourceFile.getFileName().toString();
        this.includeScripts = new String[]{"https://ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js", "https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.10.0/highlight.min.js"};
        this.cssFiles = new String[]{"css/source.css", "https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.10.0/styles/googlecode.min.css"};
        this.bodyScripts = new String[]{"js/syntax.js", "js/hits.js", "js/highlighter.js"};
    }

    @Override
    public void body() {
        this.preCodeElement();
    }

    private void preCodeElement() {
        this.content.append("<pre>\n");
        this.content.append("<code class=\"language-java\">\n");
        try {
            String sourceCode = Files.readString(this.javaFile.sourceFile, StandardCharsets.ISO_8859_1);
            StringBuilder builder = new StringBuilder();
            int prevIdx = 0;
            List<CodeInsert> tagInserts = this.getTagInserts(sourceCode);
            for (CodeInsert tagInsert : tagInserts) {
                builder.append(ReportUtil.escapeHtmlTagCharacters(sourceCode.substring(prevIdx, tagInsert.chPos())));
                prevIdx = tagInsert.chPos();
                builder.append(tagInsert.code());
            }
            builder.append(sourceCode.substring(prevIdx));
            String annotatedCode = builder.toString();
            annotatedCode = this.postProcessAnnotatedCode(annotatedCode);
            String tabledCode = this.getCodeTable(annotatedCode);
            this.content.append(tabledCode);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.content.append("</code>\n");
        this.content.append("</pre>\n");
    }

    private String getCodeTable(String annotatedCode) {
        String[] splitLines;
        StringBuilder builder = new StringBuilder();
        builder.append("<table>\n");
        int lineNr = 1;
        for (String line : splitLines = annotatedCode.split("\n")) {
            builder.append(String.format("<tr id=\"%s\">", lineNr));
            builder.append("<td class=\"code\">").append(line).append("</td>");
            builder.append("</tr>\n");
            ++lineNr;
        }
        builder.append("</table>\n");
        return builder.toString();
    }

    private String postProcessAnnotatedCode(String code) {
        code = blankStartSpanBeforeSpanPattern.matcher(code).replaceAll("$2$1$3");
        code = emptySpanPattern.matcher(code).replaceAll("");
        return code;
    }

    private List<CodeInsert> getTagInserts(String sourceCode) {
        char lf = '\n';
        ArrayList<CodeInsert> inserts = new ArrayList<CodeInsert>();
        inserts.add(new CodeInsert(0, "<span>"));
        for (Block block : this.javaFile.foundBlocks) {
            if (sourceCode.charAt(block.beg.pos()) != lf) {
                inserts.add(new CodeInsert(block.beg.pos(), "</span>"));
                inserts.add(new CodeInsert(block.beg.pos(), this.codeSpanAt(block.beg.pos())));
            }
            for (CodeRegion region : block.codeRegions) {
                if (sourceCode.charAt(region.beg.pos()) != lf) {
                    inserts.add(new CodeInsert(region.beg.pos(), "</span>"));
                    inserts.add(new CodeInsert(region.beg.pos(), this.codeSpanAt(region.beg.pos())));
                }
                if (sourceCode.charAt(region.end.pos()) == lf) continue;
                inserts.add(new CodeInsert(region.end.pos(), "</span>"));
                inserts.add(new CodeInsert(region.end.pos(), this.codeSpanAt(region.end.pos())));
            }
            if (sourceCode.charAt(block.end.pos()) == lf) continue;
            inserts.add(new CodeInsert(block.end.pos(), "</span>"));
            inserts.add(new CodeInsert(block.end.pos(), this.codeSpanAt(block.end.pos())));
        }
        int index = sourceCode.indexOf(lf);
        while (index >= 0) {
            inserts.add(new CodeInsert(index, "</span>"));
            inserts.add(new CodeInsert(index + 1, this.codeSpanAt(index + 1)));
            index = sourceCode.indexOf(lf, index + 1);
        }
        inserts.add(new CodeInsert(sourceCode.length(), "</span>"));
        inserts.sort(Comparator.comparing(CodeInsert::chPos));
        return inserts;
    }

    private String codeSpanAt(int chPos) {
        List<Block> activeBlocks = this.getActiveBlocksAtCharPosition(chPos);
        if (activeBlocks.isEmpty()) {
            return "<span>";
        }
        Block lastBlock = activeBlocks.get(activeBlocks.size() - 1);
        CodeRegion region = null;
        for (CodeRegion r : lastBlock.codeRegions) {
            if (r.beg.pos() > chPos || chPos >= r.end.pos()) continue;
            region = r;
        }
        return this.codeSpan(activeBlocks, lastBlock, region);
    }

    private String codeSpan(List<Block> activeBlocks, Block block, CodeRegion region) {
        long hits = region != null ? region.getHitCount() : block.hits;
        String coverageClass = hits > 0L ? "c" : "nc";
        this.title = ReportUtil.formatHitCount(hits) + " hit" + (hits == 1L ? "" : "s");
        String classes = "b " + (region != null ? "r " : "");
        classes = classes + activeBlocks.stream().map(b -> "b" + b.id).collect(Collectors.joining(" "));
        if (region != null) {
            classes = classes + " r" + activeBlocks.get((int)(activeBlocks.size() - 1)).id + "_" + region.id;
            if (!region.dependentBlocks.isEmpty()) {
                this.title = this.title + " (" + ReportUtil.formatHitCount(region.block.hits) + " - " + region.dependentBlocks.stream().map(b -> ReportUtil.formatHitCount(b.hits)).collect(Collectors.joining(" - ")) + ")";
                classes = ReportSourceWriter.getDependentBlockClasses(region) + " " + classes;
            }
        }
        return String.format("<span class=\"%s %s\" title=\"%s\">", coverageClass, classes, this.title);
    }

    private static String getDependentBlockClasses(CodeRegion region) {
        return region.dependentBlocks.stream().distinct().map(b -> "d" + b.id).collect(Collectors.joining(" "));
    }

    private List<Block> getActiveBlocksAtCharPosition(int chPos) {
        return this.javaFile.foundBlocks.stream().filter(b -> b.beg.pos() <= chPos && chPos < b.end.pos() && b.blockType.hasCounter()).collect(Collectors.toList());
    }

    @Override
    public Path getFileOutputPath() {
        return IO.getReportSourceFilePath((Path)this.javaFile.relativePath);
    }
}

