/*
 * Decompiled with CFR 0.152.
 */
package org.maxxq.maven.repository;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.model.Model;
import org.maxxq.maven.dependency.GAV;
import org.maxxq.maven.dependency.GetMavenRepoURL;
import org.maxxq.maven.dependency.IModelIO;
import org.maxxq.maven.dependency.ModelIO;
import org.maxxq.maven.repository.IRepository;
import org.maxxq.maven.repository.RepositoryException;

public class LocalFileRepository
implements IRepository {
    private static final Logger LOGGER = LogManager.getLogger(LocalFileRepository.class);
    private final Function<GAV, String> getMavenRepoPath;
    private final IModelIO modelIO;

    public LocalFileRepository(Path basePath) {
        this(basePath, new ModelIO());
    }

    LocalFileRepository(Path basePath, IModelIO modelIO) {
        this.getMavenRepoPath = new GetMavenRepoURL(basePath.toString());
        this.modelIO = modelIO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Model> readPom(GAV gav) {
        Path path = Paths.get(this.getMavenRepoPath.apply(gav), new String[0]);
        try {
            if (!Files.exists(path, new LinkOption[0])) return Optional.empty();
            LOGGER.trace("Reading pom from '{}'", (Object)path.toFile());
            try (FileInputStream input = new FileInputStream(path.toFile());){
                Optional<Model> optional = Optional.of(this.modelIO.getModelFromInputStream(input));
                return optional;
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Could not read from path: '" + path + "'", e);
        }
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public GAV store(Model model) {
        GAV gav = GAV.fromModel(model);
        Path path = Paths.get(this.getMavenRepoPath.apply(gav), new String[0]);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            LOGGER.trace("Writing pom to '{}'", (Object)path.toFile());
            try (FileOutputStream output = new FileOutputStream(path.toFile());){
                this.modelIO.writeModelToStream(model, output);
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Could not write to '" + path + "'", e);
        }
        return gav;
    }

    @Override
    public Optional<Metadata> getMetaData(String groupId, String artifactId) {
        return Optional.empty();
    }
}

