/*
 * Decompiled with CFR 0.152.
 */
package org.maxxq.maven.dependency;

import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;

public class GAV {
    private final String groupId;
    private final String artifactId;
    private final String version;

    public static GAV fromDependency(Dependency dependency) {
        return new GAV(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
    }

    public static GAV fromModel(Model model) {
        String groupId = model.getGroupId();
        String artifactId = model.getArtifactId();
        String version = model.getVersion();
        if (StringUtils.isEmpty((CharSequence)groupId) && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        if (StringUtils.isEmpty((CharSequence)version) && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        return new GAV(groupId, artifactId, version);
    }

    public static GAV fromParent(Parent parent) {
        return new GAV(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    public GAV(String groupId, String artifactId, String version) {
        if (StringUtils.isEmpty((CharSequence)groupId)) {
            throw new IllegalArgumentException("GroupId must not be null");
        }
        if (StringUtils.isEmpty((CharSequence)artifactId)) {
            throw new IllegalArgumentException("ArtifactId must not be null");
        }
        if (StringUtils.isEmpty((CharSequence)version)) {
            throw new IllegalArgumentException("Version must not be null");
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return "GAV [groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GAV other = (GAV)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

