/*
 * Decompiled with CFR 0.152.
 */
package org.maxxq.maven.configuration;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.maxxq.maven.dependency.GAV;
import org.maxxq.maven.dependency.POMUtils;
import org.maxxq.maven.repository.IRepository;

public class ResolveBuildConfigurationWorker
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(ResolveBuildConfigurationWorker.class);
    private final Model project;
    private final IRepository repository;
    private POMUtils pomUtils = new POMUtils();

    public ResolveBuildConfigurationWorker(Model project, IRepository repository) {
        if (project == null) {
            throw new IllegalArgumentException("input project must not be null");
        }
        this.project = project;
        this.repository = repository;
    }

    @Override
    public void run() {
        Parent parent = this.project.getParent();
        while (parent != null) {
            LOGGER.debug("Reading from parent with gav: {}", (Object)GAV.fromParent(parent));
            Optional<Model> modelForParent = this.repository.readPom(GAV.fromParent(parent));
            if (!modelForParent.isPresent()) {
                LOGGER.warn("Parent model with gav {} could not be loaded", (Object)GAV.fromParent(parent));
                return;
            }
            Model parentModel = modelForParent.get();
            this.copyNonExistingBuildPlugins(parentModel, this.project);
            this.copyConfigurationOfExistingPlugins(parentModel, this.project);
            this.copyNonExistingBuildManagementPlugins(parentModel, this.project);
            this.copyConfigurationOfExistingBuildManagementPlugins(parentModel, this.project);
            this.copyNonExistingProperties(parentModel, this.project);
            parent = parentModel.getParent();
        }
        this.applyDependencyManagement(this.project);
        this.resolvePropertiesForBuildPlugins();
    }

    private void resolvePropertiesForBuildPlugins() {
        if (this.project.getBuild() == null || this.project.getBuild().getPlugins() == null) {
            return;
        }
        this.project.getBuild().getPlugins().stream().forEach(plugin -> this.resolveProperties((Plugin)plugin));
    }

    private void resolveProperties(Plugin plugin) {
        int times = 0;
        while (this.hasPropertyValue(plugin)) {
            this.resolveGAV(plugin, this.project);
            if (times++ != 10) continue;
            return;
        }
    }

    private void resolveGAV(Plugin plugin, Model parentModel) {
        if (this.pomUtils.isPropertyValue(plugin.getGroupId())) {
            plugin.setGroupId(this.pomUtils.resolveProperty(plugin.getGroupId(), parentModel));
        }
        if (this.pomUtils.isPropertyValue(plugin.getArtifactId())) {
            plugin.setArtifactId(this.pomUtils.resolveProperty(plugin.getArtifactId(), parentModel));
        }
        if (this.pomUtils.isPropertyValue(plugin.getVersion())) {
            plugin.setVersion(this.pomUtils.resolveProperty(plugin.getVersion(), parentModel));
        }
        if (this.pomUtils.isPropertyValue(plugin.getConfiguration().toString())) {
            try {
                plugin.setConfiguration((Object)Xpp3DomBuilder.build((Reader)new StringReader(this.pomUtils.resolveProperty(plugin.getConfiguration().toString(), parentModel))));
            }
            catch (IOException | XmlPullParserException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean hasPropertyValue(Plugin plugin) {
        return this.pomUtils.isPropertyValue(plugin.getGroupId()) || this.pomUtils.isPropertyValue(plugin.getArtifactId()) || this.pomUtils.isPropertyValue(plugin.getVersion());
    }

    private void copyNonExistingProperties(Model parentModel, Model model) {
        if (model.getProperties() != null) {
            parentModel.getProperties().entrySet().stream().filter(entry -> !model.getProperties().containsKey(entry.getKey())).forEach(entry -> model.getProperties().put(entry.getKey(), entry.getValue()));
        }
    }

    private void copyConfigurationOfExistingPlugins(Model parentModel, Model model) {
        if (parentModel.getBuild() == null || parentModel.getBuild().getPlugins() == null) {
            return;
        }
        parentModel.getBuild().getPlugins().stream().forEach(plugin -> this.copyProperties((Plugin)plugin, this.getPlugin(model, (Plugin)plugin)));
    }

    private void copyConfigurationOfExistingBuildManagementPlugins(Model parentModel, Model model) {
        if (parentModel.getBuild() == null || parentModel.getBuild().getPluginManagement() == null || parentModel.getBuild().getPluginManagement().getPlugins() == null) {
            return;
        }
        parentModel.getBuild().getPluginManagement().getPlugins().stream().forEach(plugin -> this.copyProperties((Plugin)plugin, this.getBuildManagementPlugin(model, (Plugin)plugin)));
    }

    private void copyProperties(Plugin fromPlugin, Optional<Plugin> toPlugin) {
        toPlugin.ifPresent(plugin -> plugin.setConfiguration((Object)Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)plugin.getConfiguration()), (Xpp3Dom)((Xpp3Dom)fromPlugin.getConfiguration()))));
    }

    private Optional<Plugin> getPlugin(Model model, Plugin plugin) {
        return model.getBuild().getPlugins().stream().filter(p -> p.getGroupId().equals(plugin.getGroupId())).filter(p -> p.getArtifactId().equals(plugin.getArtifactId())).findFirst();
    }

    private Optional<Plugin> getBuildManagementPlugin(Model model, Plugin plugin) {
        return model.getBuild().getPluginManagement().getPlugins().stream().filter(p -> p.getGroupId().equals(plugin.getGroupId())).filter(p -> p.getArtifactId().equals(plugin.getArtifactId())).findFirst();
    }

    private void copyNonExistingBuildPlugins(Model parentModel, Model model) {
        if (parentModel.getBuild() == null || parentModel.getBuild().getPlugins() == null) {
            return;
        }
        parentModel.getBuild().getPlugins().stream().filter(plugin -> !this.modelHasPlugin(model, (Plugin)plugin)).forEach(plugin -> model.getBuild().addPlugin(plugin));
    }

    private void copyNonExistingBuildManagementPlugins(Model parentModel, Model model) {
        if (parentModel.getBuild() == null || parentModel.getBuild().getPluginManagement() == null || parentModel.getBuild().getPluginManagement().getPlugins() == null) {
            return;
        }
        parentModel.getBuild().getPluginManagement().getPlugins().stream().filter(plugin -> !this.modelHasBuildManagementPlugin(model, (Plugin)plugin)).forEach(plugin -> model.getBuild().getPluginManagement().addPlugin(plugin));
    }

    private boolean modelHasPlugin(Model model, Plugin plugin) {
        return model.getBuild().getPlugins().stream().filter(p -> p.getGroupId().equals(plugin.getGroupId())).anyMatch(p -> p.getArtifactId().equals(plugin.getArtifactId()));
    }

    private boolean modelHasBuildManagementPlugin(Model model, Plugin plugin) {
        return model.getBuild().getPluginManagement().getPlugins().stream().filter(p -> p.getGroupId().equals(plugin.getGroupId())).anyMatch(p -> p.getArtifactId().equals(plugin.getArtifactId()));
    }

    private void applyDependencyManagement(Model model) {
        if (model.getBuild() == null || model.getBuild().getPluginManagement() == null || model.getBuild().getPluginManagement().getPlugins() == null) {
            return;
        }
        model.getBuild().getPlugins().stream().forEach(plugin -> this.applyDependencyManagement((Plugin)plugin, model));
    }

    private void applyDependencyManagement(Plugin plugin, Model model) {
        if (model.getBuild() == null || model.getBuild().getPluginManagement() == null || model.getBuild().getPluginManagement().getPlugins() == null) {
            return;
        }
        model.getBuild().getPluginManagement().getPlugins().stream().filter(managedPlugin -> plugin.getArtifactId().equals(managedPlugin.getArtifactId())).filter(managedPlugin -> plugin.getGroupId().equals(managedPlugin.getGroupId())).findFirst().ifPresent(managedPlugin -> plugin.setVersion(managedPlugin.getVersion()));
    }
}

