/*
 * Decompiled with CFR 0.152.
 */
package org.maxxq.maven.dependency;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.maxxq.maven.dependency.ComparableDependency;
import org.maxxq.maven.dependency.DefaultDependencyFilter;
import org.maxxq.maven.dependency.DepencyResolvingException;
import org.maxxq.maven.dependency.GAV;
import org.maxxq.maven.dependency.IDependencyFilter;
import org.maxxq.maven.dependency.IPOMUtils;
import org.maxxq.maven.dependency.ModelIO;
import org.maxxq.maven.dependency.POMUtils;
import org.maxxq.maven.dependency.ResolveRange;
import org.maxxq.maven.repository.IRepository;

public class ResolveDependenciesWorker
implements java.util.function.Supplier<Set<Dependency>> {
    private static final Logger LOGGER = LogManager.getLogger(ResolveDependenciesWorker.class);
    private final Model project;
    private final IRepository repository;
    private final IPOMUtils pomUtils = new POMUtils();
    private final Function<GAV, Optional<String>> resolveRange;
    private Map<GAV, Set<Dependency>> cachedDependencies = new HashMap<GAV, Set<Dependency>>();
    private final boolean ignoreInconsistencies;
    private final IDependencyFilter dependencyFilter;

    public ResolveDependenciesWorker(Model project, IRepository repository, boolean ignoreInconsistencies, IDependencyFilter dependencyFilter) {
        if (project == null) {
            throw new IllegalArgumentException("input project must not be null");
        }
        this.project = project;
        this.repository = repository;
        this.resolveRange = new ResolveRange(repository);
        this.ignoreInconsistencies = ignoreInconsistencies;
        this.dependencyFilter = dependencyFilter == null ? new DefaultDependencyFilter() : dependencyFilter;
    }

    @Override
    public Set<Dependency> get() {
        return this.processPomStream(this.project, null, 0);
    }

    private Set<Dependency> processPomStream(Model model, List<Exclusion> exclusions, int depth) {
        GAV gav = GAV.fromModel(model);
        if (this.cachedDependencies.containsKey(gav)) {
            LOGGER.debug("Returning cached dependencies for: {}", (Object)gav);
            return this.cachedDependencies.get(gav);
        }
        try {
            Set<Dependency> dependencies = new LinkedHashSet<Dependency>();
            this.cachedDependencies.put(gav, dependencies);
            LOGGER.debug("Retrieving dependencies for: {}", (Object)gav);
            boolean allParentsLoaded = this.getConfigurationsFromParent(model);
            this.resolveAllPropertiesInAllSections(model);
            this.resolveImportedDependencies(model);
            this.applyDependencyManagement(model, allParentsLoaded);
            this.resolveRanges(model);
            this.addDependenciesToList(dependencies, model, exclusions, depth);
            this.addTransitiveDependencieswToList(dependencies, model, exclusions, depth);
            if (this.becauseDependencyManagementIsNotTransitiveOnlyApplyOnRootPom(depth)) {
                this.copyVersionsFromDependencyManagement(dependencies, model.getDependencyManagement().getDependencies());
            }
            dependencies = this.removeDuplicates(dependencies);
            return this.removeExclusions(dependencies, exclusions);
        }
        catch (DepencyResolvingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DepencyResolvingException("Could not resolve dependencies", e);
        }
    }

    private Set<Dependency> removeDuplicates(Set<Dependency> dependencies) {
        return dependencies.stream().map(dependency -> new ComparableDependency((Dependency)dependency)).distinct().map(dependency -> dependency.getDependency()).collect(Collectors.toSet());
    }

    private Set<Dependency> removeExclusions(Set<Dependency> dependencies, List<Exclusion> exclusions) {
        return dependencies.stream().filter(dependency -> !this.isExcluded((Dependency)dependency, exclusions)).collect(Collectors.toSet());
    }

    private void resolveRanges(Model model) {
        model.getDependencies().stream().filter(dependency -> ResolveRange.isRange(dependency.getVersion())).forEach(dependency -> this.resolveVersionRange((Dependency)dependency));
    }

    private void resolveVersionRange(Dependency dependency) {
        this.resolveRange.apply(GAV.fromDependency(dependency)).ifPresent(version -> dependency.setVersion(version));
    }

    private void removeDoubleDependencies(Model model) {
        List dependenciesWhichCanBeRemoved = model.getDependencies().stream().filter(dependency -> StringUtils.isEmpty((CharSequence)dependency.getVersion())).filter(dependency -> this.modelHasVersionInOtherDependency((Dependency)dependency, model)).collect(Collectors.toList());
        model.getDependencies().removeAll(dependenciesWhichCanBeRemoved);
    }

    private boolean modelHasVersionInOtherDependency(Dependency dependencyWithoutVersion, Model model) {
        return model.getDependencies().stream().filter(dependency -> dependency.getGroupId().equals(dependencyWithoutVersion.getGroupId())).filter(dependency -> dependency.getArtifactId().equals(dependencyWithoutVersion.getArtifactId())).anyMatch(dependency -> !StringUtils.isEmpty((CharSequence)dependency.getVersion()));
    }

    private boolean becauseDependencyManagementIsNotTransitiveOnlyApplyOnRootPom(int depth) {
        return depth == 0;
    }

    private void resolveProperties(Dependency dependency, Model model) {
        int times = 0;
        while (this.hasPropertyValue(dependency)) {
            this.resolveGAV(dependency, model);
            if (times++ != 10) continue;
            return;
        }
    }

    private boolean hasPropertyValue(Dependency dependency) {
        return this.pomUtils.isPropertyValue(dependency.getGroupId()) || this.pomUtils.isPropertyValue(dependency.getArtifactId()) || this.pomUtils.isPropertyValue(dependency.getVersion());
    }

    private void addDependenciesToList(Set<Dependency> dependencies, Model model, List<Exclusion> exclusions, int depth) {
        model.getDependencies().stream().map(dependency -> this.addDefaults((Dependency)dependency)).filter(dependency -> !dependency.isOptional()).filter(dependency -> this.dependencyFilter.keepDependency((Dependency)dependency, depth)).filter(dependency -> !this.isExcluded((Dependency)dependency, exclusions)).forEach(dependency -> dependencies.add((Dependency)dependency));
    }

    private Dependency addDefaults(Dependency dependency) {
        if (dependency.getScope() == null) {
            dependency.setScope("compile");
        }
        return dependency;
    }

    private void addTransitiveDependencieswToList(Set<Dependency> dependencies, Model model, List<Exclusion> exclusions, int depth) {
        model.getDependencies().stream().map(dependency -> this.addDefaults((Dependency)dependency)).filter(dependency -> !dependency.isOptional()).filter(dependency -> this.dependencyFilter.keepDependency((Dependency)dependency, depth)).filter(dependency -> !this.isExcluded((Dependency)dependency, exclusions)).forEach(dependency -> dependencies.addAll(this.filterDependenciesAlreadyAdded(this.getTransitiveDependencies((Dependency)dependency, depth), dependencies)));
    }

    private void resolveImportedDependencies(Model model) {
        Set<Dependency> importedManagedDependencies = this.getManagedDependencyImports(model);
        this.copyNonExistingDependencies(importedManagedDependencies, model.getDependencyManagement().getDependencies());
    }

    private void copyNonExistingDependencies(Collection<Dependency> fromDependencies, List<Dependency> toDependencies) {
        fromDependencies.stream().filter(dependency -> !this.dependencyFoundWithVersion((Dependency)dependency, toDependencies)).forEach(dependency -> toDependencies.add((Dependency)dependency));
    }

    private Set<Dependency> getManagedDependencyImports(Model model) {
        this.getConfigurationsFromParent(model);
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        dependencies.addAll(model.getDependencyManagement().getDependencies().stream().filter(dependency -> !this.isPomImport((Dependency)dependency)).collect(Collectors.toSet()));
        model.getDependencyManagement().getDependencies().stream().filter(dependency -> this.isPomImport((Dependency)dependency)).flatMap(importDependency -> this.getManagedDependencies((Dependency)importDependency).stream()).forEach(dependency -> this.addIfNotExisting((Dependency)dependency, (Set<Dependency>)dependencies));
        return dependencies;
    }

    private void addIfNotExisting(Dependency dependencyToAdd, Set<Dependency> dependencies) {
        if (!this.dependencyExist(dependencyToAdd, dependencies)) {
            dependencies.add(dependencyToAdd);
        }
    }

    public Set<Dependency> getManagedDependencies(Dependency importDependency) {
        return this.repository.readPom(GAV.fromDependency(importDependency)).map(model -> this.getManagedDependencyImports((Model)model)).orElse(new LinkedHashSet());
    }

    private boolean isPomImport(Dependency dependency) {
        return "import".equals(dependency.getScope()) && "pom".equals(dependency.getType());
    }

    private List<Dependency> filterDependenciesAlreadyAdded(Set<Dependency> transitiveDependencies, Set<Dependency> dependencies) {
        return transitiveDependencies.stream().filter(dependency -> !this.dependencyExist((Dependency)dependency, (Collection<Dependency>)dependencies)).collect(Collectors.toList());
    }

    private boolean dependencyExist(Dependency dependency, Collection<Dependency> dependencies) {
        return dependencies.stream().filter(dep -> dep.getGroupId().equals(dependency.getGroupId())).anyMatch(dep -> dep.getArtifactId().equals(dependency.getArtifactId()));
    }

    private boolean isExcluded(Dependency dependency, List<Exclusion> exclusions) {
        if (exclusions == null || exclusions.isEmpty()) {
            return false;
        }
        return exclusions.stream().filter(exclusion -> exclusion.getGroupId().equals(dependency.getGroupId())).anyMatch(exclusion -> exclusion.getArtifactId().equals(dependency.getArtifactId()));
    }

    private Set<Dependency> getTransitiveDependencies(Dependency dependency, int depth) {
        LOGGER.trace("Following transitive dependencies of: {}", (Object)GAV.fromDependency(dependency));
        return this.repository.readPom(GAV.fromDependency(dependency)).map(model -> this.processPomStream((Model)model, dependency.getExclusions(), depth + 1)).orElse(new LinkedHashSet());
    }

    private void applyDependencyManagement(Model model, boolean allParentsLoaded) {
        model.getDependencies().stream().forEach(dependency -> this.applyDependencyManagement((Dependency)dependency, model));
        model.getDependencies().stream().forEach(dependency -> LOGGER.trace("dependency within {} after applying dependency management: {}:{}:{} scope:{}", (Object)GAV.fromModel(model), (Object)dependency.getGroupId(), (Object)dependency.getArtifactId(), (Object)dependency.getVersion(), (Object)dependency.getScope()));
        this.removeDoubleDependencies(model);
        if (this.ignoreInconsistencies) {
            this.removeIncompleteDependencies(model);
        } else {
            this.detectUnresolvedVersions(model, allParentsLoaded);
        }
    }

    private void applyDependencyManagement(Dependency dependency, Model model) {
        this.copyVersionScopeAndExclusionsFromDependencyManagement(dependency, model);
    }

    private void removeIncompleteDependencies(Model model) {
        List dependenciesToRemove = model.getDependencies().stream().filter(dependency -> StringUtils.isEmpty((CharSequence)dependency.getVersion())).collect(Collectors.toList());
        model.getDependencies().removeAll(dependenciesToRemove);
        if (!dependenciesToRemove.isEmpty()) {
            String missingVersionsfor = dependenciesToRemove.stream().map(dependency -> dependency.getGroupId() + ":" + dependency.getArtifactId()).collect(Collectors.joining(","));
            LOGGER.warn("Inconsistencies are ignored and a {} have been found in {} no versions could be resolved for: '{}'", (Object)dependenciesToRemove.size(), (Object)GAV.fromModel(model), (Object)missingVersionsfor);
        }
    }

    private void detectUnresolvedVersions(Model model, boolean allParentsLoaded) {
        model.getDependencies().stream().forEach(dependency -> this.detectUnresolvedVersions((Dependency)dependency, model, allParentsLoaded));
    }

    private void detectUnresolvedVersions(Dependency resolveVersion, Model model, boolean allParentsLoaded) {
        if (StringUtils.isEmpty((CharSequence)resolveVersion.getVersion())) {
            LOGGER.error("After copying the versions from the dependency management the version for {}:{} in pom {} is still empty, model: {}", new Supplier[]{() -> resolveVersion.getGroupId(), () -> resolveVersion.getArtifactId(), () -> GAV.fromModel(model), () -> new ModelIO().writeModelToString(model)});
            if (!allParentsLoaded) {
                LOGGER.error("<-- This is likely caused by a inconsistency in one of the pom file referrring to an incorrect parent pom file, check the parent defined for {}", (Object)GAV.fromModel(model));
                throw new DepencyResolvingException("An inconsistency has been found in the pom definitions, probably the parent of " + GAV.fromModel(model) + " is not correctly defined");
            }
            throw new DepencyResolvingException(GAV.fromModel(model) + " has dependency issues, the version of " + resolveVersion.getGroupId() + ":" + resolveVersion.getArtifactId() + " could not be defined, even after obtainining managed versions from the parents");
        }
    }

    private void copyVersionScopeAndExclusionsFromDependencyManagement(Dependency resolveVersion, Model model) {
        model.getDependencyManagement().getDependencies().stream().filter(dependency -> dependency.getGroupId().equals(resolveVersion.getGroupId())).filter(dependency -> dependency.getArtifactId().equals(resolveVersion.getArtifactId())).findFirst().ifPresent(dependency -> this.copyVersionScopeAndExclusionsTo((Dependency)dependency, resolveVersion));
    }

    private void copyVersionScopeAndExclusionsTo(Dependency managedDependency, Dependency dependency) {
        if (!StringUtils.isEmpty((CharSequence)managedDependency.getVersion())) {
            dependency.setVersion(managedDependency.getVersion());
        }
        if (StringUtils.isEmpty((CharSequence)dependency.getScope())) {
            dependency.setScope(managedDependency.getScope());
        }
        if (managedDependency.getExclusions() != null && !managedDependency.getExclusions().isEmpty()) {
            dependency.getExclusions().addAll(managedDependency.getExclusions());
        }
    }

    private boolean getConfigurationsFromParent(Model model) {
        if (model.getDependencyManagement() == null) {
            model.setDependencyManagement(new DependencyManagement());
        }
        Parent parent = model.getParent();
        while (parent != null) {
            LOGGER.debug("Reading from parent with gav: {}", (Object)GAV.fromParent(parent));
            Optional<Model> modelForParent = this.repository.readPom(GAV.fromParent(parent));
            if (!modelForParent.isPresent()) {
                LOGGER.warn("Parent model with gav {} could not be loaded", (Object)GAV.fromParent(parent));
                return false;
            }
            Model parentModel = modelForParent.get();
            this.copyNonExistingManagedDependencies(parentModel, model);
            this.copyNonExistingDependencies(parentModel, model);
            this.copyNonExistingProperties(parentModel, model);
            parent = parentModel.getParent();
        }
        this.resolveAllPropertiesInAllSections(model);
        return true;
    }

    private void resolveAllPropertiesInAllSections(Model model) {
        this.resolveAllPropertiesInDependencies(model.getDependencyManagement().getDependencies(), model);
        this.resolveAllPropertiesInDependencies(model.getDependencies(), model);
    }

    private void resolveAllPropertiesInDependencies(List<Dependency> dependencies, Model model) {
        dependencies.stream().forEach(dependency -> this.resolveProperties((Dependency)dependency, model));
    }

    private void copyNonExistingManagedDependencies(Model parentModel, Model model) {
        if (parentModel.getDependencyManagement() != null && parentModel.getDependencyManagement().getDependencies() != null) {
            parentModel.getDependencyManagement().getDependencies().stream().map(dependency -> this.resolveGAV((Dependency)dependency, parentModel)).filter(dependency -> !this.dependencyFoundWithVersion((Dependency)dependency, model.getDependencyManagement().getDependencies())).forEach(dependency -> model.getDependencyManagement().addDependency(dependency));
        }
    }

    private void copyNonExistingDependencies(Model parentModel, Model model) {
        if (parentModel.getDependencies() != null) {
            parentModel.getDependencies().stream().map(dependency -> this.resolveGAV((Dependency)dependency, parentModel)).filter(dependency -> !this.dependencyFoundWithVersion((Dependency)dependency, model.getDependencies())).forEach(dependency -> model.addDependency(dependency));
        }
    }

    private void copyNonExistingProperties(Model parentModel, Model model) {
        if (model.getProperties() != null) {
            parentModel.getProperties().entrySet().stream().filter(entry -> !model.getProperties().containsKey(entry.getKey())).forEach(entry -> model.getProperties().put(entry.getKey(), entry.getValue()));
        }
    }

    private boolean dependencyFoundWithVersion(Dependency search, List<Dependency> dependencies) {
        return dependencies.stream().filter(dependency -> dependency.getGroupId().equals(search.getGroupId())).filter(dependency -> dependency.getArtifactId().equals(search.getArtifactId())).anyMatch(dependency -> !StringUtils.isEmpty((CharSequence)dependency.getVersion()));
    }

    private Dependency resolveGAV(Dependency dependency, Model parentModel) {
        if (this.pomUtils.isPropertyValue(dependency.getGroupId())) {
            dependency.setGroupId(this.pomUtils.resolveProperty(dependency.getGroupId(), parentModel));
        }
        if (this.pomUtils.isPropertyValue(dependency.getArtifactId())) {
            dependency.setArtifactId(this.pomUtils.resolveProperty(dependency.getArtifactId(), parentModel));
        }
        if (this.pomUtils.isPropertyValue(dependency.getVersion())) {
            dependency.setVersion(this.pomUtils.resolveProperty(dependency.getVersion(), parentModel));
        }
        return dependency;
    }

    private void copyVersionsFromDependencyManagement(Set<Dependency> dependencies, List<Dependency> managedDependencies) {
        dependencies.stream().forEach(dependency -> this.copyVersionIfManaged((Dependency)dependency, managedDependencies));
    }

    private void copyVersionIfManaged(Dependency dependency, List<Dependency> managedDependencies) {
        managedDependencies.stream().filter(managedDependency -> managedDependency.getGroupId().equals(dependency.getGroupId())).filter(managedDependency -> managedDependency.getArtifactId().equals(dependency.getArtifactId())).forEach(managedDependency -> this.copyVersionScopeAndExclusionsTo((Dependency)managedDependency, dependency));
    }
}

