/*
 * Decompiled with CFR 0.152.
 */
package org.maxxq.maven.repository;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.model.Model;
import org.maxxq.maven.dependency.GAV;
import org.maxxq.maven.repository.IRepository;

public class InMemoryCachingRepository
implements IRepository {
    private final IRepository repository;
    private final Map<GAV, Optional<Model>> cache = new HashMap<GAV, Optional<Model>>();
    private final Map<String, Optional<Metadata>> metacache = new HashMap<String, Optional<Metadata>>();

    public InMemoryCachingRepository(IRepository repository) {
        this.repository = repository;
    }

    @Override
    public Optional<Model> readPom(GAV gav) {
        if (this.cache.containsKey(gav)) {
            return this.cache.get(gav);
        }
        Optional<Model> model = this.repository.readPom(gav);
        this.cache.put(gav, model);
        return model;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public GAV store(Model model) {
        GAV gav = GAV.fromModel(model);
        this.cache.put(gav, Optional.of(model));
        return gav;
    }

    @Override
    public Optional<Metadata> getMetaData(String groupId, String artifactId) {
        String key = groupId + "-" + artifactId;
        if (this.metacache.containsKey(key)) {
            return this.metacache.get(key);
        }
        Optional<Metadata> metadata = this.repository.getMetaData(groupId, artifactId);
        this.metacache.put(key, metadata);
        return metadata;
    }
}

